$(document).ready(function ($) {
    $("select").select2({placeholder: 'Seleccione'});
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
    $("#txtFecha_desde,#txtFecha_hasta").change(function(event) {  validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta'); });

    $("#slcSucursal").change(function(event) {
        event.preventDefault();
        limpiar_select('Cargando...');
        if ($(this).val()>0) {
            id = $(this).val();
            url_ajax = window.satelite.base_url('encuesta/procesos/filtrar_encuesta_sucursal');                
            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    id_sucursal: id
                },
                beforeSend: function () {
                    wait.start('Cargando encuestas ..');
                },
                error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $("#slcEncuesta").html(json.html_option);
                    $("#slcEncuesta").attr('placeholder', 'Seleccione');
                    $("#slcEncuesta").select2();
                    wait.close();
                }
            });
        } else {
            limpiar_select('Seleccione');
        }
    });

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            txtFecha_desde: {required: true},
            txtFecha_hasta: {required: true},
            slcSucursal: {required: false},
            slcEncuesta: {required: false}
        },
        messages: {
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido",
            slcSucursal: "Campo requerido",
            slcEncuesta: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select')) {
                $(element).next().append(error);
            } else {
                error.insertAfter(element);
            }
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");
        },
        submitHandler: function (form) {
            url_ajax = window.satelite.base_url('encuesta/procesos/exportar_datos');
            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    txtFecha_desde: $("#txtFecha_desde").val(),
                    txtFecha_hasta: $("#txtFecha_hasta").val(),
                    slcAgencia: $("#slcSucursal").val(),
                    slcEncuesta: $("#slcEncuesta").val()
                },
                beforeSend: function () {
                    wait.start();
                },
                error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $("#hdn_txtFecha_desde").val($("#txtFecha_desde").val());
                    $("#hdn_txtFecha_hasta").val($("#txtFecha_hasta").val());
                    $("#hdn_slcEncuesta").val($("#slcEncuesta").val());
                    $("#contenedorTabla").html(json.html);
                    $('#exportar').show();
                    wait.close();
                }
            });
        }
    });

});

    function limpiar_select(placeholder_select) {
        $("#slcEncuesta").html('<option value=""></option>');
        $("#slcEncuesta").attr('placeholder', placeholder_select);
        $("#slcEncuesta").select2();        
    }