jQuery(document).ready(function ($) {
    $('select').select2();
    $("#form_agregar").validate({
        ignore: "",
        rules: {
            categoria: {required: true, min:1},
            numero_detalles_lista: {required: true, min:1},
            
        },
        messages: {
            numero_detalles_lista:{
              "required" : "Campo requerido",
              "min" : "Agregar al menos un detalle",
            },
            categoria: "Campo requerido"
        
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            console.log(error)
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }
        },
        submitHandler: function (form) {
               wait.start();
               form.submit();
       }
   });
    

    $("#agregar_lista").click(function(event) {
        event.preventDefault();
        tr = '';
        if ($("#slcRespuesta").val() > 0 && $("#slcPregunta").val() > 0 ) {
            id_pregunta = $("#slcPregunta").val();
            txt_pregunta =  $("#slcPregunta option[value='"+id_pregunta+"']").text();
            id_respuesta = $("#slcRespuesta").val();
            txt_respuesta =  $("#slcRespuesta option[value='"+id_respuesta+"']").text();
            n_reg = $("#contenedor_detalle_respuesta tr").length;
            if ($("#res_"+id_respuesta).length>0) {
                crear_alerta('error', 'Error', 'La respuesta ya existe');
            } else {
            tr += '<tr id="res_'+id_respuesta+'" >';
            tr += '<td style="text-align: center;  display: none;" >'+((n_reg == 0)? '':'Y')+'</td>';
            tr += '<td style="text-align: center;" >';
            tr += '<input type="hidden" value="'+id_pregunta+'" name="detalle_pre[]" >'
            tr += '<input type="hidden" value="'+id_respuesta+'" name="detalle_res[]" >'
            tr += txt_pregunta + '</td>';
            tr += '<td style="text-align: center;" >'+'='+'</td>';
            tr += '<td style="text-align: center;" >'+txt_respuesta+'</td>';
            tr += '<td style="text-align: center;" >';
            tr += '<button  type="button"  class="tip eliminar_detalle" oldtitle="Eliminar" title="Eliminar" >';
            tr += '<span class="icon16 icomoon-icon-cancel-3"></span> Eliminar';
            tr += '</button>';
            tr += '</td>';
            tr += '</tr>';
            $("#contenedor_detalle_respuesta").append(tr);
            $("#respuesta").val('');
            $("#numero_detalles_lista").val($("#contenedor_detalle_respuesta tr").length);
            $("#slcPregunta option").removeAttr('selected');
            $("#slcPregunta").select2();
            $("#slcPregunta").trigger('change');
            }

        } else {
            crear_alerta('error', 'Error', 'La respuesta es obligatoria');
        }
    });

    $("body").on('click','.eliminar_detalle', function(e) {
        e.preventDefault();
        $(this).parent().parent().remove();
        $("#numero_detalles_lista").val($("#contenedor_detalle_respuesta tr").length); 
    });

    $("body").on('change', '#categoria', function(event) {
        event.preventDefault();
        var id_cat = $(this).val();
        if (id_cat > 0) 
        {
            $("#contenedor_detalle_respuesta").html("");
            $("#numero_detalles_lista").val('');
               $.ajax({
                   url:window.satelite.base_url('encuesta/procesos/preguntas_categoria_enc'),
                   type: 'POST',
                   dataType: 'json',
                   data: {
                       categoria: $("#categoria").val(),
                       id_enc: $("#id_encuesta").val()
                   },
                   beforeSend: function () {
                       wait.start('cargando preguntas...');
                   },
                   error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    wait.close();
                    if(json.exito==1) {
                        $("#slcPregunta").html(json.html_option);
                        $("#slcPregunta").select2();
                    }

                }
            });
        } else {
            $("#slcPregunta").html('<option></option>');
            $("#slcPregunta").select2();
            $("#slcRespuesta").html('<option></option>');
            $("#slcRespuesta").select2();
        }
    });

    $("body").on('change', '#slcPregunta', function(event) {
        event.preventDefault();
        var id_pre = $(this).val();
        if (id_pre > 0) 
        {
               $.ajax({
                   url:window.satelite.base_url('encuesta/procesos/respuesta_pregunta_enc'),
                   type: 'POST',
                   dataType: 'json',
                   data: {
                       id_pre: $("#slcPregunta").val()
                   },
                   beforeSend: function () {
                       wait.start('cargando respuestas...');
                   },
                   error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    wait.close();
                    if(json.exito==1) {
                        $("#slcRespuesta").html(json.html_option);
                        $("#slcRespuesta").select2();
                    }

                }
            });
        }  else {
            $("#slcRespuesta").html('<option></option>');
            $("#slcRespuesta").select2();
        }
    });

});

