jQuery(document).ready(function ($) {

    $("select").select2();

    $('body').on('change', '#cla_dependencia', function (event) {
        validar_clasificacion();
    });

    /*#########################################################################*/
    $("#agregar_form").validate({
        ignore: "",
        rules: {
            cla_nombre: {
                required: true
            },
            'cla_id_niv': {
                required: true
            },
            'cla_estado': {
                required: true
            }
        },
        messages: {
            cla_nombre: "Campo requerido",
            'cla_id_niv': "Campo requerido",
            'cla_estado': "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select')) {
                //$(element).next().append(error);
                $(element).closest("div .row-fluid").append(error);
            } else {
                //$(element).next().append(error);
                error.insertAfter(element);
                //$("#error_fecha").html(error);
            }

            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");
        },
        submitHandler: function (form) {
            url_ajax = window.satelite.base_url('encuesta/catalogos/validar_nombrenivel');

            $.ajax({
                url: url_ajax,
                type: 'POST',
                dataType: 'json',
                data: {
                    cla_id_niv: $("#cla_id_niv").val(),
                    nombre: $("#cla_nombre").val(),
                },
                beforeSend: function () {
                    wait.start();
                },
                error: function (xhr, status, error) {
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (result) {
                    console.log(result.participacion)

                    if(result.participacion == "Si"){
                        wait.close();
                        crear_alerta('error', 'Nombre Duplicado', 'El nombre ingresado ya existe para nivel seleccionado, favor corregir.');  
                        return false; 
                    }else{
                        wait.start();
                        form.submit();
                    }                
                    
                }
            });
            
        }
    });
    /*#########################################################################*/


    $('body').on('change', '#cla_tipo', function (event) {
        if($(this).val() == 3){
            $("#condicional_pregunta").show()
        } else {
            $("#condicional_pregunta").hide()
        }
    });

    $('body').on('click', '#agregar_condicion', function (event) {
        agregar_detalles();
    });

    $('body').on('click', '.eliminar_detalle_lista', function (event) {
        $(this).closest("tr").remove();
    });

    $('body').on('change', '#encuesta', function (event) {
        $.ajax({
            url: window.satelite.base_url('encuesta/catalogos/get_preguntasxenc'),
            type: 'POST',
            dataType: 'json',
            data: {
                encuesta_id: $(this).val()
            },
            beforeSend: function () {
                wait.start('Por favor espere unos segundos');
            },
            error: function (xhr, status, error) {
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                wait.close();
                $("#pregunta").select2("destroy");
                $("#pregunta").html(json.options);
                $("#pregunta").select2();

            }
        });
    });

    $('body').on('change', '#pregunta', function (event) {
        $.ajax({
            url: window.satelite.base_url('encuesta/catalogos/get_respuestasxpre'),
            type: 'POST',
            dataType: 'json',
            data: {
                pregunta_id: $(this).val()
            },
            beforeSend: function () {
                wait.start('Por favor espere unos segundos');
            },
            error: function (xhr, status, error) {
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                wait.close();
                $("#respuesta").select2("destroy");
                $("#respuesta").html(json.options);
                $("#respuesta").select2();

            }
        });
    });

    $("#cancelar").click(function (event) {
        alerta_confirm_ajax(regresar, data, 'Confirmar regresar al registro', 'Los datos que insertaste no han sido guardados. ¿Éstas seguro que quieres regresar a la lista?');
    });


});

function validar_clasificacion() {
    if ($("#cla_dependencia").val() > 0) {
        $.ajax({
            url: window.satelite.base_url('encuesta/catalogos/validar_nivel'),
            type: 'POST',
            dataType: 'json',
            data: {
                clasificacion: $("#cla_dependencia").children(":selected").attr("value")
            },
            beforeSend: function () {
                wait.start('Validando nivel... Por favor espere unos segundos');
            },
            error: function (xhr, status, error) {
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                wait.close();
                if (parseInt(json.id_nivel) > 0) {
                    $("#cla_id_niv option[value='" + json.id_nivel + "']").attr('selected', true);
                    $("#cla_id_niv").select2();
                    $("#cla_id_niv").select2('disable');
                } else {
                    $("#cla_id_niv option:first").next().attr('selected', true); //la 1er opción
                    $("#cla_id_niv").select2();
                    $("#cla_id_niv").select2('disable');
                }

            }
        });
    } else {
        $("#cla_id_niv option:first").next().attr('selected', true); //la 1er opción
        $("#cla_id_niv").select2();
        $("#cla_id_niv").select2('disable');
    }
}

function agregar_detalles() {
    var encuesta_id = $("#encuesta").val();
    var encuesta_texto = $("#encuesta option:selected").text();
    var pregunta_id = $("#pregunta").val();
    var pregunta_texto = $("#pregunta option:selected").text();
    var respuesta_id = $("#respuesta").val();
    var respuesta_texto = $("#respuesta option:selected").text();
    if (respuesta_id == 0 || respuesta_id == ''){
        crear_alerta('error', 'Respuesta requerida', 'Debe elegir una respuesta');
        return false;
    }

    var html = "<tr>";
        html += '<input type="hidden" value="0" name="ppc_id[]" >';
        html += "<td>" + encuesta_texto;
        html += '<input type="hidden" value="' + encuesta_id + '" name="encuesta_id[]" >';
        html += "</td>";
        html += "<td>" + pregunta_texto;
        html += '<input type="hidden" value="' + pregunta_id + '" name="pregunta_id[]" >';
        html += "</td>";
        html += "<td>" + respuesta_texto;
        html += '<input type="hidden" value="' + respuesta_id + '" name="respuesta_id[]" >';
        html += "</td>";
        html += "<td>";
        html += '<button  type="button"  class="tip eliminar_detalle_lista" oldtitle="Eliminar" title="Eliminar" >';
        html += '<span class="icon16 icomoon-icon-cancel-3"></span> Eliminar';
        html += '</button>';
        html += "</td>";
    html += "</tr>";
    console.log(html);
    $("#contenedor_condicion_pregunta").append(html);

    $(".select_con").select2("destroy");
    $("#encuesta").val('');
    $("#pregunta").val('');
    $("#respuesta").val('');
    $(".select_con").select2();

}

function regresar() {
    window.location.href = window.satelite.base_url('encuesta/catalogos/clasificacion_encuesta');
}