$(document).ready(function () {

    $(".select").select2();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#reporte").validate({
        rules: {
           
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var slc_cliente         = $("#slc_cliente").val();
            var slc_cliente_nombre = $("#slc_cliente option:selected").text();

            // if (slc_cliente == "") {
            //     crear_alerta('error', 'Reporte de estado de incidencias por cliente', 'Campo cliente es requerido.');
            //     return false;
            // }

            var slc_sprint          = $("#slc_sprint").val();
            var slc_sprint_nombre   = "";

            $("#slc_sprint option").each(function (key, value) {
                if($(this).is(':selected')){
                    if(key ==1){
                        slc_sprint_nombre += $(this).html();    
                    }else{
                        slc_sprint_nombre += ' , ' + $(this).html();    
                    }
                    
                }
            });

            var estado           = $("#chk_sprint_activos").val();

            var slc_estapa          = $("#slc_estapa").val();
            var slc_estapa_nombre   = "";

            $("#slc_estapa option").each(function (key, value) {
                if($(this).is(':selected')){
                    if(key ==1){
                        slc_estapa_nombre += $(this).html();    
                    }else{
                        slc_estapa_nombre += ' , ' + $(this).html();    
                    }
                    
                }
            });

            $("#filtro_cliente").val(slc_cliente);
            $("#filtro_cliente_nombre").val(slc_cliente_nombre);

            $("#filtro_sprint").val(slc_sprint);
            $("#filtro_sprint_nombre").val(slc_sprint_nombre);

            //$("#filtro_estado").val(fecha_ini);

            $("#filtro_etapa").val(slc_estapa);
            $("#filtro_etapa_nombre").val(slc_estapa_nombre);
            
            form.submit();
        }
    });

    $("#chk_sprint_activos").iButton({
        'labelOn': ' Si ',
        'labelOff': ' No ',
        change: function (element) {
            if (element.is(':checked')) {
                $("#chk_sprint_activos").val(1);
            } else {
                $("#chk_sprint_activos").val(0);
            }
            if ( $("#slc_cliente").val() != "" ) {
                var cliente = $("#slc_cliente").val();
                get_sprintxcliente(cliente);
            } else {
                $("#slc_sprint").select2('data',null);
                $("#slc_sprint").empty();
            }
        }
    });

    $("#slc_cliente").change(function (){
        if ( $("#slc_cliente").val() == "") {
            $("#slc_sprint").select2('data',null);
            $("#slc_sprint").empty();
        } else { 
            var cliente = $(this).val();
            get_sprintxcliente(cliente);
        }
    });  

    function get_sprintxcliente(cliente){
        var estado = $("#chk_sprint_activos").val();
        $.ajax({
            url: urlj + 'desarrollo/salidas/get_sprintxcliente',
            data:{cliente:cliente,estado:estado},
            type: 'POST',
            dataType: 'text',
            beforeSend: function () {
                wait.start();
            },
            success: function(data){
                wait.close();
                $("#slc_sprint").html(data);
                $("#slc_sprint").select2();
            }
        });
    }

    $("#btnConsultar").click(function(){
        event.preventDefault();
        var slc_cliente        = $("#slc_cliente").val();
        var slc_cliente_nombre = $("#slc_cliente option:selected").text();

        if ($("#txtFechaIni_1").val() == '' && $("#txtFechaIni_2").val() == '') {
            crear_alerta('error', 'Campos necesarios', 'Favor ingrese los campos obligatorios');
            return false;
        }
        if (!verifica_fecha($("#txtFechaIni_1").val(), $("#txtFechaIni_2").val())) {
            return false;
        }

        var fecha_ini_1 = $("#txtFechaIni_1").val();
        var fecha_ini_2 = $("#txtFechaIni_2").val();

        var slc_sprint          = $("#slc_sprint").val();
        var slc_sprint_nombre   = "";

        $("#slc_sprint option").each(function (key, value) {
            if($(this).is(':selected')){
                if(key ==1){
                    slc_sprint_nombre += $(this).html();    
                }else{
                    slc_sprint_nombre += ' , ' + $(this).html();    
                }
                
            }
        });

        //var estado              = $("#chk_sprint_activos").val();

        var slc_estapa          = $("#slc_estapa").val();
        var slc_estapa_nombre   = "";

        $("#slc_estapa option").each(function (key, value) {
            if($(this).is(':selected')){
                if(key ==1){
                    slc_estapa_nombre += $(this).html();    
                }else{
                    slc_estapa_nombre += ' , ' + $(this).html();    
                }
                
            }
        });


        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('desarrollo/salidas/reporte_incidencias_cliente/1'),
                        data: { slc_cliente : slc_cliente,
                                slc_cliente_nombre : slc_cliente_nombre,
                                slc_sprint : slc_sprint,
                                slc_sprint_nombre : slc_sprint_nombre,
                                slc_estapa :slc_estapa,
                                slc_estapa_nombre : slc_estapa_nombre,
                                fecha_ini_1: fecha_ini_1,
                                fecha_ini_2: fecha_ini_2,
                                //estado:estado
                            },
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            var obj = jQuery.parseJSON( result );
                         
                            var oTable = $('#tblListado').dataTable();
                            oTable.fnDestroy(); 

                            $("#tbContenedorListado").html(obj.html);

                            aplicarDataTable('tblListado');

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);

                            $("#filtro_cliente").val(slc_cliente);
                            $("#filtro_cliente_nombre").val(slc_cliente_nombre);

                            $("#filtro_inicio_1").val(fecha_ini_1);
                            $("#filtro_inicio_2").val(fecha_ini_2);

                            $("#filtro_sprint").val(slc_sprint);
                            $("#filtro_sprint_nombre").val(slc_sprint_nombre);

                            //$("#filtro_estado").val(estado);

                            $("#filtro_etapa").val(slc_estapa);
                            $("#filtro_etapa_nombre").val(slc_estapa_nombre);

                            wait.close();
                        }
                    });
                }
        );

    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error', 'Rango de fechas', 'Fecha inicio del rango no puede ser mayor');
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        return true;
    }
}