$(document).ready(function () {

    window.gSateliteWhite.jsSelect();

    $(".datePicker").mask('99-99-9999');
    $(".datePicker").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $('#txtFechaInicioEstadoTicket, #txtFechaFinEstadoTicket').change(function () {
        actualizarGraficoEstadoTicket();
    });

    $('#txtFechaInicioComponente, #txtFechaFinComponente').change(function () {
        actualizarGraficoComponente();
    });

    $('#txtFechaInicioTpp, #txtFechaFinTpp').change(function () {
        actualizarGraficoTipoPrioridad();
    });



});

function actualizarGraficoEstadoTicket() {
    var fechaInicio = $('#txtFechaInicioEstadoTicket').val();
    var fechaFin = $('#txtFechaFinEstadoTicket').val();

    if (verifica_fecha(fechaInicio, fechaFin)) {
        $.ajax({
            url: urlj + 'desarrollo/salidas/reporte_estadisticas_estado_ticket',
            type: 'POST',
            data: {
                fecha_inicio: fechaInicio,
                fecha_fin: fechaFin
            },
            beforeSend: function () {
                wait.start();
            },
                success: function (data) {

                    data = data.replace(/^\uFEFF/, '');
                    data = data.trim(); 

                    var response = JSON.parse(data);
                    var estado_ticket_labels = response.resultado.map(item => `${item.esk_nombre} (${item.cantidad_estado_ticket})`);
                    var estado_ticket_data = response.resultado.map(item => item.cantidad_estado_ticket);

                    let chartStatus = Chart.getChart("graficoEstadoTicket");
                    if (chartStatus != undefined) {
                        chartStatus.destroy();
                    }

                    generacionGrafico("graficoEstadoTicket", "pie", "Grafico por Estado de Ticket", estado_ticket_labels, estado_ticket_data);

                wait.close();
            }
        });
    }
}

function actualizarGraficoComponente() {
    var fechaInicio = $('#txtFechaInicioComponente').val();
    var fechaFin = $('#txtFechaFinComponente').val();

    if (verifica_fecha(fechaInicio, fechaFin)) {
        $.ajax({
            url: urlj + 'desarrollo/salidas/reporte_estadisticas_componente',
            type: 'POST',
            data: {
                fecha_inicio: fechaInicio,
                fecha_fin: fechaFin
            },
            
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {

                data = data.replace(/^\uFEFF/, '');
                data = data.trim(); 

                var response = JSON.parse(data);
                var componente_labels = response.resultado.map(item => item.cmp_nombre);
                var componente_data = response.resultado.map(item => item.cantidad_componente);

                let chartStatus = Chart.getChart("graficoComponente");
                if (chartStatus != undefined) {
                    chartStatus.destroy();
                }

                const configuracion_grafico_barra_horizontal = { 
                    indexAxis: 'x'
                }

                generacionGrafico("graficoComponente", "bar", "Grafico por Componentes", componente_labels, componente_data, configuracion_grafico_barra_horizontal);
                wait.close();
            }
        });
    }
}

function actualizarGraficoTipoPrioridad() {
    var fechaInicio = $('#txtFechaInicioTpp').val();
    var fechaFin = $('#txtFechaFinTpp').val();

    if (verifica_fecha(fechaInicio, fechaFin)) {
        $.ajax({
            url: urlj + 'desarrollo/salidas/reporte_estadisticas_tipo_prioridad',
            type: 'POST',
            data: {
                fecha_inicio: fechaInicio,
                fecha_fin: fechaFin
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                data = data.replace(/^\uFEFF/, '');
                data = data.trim(); 
                
                var response = JSON.parse(data);
                
                var tipo_prioridad_labels = response.resultado.map(item => `${item.tpp_nombre} (${item.cantidad_tipo_prioridad})`);
                var tipo_prioridad_data = response.resultado.map(item => item.cantidad_tipo_prioridad);

                let chartStatus = Chart.getChart("graficoTipoPrioridad");
                if (chartStatus != undefined) {
                    chartStatus.destroy();
                }

                generacionGrafico("graficoTipoPrioridad", "pie", "Grafico por Tipo de Prioridad", tipo_prioridad_labels, tipo_prioridad_data);
                wait.close();
            }
        });
    }
}

function generacionGrafico(canvaID, tipoGrafico, titulo, labels, data, opciones = {}, plugins = []) {
    new Chart(canvaID, {
        type: tipoGrafico,
        data: {
            labels: labels,
            datasets: [{
                label: titulo,
                data: data,
                backgroundColor: [
                    '#e32213',
                    '#706F6F',
                    '#3C3C3B',
                    '#000000',
                    '#071D49'
                ],
            }]
        },
        options: opciones,
        plugins: plugins

    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error', 'Rango de fechas', 'Fecha inicio del rango no puede ser mayor');
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        return true;
    }
}