$(document).ready(function () {

    $(".select").select2();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#reporte").validate({
        ignore: "",
        rules: {
            txtFechaIni_1: { required: true },
            txtFechaIni_2: { required: true }
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error','Campos necesarios','Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form){
            var slc_proyecto        = $("#slc_proyecto").val();
            var slc_proyecto_nombre = $("#slc_proyecto option:selected").text();

            // if (slc_proyecto == "") {
            //     crear_alerta('error', 'Reporte de cumplimiento por consultor', 'Campo proyecto es requerido.');
            //     return false;
            // }

            var slc_sprint          = $("#slc_sprint").val();
            var slc_sprint_nombre   = "";

            $("#slc_sprint option").each(function (key, value) {
                if($(this).is(':selected')){
                    if(key ==1){
                        slc_sprint_nombre += $(this).html();    
                    }else{
                        slc_sprint_nombre += ' , ' + $(this).html();    
                    }
                    
                }
            });

            var fecha_ini           = $("#txtFechaIni").val();

            var slc_consultor       = $("#slc_consultor").val();
            var slc_consultor_nombre= $("#slc_consultor option:selected").text();

            var slc_estapa          = $("#slc_estapa").val();
            var slc_estapa_nombre   = "";

            $("#slc_estapa option").each(function (key, value) {
                if($(this).is(':selected')){
                    if(key ==1){
                        slc_estapa_nombre += $(this).html();    
                    }else{
                        slc_estapa_nombre += ' , ' + $(this).html();    
                    }
                    
                }
            });

            $("#filtro_proyecto").val(slc_proyecto);
            $("#filtro_proyecto_nombre").val(slc_proyecto_nombre);

            $("#filtro_sprint").val(slc_sprint);
            $("#filtro_sprint_nombre").val(slc_sprint_nombre);

            $("#filtro_inicio").val(fecha_ini);

            $("#filtro_consultor").val(slc_consultor);
            $("#filtro_consultor_nombre").val(slc_consultor_nombre);

            $("#filtro_etapa").val(slc_estapa);
            $("#filtro_etapa_nombre").val(slc_estapa_nombre);
            
            form.submit();
        }
    });

    $("#slc_proyecto").change(function (){
        if ( $("#slc_proyecto").val() == "") {
            $("#slc_sprint").select2('data',null);
            $("#slc_sprint").empty();

            get_consultor('');
            // $("#slc_consultor").select2('data',null);
            // $("#slc_consultor").empty();
           
        } else { 
            var proyecto = $(this).val();
            get_sprint(proyecto);
            get_consultor(proyecto);
        }
    });  

    function get_sprint(proyecto){
        $.ajax({
            url: urlj + 'desarrollo/salidas/get_sprint',
            data:{proyecto:proyecto},
            type: 'POST',
            dataType: 'text',
            beforeSend: function () {
                wait.start();
            },
            success: function(data){
                wait.close();
                $("#slc_sprint").html(data);
                $("#slc_sprint").select2();
            }
        });
    }

    function get_consultor(proyecto){
        $.ajax({
            url: urlj + 'desarrollo/salidas/get_consultor',
            data:{proyecto:proyecto},
            type: 'POST',
            dataType: 'text',
            beforeSend: function () {
                wait.start();
            },
            success: function(data){
                wait.close();
                $("#slc_consultor").html(data);
                $("#slc_consultor").select2();
            }
        });
    }

    $("#btnConsultar").click(function(){
        event.preventDefault();
        if ($("#txtFechaIni_1").val() == '' && $("#txtFechaIni_2").val() == '') {
            crear_alerta('error', 'Campos necesarios', 'Favor ingrese los campos obligatorios');
            return false;
        }
        if (!verifica_fecha($("#txtFechaIni_1").val(), $("#txtFechaIni_2").val())) {
            return false;
        }
        var slc_proyecto        = $("#slc_proyecto").val();
        var slc_proyecto_nombre = $("#slc_proyecto option:selected").text();

        // if (slc_proyecto == "") {
        //     crear_alerta('error', 'Reporte de cumplimiento por consultor', 'Campo proyecto es requerido.');
        //     return false;
        // }

        var slc_sprint          = $("#slc_sprint").val();
        var slc_sprint_nombre   = "";

        $("#slc_sprint option").each(function (key, value) {
            if($(this).is(':selected')){
                if(key ==1){
                    slc_sprint_nombre += $(this).html();    
                }else{
                    slc_sprint_nombre += ' , ' + $(this).html();    
                }
                
            }
        });

        var fecha_ini_1 = $("#txtFechaIni_1").val();
        var fecha_ini_2 = $("#txtFechaIni_2").val();

        var slc_consultor       = $("#slc_consultor").val();
        var slc_consultor_nombre= $("#slc_consultor option:selected").text();

        var slc_estapa          = $("#slc_estapa").val();
        var slc_estapa_nombre   = "";

        $("#slc_estapa option").each(function (key, value) {
            if($(this).is(':selected')){
                if(key ==1){
                    slc_estapa_nombre += $(this).html();    
                }else{
                    slc_estapa_nombre += ' , ' + $(this).html();    
                }
                
            }
        });

  
        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('desarrollo/salidas/reporte_cumplimiento_consultor/1'),
                        data: { slc_proyecto : slc_proyecto,
                                slc_proyecto_nombre : slc_proyecto_nombre,
                                slc_sprint : slc_sprint,
                                slc_sprint_nombre : slc_sprint_nombre,
                                fecha_ini_1: fecha_ini_1,
                                fecha_ini_2: fecha_ini_2,
                                slc_consultor : slc_consultor,
                                slc_consultor_nombre : slc_consultor_nombre,
                                slc_estapa :slc_estapa,
                                slc_estapa_nombre : slc_estapa_nombre
                            },
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            var obj = jQuery.parseJSON( result );
                         
                            var oTable = $('#tblListado').dataTable();
                            oTable.fnDestroy(); 

                            $("#tbContenedorListado").html(obj.html);
                            
                            aplicarDataTable('tblListado');

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);

                            $("#filtro_proyecto").val(slc_proyecto);
                            $("#filtro_proyecto_nombre").val(slc_proyecto_nombre);

                            $("#filtro_sprint").val(slc_sprint);
                            $("#filtro_sprint_nombre").val(slc_sprint_nombre);

                            $("#filtro_inicio_1").val(fecha_ini_1);
                            $("#filtro_inicio_2").val(fecha_ini_2);

                            $("#filtro_consultor").val(slc_consultor);
                            $("#filtro_consultor_nombre").val(slc_consultor_nombre);

                            $("#filtro_etapa").val(slc_estapa);
                            $("#filtro_etapa_nombre").val(slc_estapa_nombre);

                            wait.close();
                        }
                    });
                }
        );

    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");

    if (Date.parse(fecha_i) == Date.parse(fecha_f)) {
        return true;
    }

    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error', 'Rango de fechas', 'Fecha inicio del rango no puede ser mayor');
        return false;
    }

    if (Date.parse(fecha_i) < Date.parse(fecha_f)) {
        return true;
    }
}