$(document).ready(function(){

    $(".selects").select2({ placeholder : "Seleccione"});

    $("#frm-descarga").validate({
        ignore: "",
        rules: {
            slc_proyecto: { required: true }
            // slc_sprint: { required: true }
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            console.log($(form).serialize());
            $.ajax({
                url: $(form).attr("action"),
                data: $(form).serialize(),
                type: "POST",
                dataType: 'json',
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $('#checkAll').dataTable().fnDestroy();
                    $("#datagried").html(data.cadena_sprint);
                    aplidarDataTable("checkAll");
                    $("#checkAll").show('slide');
                    var consultor = $("#slc_consultor").val();
                    var proyecto = $("#slc_proyecto").val();
                    var sprint = $("#slc_sprint").val();
                    var cliente = $("#slc_cliente").val();
                    $("#txt_consultor_h").val(consultor);
                    $("#txt_proyecto_h").val(proyecto);
                    $("#txt_sprint_h").val(sprint);
                    $("#txt_cliente_h").val(cliente);
                    $(".botones_export_print").show('slow');
                    wait.close();
                }
            });
        }
    });

  $("body").on("change", "#slc_proyecto", function () {
    event.preventDefault();
    var pry_id = $(this).val();
    $.ajax({
      dataType: 'json',
      type: 'post',
      url: urlj + 'desarrollo/salidas/get_sprintxpry',
      data: { slc_proyecto: pry_id },
      async: false,
      success: function (data) {
        $("#slc_sprint").select2("destroy");
        $("#slc_sprint").html(data.options);
        $("#slc_sprint").select2({ placeholder: "Seleccione" });
      }
    });

  });



});

function aplidarDataTable(idTabla) {
  $('#' + idTabla).dataTable({
    "sPaginationType": "full_numbers",
    "bJQueryUI": false,
    "bAutoWidth": false,
    "iDisplayLength": 20,
    "bLengthChange": false,
    "bDestroy": true,
    "bSort": false,
    "fnInitComplete": function (oSettings, json) {
      $('.dataTables_filter>label>input').attr('id', 'search');
    }
  });
}
