jQuery(document).ready(function ($) {
    $('select').select2();
    $('#exportar, #imprimir_pdf').hide();

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            slcProyecto: {required: true}
        },
        messages: {
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }

           //$("[for=txtFecha_desde]").css("margin-left", "17%");
           //$("[for=txtFecha_hasta]").css("margin-left", "17%");

        },
        submitHandler: function (form) {
            wait.start();
            $("#contenedorTabla").hide("slide", { 
                direction: 'right'
            }, 400, function() { //despues de ocultar div enviar el ajax
                url_ajax = window.satelite.base_url('desarrollo/salidas/filtrar_plan_trabajo');
                $.ajax({
                    url: url_ajax,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        slcProyecto: $("#slcProyecto").val(),
                        slcEstadoSprint: (($("#slcEstadoSprint").prop('checked')) ? 1 : 0),
                        slcSprint: $("#slcSprint").val(),
                        slcConsultor: $("#slcConsultor").val(),
                        slcCliente: $("#slc_cliente").val()
                    },
                    beforeSend: function () {
                        wait.start();
                    },
                    error: function (xhr, status, error){
                        exportarError(xhr.responseText);
                        wait.close();
                    },
                    success: function (json) {
                        $("#contenedorTabla").html(json.html);
                        $("#contenedorTabla").show("slide", {
                            direction: 'left'
                        }, 500);
                        wait.close();
                    }
                });
            });
        }
    });

    $("#slcProyecto, #slcEstadoSprint").change(function(event) {
        cargar_sprint();
    });

});


function  cargar_sprint() {

    url_ajax = window.satelite.base_url('desarrollo/salidas/filtrar_sprint_option');
    $.ajax({
        url: url_ajax,
        type: 'POST',
        dataType: 'json',
        data: {
            slcProyecto: $("#slcProyecto").val(),
            slcEstadoSprint: (($("#slcEstadoSprint").prop('checked'))?1:0)
        },
        beforeSend: function () {
            wait.start('Cargando Sprint...');
        },
        error: function (xhr, status, error){
            exportarError(xhr.responseText);
            wait.close();
        },
        success: function (json) {
            $("#slcSprint").html(json.options);
            $("#slcSprint").select2();
            wait.close();

        }
    });
}