$(document).ready(function () {
    $('select').select2({placeholder: "Seleccione una opción"});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });


    $("#sprint").change(function () {
        if ($(this).val() > 0) {
            var spr = $("#sprint").val();
            var pro = $("#sprint option:selected").data('proyecto');
            wait.start();
            location.href = urlj + 'desarrollo/procesos/pizarra/' + pro + '/' + spr;
        } else {
            $("#btnFiltros").hide();
            $("#dvCheckboxFiltro").hide();
        }
    });

    /* filtros */
    $("#slcTipoFiltro").change(function () {
        var filtroBusqueda = $(this).val();
        var filtros = {'1': "dvEmpleados", 2: "dvEmpleados", 3: "dvFechas", 4: "dvFechas", 5: "dvClientes", 6: "dvComponente"};
        if (filtroBusqueda != '') {
            limpiarFiltros();
            $("#" + filtros[filtroBusqueda]).show('slow');
        } else {
            limpiarFiltros();
        }
    });

    function backgroundSelect(element) {

        var id = parseInt(element.id);

        var select = $(this.element[0]).attr('id');

        /*si el elemento img existe (al momento de cargar la pagina con un selected)*/
        if (element.element) {
            var img = $('#' + element.element[0].id).data('img');
        } else {
            var img = $("#" + select + ' option:selected').data('img');
        }
        if (id > 0 && img != '') {
            var item = '<span><img src="' + img + '" class="opt-icon" /> ' + element.text + '</span>';
        } else {
            var item = '<span>' + element.text + '</span>';
        }
        return item;
    }


    $("#sprint").select2({
        formatResult: backgroundSelect,
        formatSelection: backgroundSelect,
        placeholder: "Seleccione una opción"
    });

    $(".image-thumbnail").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            'height': '300',
            //width  : '500',
            type: 'iframe',
            closeBtn: true
        });
    });

    $(".modal-action").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            'height': '300',
            //width  : '500',
            type: 'iframe',
            closeBtn: true
        });
    });

    $(".menu-action").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            'height': '300',
            //width  : '500',
            type: 'iframe',
            closeBtn: true,
            beforeClose: function () {
                $('.eliminar_imagen_foto', $('iframe').contents()).trigger('click');
            }
        });
    });

    $(".verAnexo").fancybox({});


    /*MENU CLICK DERECHO PERSONALIZADO*/
    $(".inc-detail").live('contextmenu', function (e) {

        //obtengo el id de la incidencia
        var id = $(this).data('id');

        //colocandolo los links
        $("#inc-layout a").each(function (index) {
            var link = $(this).data('link');
            $(this).attr('href', link + '/' + id + '?iframe=1');
        });

        //mostrando el menu
        $("#inc-layout").css({'display': 'block', 'left': e.pageX, 'top': e.pageY});
        //cancelo el menu del navegador
        return false;
    });

    $(document).click(function (e) {
        if (e.button == 0) {
            $("#inc-layout").css({'display': 'none'});
        }
    });

    $(document).keydown(function (e) {
        if (e.keyCode == 27) {
            $("#inc-layout").css({'display': 'none'});
        }
    });


    $(".dtl-ctr-addcoment").live('click', function (event) {
        event.preventDefault();
        var inc = $("#inc_id").val();
        var link = $(this).attr('href');

        var url = link + '/' + inc + '?iframe=1';
        $.fancybox({
            'href': url,
            'height': '200',
            //width  : '500',
            type: 'iframe',
            closeBtn: true
        });
    });
   

    $(".modalFiltros").fancybox({
        width: '90%',
        height: 'auto',
        autoSize: false,
        type: 'inline',
        closeClick: false,
        hideOnOverlayClick: true,
        helpers: {
            overlay: {closeClick: false} // prevents closing when clicking OUTSIDE fancybox 
        },
        beforeLoad: function () {

        },
        beforeClose: function () {

        }
    });


    $("#btnFiltrar").live('click', function (event) {
        event.preventDefault();
        var filtroBusqueda = $("#slcTipoFiltro").val();

        var slcEmpleado = $("#slcEmpleado").val();
        var slcCliente = $("#slcCliente").val();
        var slcComponente = $("#slcComponente").val();
        var txtFechaInicio = $("#txtFechaInicio").val();
        var txtFechaFin = $("#txtFechaFin").val();

        var filtroString = "";
        var filtroTipo = $("#slcTipoFiltro option:selected").text();
        var filtroNombre = "";

        if (slcEmpleado > 0 && slcEmpleado != '') {
            filtroString = filtroBusqueda + "#" + slcEmpleado;
            filtroNombre = $("#slcEmpleado option:selected").text();
        }
        if (slcCliente > 0 && slcCliente != '') {
            filtroString = filtroBusqueda + "#" + slcCliente;
            filtroNombre = $("#slcCliente option:selected").text();
        }
        if (slcComponente > 0 && slcComponente != '') {
            filtroString = filtroBusqueda + "#" + slcComponente;
            filtroNombre = $("#slcComponente option:selected").text();
        }
        if (txtFechaInicio != '' || txtFechaFin != '') {
            if (!validarPeriodo(txtFechaInicio, txtFechaFin)) {
                crear_alerta('error', 'Filtros', 'Verifique el período de las fechas.');
                return false;
            }
            filtroString = filtroBusqueda + "#" + txtFechaInicio + '/' + txtFechaFin;
            filtroNombre = txtFechaInicio + '/' + txtFechaFin
        }

        if (filtroBusqueda > 0 && filtroString == "") {
            $("#dvInfoFiltros").hide();
            crear_alerta('error', 'Filtros', 'Debe ingresar un valor de busqueda.');
            return false;
        }

        if (filtroTipo != '' || filtroNombre != '') {

            var filtroLabel = filtroTipo + ' - ' + filtroNombre.trim();

            $("#lblFiltros").text(filtroLabel);
            $("#dvInfoFiltros").show();
        } else {
            $("#dvInfoFiltros").hide();
            $("#lblFiltros").text('');
        }


        $(".clm-action-close").trigger('click');
        consultar_pizarra(filtroString);
        $.fancybox.close();
    });

    $(".clm-action-close").live('click', function () {
        $("#column-detail").hide();
        //$("#column-detail").html('');
    });

    $(".inc-detail").live('click', function () {
        $(".inc-detail").removeClass('inc-selected-detail');
        $(".inc-detail").removeClass('inc-flagged-selected');
        if ($(this).hasClass('inc-flagged')) {
            $(this).addClass('inc-flagged-selected');
        } else {
            $(this).addClass('inc-selected-detail');
        }

        $("#column-detail").show();
        var inc = $(this).data('id');
        if (inc > 0) {
            $.ajax({
                url: urlj + 'desarrollo/procesos/detalle_incidencia',
                data: {incidencia: inc},
                type: 'POST',
                beforeSend: function () {
                    $("#column-detail").html('<div id="loaderDetail"><div id="loaderBar"></div></div>');
                    $("#loaderDetail").css('visibility', 'visible');
                    $("#loaderBar").css('visibility', 'visible');
                },
                success: function (data) {
                    $("#column-detail").html($.trim(data));
                }
            });
        }
    });


    var h = $(window).height();

    $(".content-work").height(h - 50);

    //setInterval('consultar_pizarra();', 600000);
    setInterval('consultar_cambios();', 300000);

    /* recargar cada 10 min*/

    /*FUNCTION PARA MOVER LOS DIV*/
    $(".sorteable-incidencia").sortable({
        connectWith: '.sorteable-incidencia',
        placeholder: 'placeholder',
        /*ui = DATA del elemento seleccionado */

        /*FUNCTION que se ejecuta al momento de empezar el sort*/
        start: function (event, ui) {
            $(this).addClass('without-holder');
            $(".sorteable-incidencia").addClass('placeholder2');
            $(this).removeClass('placeholder2');

            $('#' + ui.item['0'].id).addClass('inc-selected');
            $(".inc-detail", this).addClass('inc-hold');
            $(".inc-detail").hide();
        },

        /*FUNCTION que se ejecuta al momento de detener el sort*/
        stop: function (event, ui) {
            $(".sorteable-incidencia").removeClass('placeholder2');
            $(".sorteable-incidencia").removeClass('without-holder');
            $('#' + ui.item['0'].id).removeClass('inc-selected');
            $(".inc-detail").removeClass('inc-hold');
            $(".inc-detail").show();
        },

        /*funcion que se activa al momento de mover a otro div un elemento*/
        receive: function (event, ui) {

            var inc = $('#' + ui.item['0'].id).data('id');
            /*etapa donde se movio*/
            var etapa = $(this).data('type');

            /*insertando el cambio de estado*/
            if (inc > 0 && etapa > 0) {
                $.ajax({
                    url: urlj + 'desarrollo/procesos/registrar_seguimiento',
                    data: {incidencia: inc, etapa: etapa},
                    type: 'POST',
                    success: function (data) {
                         //consultar los cambios
                         //wait.start();
                         setTimeout(function() { consultar_cambios(); }, 1000);  
                        //alert(data);
                    }
                });
            }
        },
    }).disableSelection();


    aplicarToolTip();

    contabilizarHorasEtapa();//contabilización inicial

        $(".ibutton_filtro").iButton({
         labelOn: "Todas",
         labelOff: "Asignadas",
         enableDrag: false,
         change: function (element) {
             if (element.is(':checked')) {
                if ($("#slcEmpleado option[value='"+id_usuario+"']").length > 0 ) { // si el usuario existe que muestre todas
                    wait.start();
                    $("#btnFiltros").trigger('click'); //ejecutar el mostrado para que el desaparecimiento de los elmentos tenga efecto
                    setTimeout(function() {
                     $("#slcEmpleado option").removeAttr('selected');
                     $("#slcEmpleado").select2();

                     $("#slcTipoFiltro option").removeAttr('selected');
                     $("#slcTipoFiltro").select2();
                     $("#slcTipoFiltro").trigger('change');
                    
                     $("#btnFiltrar").trigger('click');
                     }, 20); // que el fancybox se mantenga 10 milesimas
                }
             } else {
                if ($("#slcEmpleado option[value='"+id_usuario+"']").length > 0 ) {
                    wait.start();
                    $("#btnFiltros").trigger('click'); //ejecutar el mostrado para que el desaparecimiento de los elmentos tenga efecto
                    setTimeout(function() {
                    $("#slcTipoFiltro option").removeAttr('selected');
                    $("#slcTipoFiltro option[value='1']").attr('selected', 'selected');
                    $("#slcTipoFiltro").select2();
                    $("#slcTipoFiltro").trigger('change');

                    $("#slcEmpleado option").removeAttr('selected');
                    $("#slcEmpleado option[value='"+id_usuario+"']").attr('selected', 'selected');
                    $("#slcEmpleado").select2();
                    $("#btnFiltrar").trigger('click');
                    }, 20); // que el fancybox se mantenga 10 milesimas
                } else {
                    crear_alerta("info",'Sin registros','Usuario <b>'+$(".icomoon-icon-user-3:first").next().text()+'</b> sin incidencias o sin permiso al proyecto');
                    setTimeout(function() {
                    $('.ibutton_filtro').prop('checked', true);
                    $(".ibutton_filtro").iButton("repaint");
                }, 150);
                }
             }
         }
    });

   //si hay más de 3 columnas ocultar el menú.
   if($("#sprint").val() > 0 && $("#column-incidencias .etapas_pizarra").length > 3)
   {
       $("#ocultar_barra_menu").trigger('click');
       mostrar_mensaje_emergente('<h2>Se ha ocultado el menú para una mejor vista<br />Presionar Alt + a para mostrarlo</h2>');
   }

});

function limpiarFiltros() {
    $("#dvEmpleados").hide('slow');
    $("#dvClientes").hide('slow');
    $("#dvFechas").hide('slow');
    $("#dvComponente").hide('slow');

    $("#slcEmpleado option:selected").removeAttr('selected');
    $("#slcCliente option:selected").removeAttr('selected');
    $("#slcComponente option:selected").removeAttr('selected');
    $("#slcEmpleado").select2({placeholder: "Seleccione una opción"});
    $("#slcCliente").select2({placeholder: "Seleccione una opción"});
    $("#slcComponente").select2({placeholder: "Seleccione una opción"});
    $("#txtFechaInicio").val('');
    $("#txtFechaFin").val('');
}

function consultar_cambios() {
    var pry = $("#pry").val();
    var spr = $("#spr").val();

    var sgi = $("#seguimiento").val();

    $.ajax({
        url: urlj + 'desarrollo/consultas/consultar_seguimiento',
        data: {proyecto: pry, sprint: spr},
        type: 'POST',
        async: true,
        success: function (data) {
            data = parseInt(data);
            if (data == sgi) {
                //alert('yes');
            } else {
                $("#seguimiento").val(data);

                var filtroBusqueda = $("#slcTipoFiltro").val();
                var filtroString = '';
                if (filtroBusqueda) {
                    var slcEmpleado = $("#slcEmpleado").val();
                    var slcCliente = $("#slcCliente").val();
                    var txtFechaInicio = $("#txtFechaInicio").val();
                    var txtFechaFin = $("#txtFechaFin").val();


                    var filtroString = "";

                    if (slcEmpleado > 0 && slcEmpleado != '') {
                        filtroString = filtroBusqueda + "#" + slcEmpleado;
                    }
                    if (slcCliente > 0 && slcCliente != '') {
                        filtroString = filtroBusqueda + "#" + slcCliente;
                    }
                    if (txtFechaInicio != '' || txtFechaFin != '') {
                        if (!validarPeriodo(txtFechaInicio, txtFechaFin)) {
                            crear_alerta('error', 'Filtros', 'Verifique el período de las fechas.');
                            return false;
                        }
                        filtroString = filtroBusqueda + "#" + txtFechaInicio + '/' + txtFechaFin;
                    }

                    if (filtroBusqueda > 0 && filtroString == "") {
                        crear_alerta('error', 'Filtros', 'Debe ingresar un valor de busqueda.');
                        return false;
                    }
                }

                consultar_pizarra(filtroString);
            }
        }
    });
}
function consultar_pizarra(filtros) {
    var pry = $("#pry").val();
    var spr = $("#spr").val();

    $.ajax({
        url: urlj + 'desarrollo/consultas/consultar_pizarra',
        data: {proyecto: pry, sprint: spr, filtros: filtros},
        type: 'POST',
        beforeSend: function () {
            wait.start();
        },
        success: function (data) {
            //alert(data);
            wait.close();
            $(".content-incidencias").html(data);

            setTimeout(function () {
                aplicarToolTip();
            }, 500);

            $(".content-incidencias").css('margin-top', '-20px');
            $(".sorteable-incidencia").sortable({
                connectWith: '.sorteable-incidencia',
                placeholder: 'placeholder',
                /*ui = DATA del elemento seleccionado */

                /*FUNCTION que se ejecuta al momento de empezar el sort*/
                start: function (event, ui) {
                    $(this).addClass('without-holder');
                    $(".sorteable-incidencia").addClass('placeholder2');
                    $(this).removeClass('placeholder2');

                    $('#' + ui.item['0'].id).addClass('inc-selected');
                    $(".inc-detail", this).addClass('inc-hold');
                    $(".inc-detail").hide();
                },

                /*FUNCTION que se ejecuta al momento de detener el sort*/
                stop: function (event, ui) {
                    $(".sorteable-incidencia").removeClass('placeholder2');
                    $(".sorteable-incidencia").removeClass('without-holder');
                    $('#' + ui.item['0'].id).removeClass('inc-selected');
                    $(".inc-detail").removeClass('inc-hold');
                    $(".inc-detail").show();
                },
                /*funcion que se activa al momento de mover a otro div un elemento*/
                receive: function (event, ui) {

                    var inc = $('#' + ui.item['0'].id).data('id');
                    /*etapa donde se movio*/
                    var etapa = $(this).data('type');

                    /*insertando el cambio de estado*/
                    if (inc > 0 && etapa > 0) {
                        $.ajax({
                            url: urlj + 'desarrollo/procesos/registrar_seguimiento',
                            data: {incidencia: inc, etapa: etapa},
                            type: 'POST',
                            success: function (data) {
                                setTimeout(function() { consultar_cambios(); }, 999); 
                                //alert(data);
                            }
                        });
                    }
                },
            }).disableSelection();
        }
    });

    setTimeout(function() { contabilizarHorasEtapa(); }, 1000); 
    
    //$(".content-incidencias").load(urlj+'desarrollo/procesos/consultar_pizarra/'+pry+'/'+spr);
}

function aplicarToolTip() {
    $('.inc-avatar').qtip({
        content: false,
        position: {
            my: 'bottom center',
            at: 'top center',
            viewport: $(window)
        },
        style: {
            classes: 'ui-tooltip-tipsy'
        }
    });
}

function contabilizarHorasEtapa() {
    $(".etapas_pizarra").each(function(){ 
        id_etapa = $(this).data('id_etapa');
        var total_horas = 0;
        var numero_incs = 0;
        $(".etapa_" + id_etapa).each(function(){ 
            total_horas += $(this).data('estimacion');
            numero_incs++;
        });

        $("#horas_etapa_" + id_etapa).text(' (' + total_horas.toFixed(1) + ' h / '+numero_incs+' Inc.)');
        total_horas = 0;
     }); 
}