jQuery(document).ready(function ($) {
    $('select').select2();

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            slcProyecto: {required: true, min:1},
            slcEntregable: {required: true, min:1}
        },
        messages: {
            slcProyecto: "Campo requerido",
            slcEntregable: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }
        },
        submitHandler: function (form) {
            //despues de ocultar div enviar el ajax
            $("#contenedorTabla").hide("slide", {  direction: 'right' }, 400, function() {
                url_ajax = window.satelite.base_url('desarrollo/procesos/filtrar_mover_incidencias_sprint');
                $.ajax({
                    url: url_ajax,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        slcProyecto: $("#slcProyecto").val(),
                        slcEntregable: $("#slcEntregable").val(),
                        slcEtapa: $("#slcEtapa").val(),
                        slcConsultor: $("#slcConsultor").val()
                    },
                    beforeSend: function () {
                        wait.start();
                    },
                    error: function (xhr, status, error){
                        exportarError(xhr.responseText);
                        wait.close();
                    },
                    success: function (json) {
                        $("#contenedorTabla").html(json.html);
                        $("#contenedorTabla").show("slide", { direction: 'left' }, 500);
                        wait.close();

                    }
                });
            });
        }
    });

    $("#slcProyecto").change(function(event) {
        cargar_entregable();
    });

});

function  cargar_entregable() {
    url_ajax = window.satelite.base_url('desarrollo/procesos/filtrar_entregable_option');
    $.ajax({
        url: url_ajax,
        type: 'POST',
        dataType: 'json',
        data: {
            slcProyecto: $("#slcProyecto").val()
        },
        beforeSend: function () {
            wait.start('Cargando sprint...');
        },
        error: function (xhr, status, error){
            exportarError(xhr.responseText);
            wait.close();
        },
        success: function (json) {
            $("#slcEntregable").html(json.options);
            $("#slcEntregable").select2();
            wait.close();
        }
    });
}