$(document).ready(function ($) {
    $('select').select2();

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
    });
    $(".datePicker").attr('placeholder',"dd-mm-yyyy"); 
    $(".datePicker").mask("99-99-9999");

    $("#btnConsultar").click(function(event) {
        event.preventDefault();
        cargar_sprints();
    });

    $('body').on('change', '#check_all', function() {
        var prop = ($(this).is(':checked')) ? true : false; 
        $(".checkear").each(function(){
            $(this).prop('checked', prop);
            $(this).trigger('change');
        });
    });

    $('body').on('change', '.checkear', function() {
        var id = $(this).data('id');
        var valor = ($(this).is(':checked')) ? 1 : 0;
        var vacias = 0;
        $(".checkear").each(function(){
            if (!($(this).is(':checked'))) {
                vacias++;
            }
        });
        if ($("#check_all").is(':checked') && vacias > 0) {
            $("#check_all").prop('checked', false);
        }
        if (!($("#check_all").is(':checked')) && vacias < 1) {
            $("#check_all").prop('checked', true);
        }
        $("#procesar_" + id).val(valor);
    });

    $('body').on('click', '#btn_cancelacion', function() {
        event.preventDefault();
        $("#fecha_cierre_antiguo").val('');
        $("#fecha_inicia_nuevo").val('');
        $("#contenedorTabla").html('');
    });

    $('body').on('click', '#btn_procesar', function() {
        event.preventDefault();
        alerta_confirm_ajax(enviar_forma, 1, "Por favor, confirme", "¿Está seguro que desea procesar el cierre de sprint de forma masiva para todos los proyectos activos?");
    });

});

function enviar_forma(acepta) {
    if (acepta > 0) {
        var fecha1 = $("#fecha_cierre_antiguo").val();
        var fecha2 = $("#fecha_inicia_nuevo").val();    
        if (fecha1 != '' && fecha2 != '') {
            if (!(validar_fechas(fecha1, fecha2))) {
                return false;
            }            
        }else{
            crear_alerta('error', 'Ambas fechas son requeridas', '');
            return false;
        }
        wait.start();
        $("#frmConsultaform").submit();
    }
}

function cargar_sprints(){
    var fecha1 = $("#fecha_cierre_antiguo").val();
    var fecha2 = $("#fecha_inicia_nuevo").val();    
    if (fecha1 != '' && fecha2 != '') {
        if (!(validar_fechas(fecha1, fecha2))) {
            return false;
        }        
    }else{
        crear_alerta('error', 'Ambas fechas son requeridas', '');
        return false;
    }
    $.ajax({
        url: urlj + 'desarrollo/procesos/filtrar_sprint_cerrar',
        type: 'POST',
        dataType: 'json',
        beforeSend: function () {
            wait.start('Buscando sprints...');
        },
        error: function (xhr, status, error){
            exportarError(xhr.responseText);
            wait.close();
        },
        success: function (json) {
            $("#contenedorTabla").html(json.tabla);
            wait.close();
        }
    });
}

function validar_fechas(fecha_ini, fecha_fin) {
    var start = fecha_ini.split("-").reverse().join("-");
    var final = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(start) > Date.parse(final)) {
        crear_alerta('error', 'Verifique las fechas ingresadas', '');
        return false;
    } else {
        return true;
    }    
}