$(document).ready(function(){
    $(".selects").select2({ placeholder: "Seleccione" });

    $("#chk_es_pm").iButton({
        'labelOn': ' Ver todos los registros ',
        'labelOff': ' Ver solo mis registros ',
        'resizeHandle': false,
        change : function(element) {
            if((element.is(':checked'))) {
                $("#chk_pm_hdn").val(1);
            } else {
                $("#chk_pm_hdn").val(0);
            }
        }
    });

    $("#frm-descarga").validate({
        ignore: "",
        rules: {
            slc_consultor: { required: true }
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            // console.log($(form).serialize());
            $(".botones_export_print").hide();
            $.ajax({
                url: $(form).attr("action"),
                data: $(form).serialize(),
                type: "POST",
                dataType: 'json',
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $('#checkAll').dataTable().fnDestroy(); 
                    $("#datagried").html(data.cadena_sprint);
                    $("#sum_estima").text(number_format(data.horas,2));
                    aplidarDataTable("checkAll");
                    $("#checkAll").show('slide');
                    var consultor = $("#slc_consultor").val();
                    var proyecto = $("#slc_proyecto").val();
                    var sprint = $("#slc_sprint").val();
                    var etapa = $("#slc_etapa").val();
                    var sprv = $("#chk_pm_hdn").val();
                    $("#txt_consultor_h").val(consultor);
                    $("#txt_proyecto_h").val(proyecto);
                    $("#txt_sprint_h").val(sprint);
                    $("#txt_etapa_h").val(etapa);
                    $("#txt_espm_h").val(sprv);
                    if (data.cadena_sprint != "") {
                        $(".botones_export_print").show('slow');
                    }
                    wait.close();
                }
            });
        }
    });


    $("body").on("change", "#slc_consultor", function () {
        event.preventDefault();
        var id_usu = $(this).val();
        if (id_usu > 0) {
            $.ajax({
                dataType: 'json',
                type: 'post',
                url: urlj + 'desarrollo/salidas/get_proyectoxusu',
                data: {slc_consultor : id_usu},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#slc_proyecto").select2("destroy");
                    $("#slc_proyecto").html(data.options);
                    $("#slc_proyecto").select2({ placeholder: "Seleccione" });
                    $("#slc_sprint").html('<option value=""></option>');
                    $("#slc_sprint").select2({ placeholder: "Seleccione" });
                    if (data.essprv > 0 && true) {//ESPACIO PARA AGREGAR VALIDACION PARA VER SI EL USUARIO ES UN PM  (PENDIENTE)
                        $("#chk_es_pm").iButton("toggle", false);
                        $("#chk_es_pm").iButton("destroy");
                        $("#div_es_pm").show();
                        $("#chk_es_pm").iButton({
                            'labelOn': ' Ver todos los registros ',
                            'labelOff': ' Ver solo mis registros ',
                            'resizeHandle': false,
                            change : function(element) {
                                if((element.is(':checked'))) {
                                    $("#chk_pm_hdn").val(1);
                                } else {
                                    $("#chk_pm_hdn").val(0);
                                }
                            }
                        });
                        $("#chk_es_pm").iButton('repaint');
                    } else {
                        $("#chk_es_pm").iButton("toggle", false);
                        $("#div_es_pm").hide();
                    }
                    wait.close();
                    // $("#slc_sprint").select2("destroy");
                    // $("#slc_sprint").html(data.options_spr);
                    // $("#slc_sprint").select2({ placeholder: "Seleccione" });
                }
            });
        } else {
            $("#slc_proyecto, #slc_sprint").html('<option value=""></option>');
            $("#slc_proyecto, #slc_sprint").select2({ placeholder: "Seleccione" });
        }
    });


    $("body").on("change", "#slc_proyecto", function () {
        event.preventDefault();
        var pry_id = $(this).val();
        if (pry_id > 0) {
            $.ajax({
                dataType: 'json',
                type: 'post',
                url: urlj + 'desarrollo/salidas/get_sprintxpry',
                data: { slc_proyecto: pry_id },
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    $("#slc_sprint").select2("destroy");
                    $("#slc_sprint").html(data.options);
                    $("#slc_sprint").select2({ placeholder: "Seleccione" });
                    wait.close();
                }
            });
        } else {
            $("#slc_sprint").html('<option value=""></option>');
            $("#slc_sprint").select2({ placeholder: "Seleccione" });   
        }
    });


});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
