$(document).ready(function ($) { 	
    $('select').select2();
    $('#avance').numeric();
    $("#div_estimacion").hide();
    
    if ($("#tipo_user").val() <= 0 ) {
        mueveReloj();
        $('#slcConsultor').select2('disable');
    } else {
        $("#txtFecha").mask('99-99-9999');
        $("#txtFecha").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});
    }
    
    $("#form_agregar").validate({
        ignore: "",
        rules: {
            txtFecha: {required: true},
            slcConsultor: {required: true},
            txtAsignacion: {required: true},
            txtRealizado: {required: true},
            numero_detalles: {required: true, min:1}
        },
        messages: {
            txtFecha: "Campo requerido",
            slcConsultor: "Campo requerido",
            txtAsignacion: "Campo requerido",
            txtRealizado: "Campo requerido",
            numero_detalles: "Debe ingresar al menos una incidencia"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select')){
                $(element).next().append(error);
            } else {
                error.insertAfter(element);
            }
        },
        submitHandler: function (form) {
            var pendientes = 0;
            $(".guarda_det").each(function (index) {
                pendientes += ($(this).is(":visible")) ? 1 : 0;
            });
            if (pendientes > 0) {
                crear_alerta('info', 'Atención', 'Tiene detalles pendientes de guardar');
                return false;
            }
            form.submit();
        }
    });

    $("#slcIncidencia").change(function() {
        var incidencia = $(this).val();
        if (incidencia != "") {
            var horas = $("#slcIncidencia option:selected").data("estima");
            var avanc = $("#slcIncidencia option:selected").data("avance");
            var horya = parseFloat(horas) * (parseFloat(avanc) / 100);
            var resta = parseFloat(horas) * ((100 - parseFloat(avanc)) / 100);
            $("#est_original").html(number_format(horas,2) + " horas");
            $("#est_avance").html(number_format(avanc,2) + " %");
            $("#est_restan").html(number_format(resta,2) + " horas");
            $("#avance").val(number_format(avanc,2));
            $("#avance_h").val(number_format(horya,2));
            $("#div_estimacion").show();
        } else {
            $("#est_original, #est_avance, #est_restan").html("");
            $("#avance, #avance_h").val("");
            $("#div_estimacion").hide();
        }
    });

    $("#avance").live('keyup', function(e) {
        var avporc = $(this).val().trim();
        var incidencia = $("#slcIncidencia").val();
        if (incidencia > 0) {
            if (avporc != "") {
                var horas = $("#slcIncidencia option:selected").data("estima");
                var avanc = $("#slcIncidencia option:selected").data("avance");
                if (parseFloat(avporc) > 100) {
                    crear_alerta("info", "", "No puede ingresar más del 100%.");
                    return false;
                } else {
                    if (parseFloat(avporc) < parseFloat(avanc)) {
                        crear_alerta('info', '', 'El porcentaje no debe ser menor a lo almacenado.');
                        return false;
                    } else {
                        var new_hor = parseFloat(horas) * (parseFloat(avporc) / 100);
                        $("#avance_h").val(number_format(new_hor,2));
                    }
                }
            }
        } else {
            crear_alerta("info", "No ha seleccionado una incidencia", "");
            return false;
        }
    });

    $("#avance_h").live('keyup', function(e) {
        var avhora = $(this).val().trim();
        var incidencia = $("#slcIncidencia").val();
        if (incidencia > 0) {
            if (avhora != "") {
                var horas = $("#slcIncidencia option:selected").data("estima");
                var avanc = $("#slcIncidencia option:selected").data("avance");
                if (parseFloat(avhora) > parseFloat(horas)) {
                    crear_alerta("info", "", "No puede ingresar más de " + horas + " horas.");
                    return false;
                } else {
                    var horya = parseFloat(horas) * (parseFloat(avanc) / 100);
                    if (parseFloat(avhora) < parseFloat(horya)) {
                        crear_alerta('info', '', 'Las horas ingresadas no deben ser menores a lo almacenado.');
                        return false;
                    } else {
                        var new_por = (parseFloat(avhora) * 100) / parseFloat(horas);
                        $("#avance").val(number_format(new_por,2));
                    }
                }
            } 
        } else {
            crear_alerta("info", "No ha seleccionado una incidencia", "");
            return false;
        }        
    });

    $("#agregar").click(function(event) {
        event.preventDefault();
        var incidencia = $("#slcIncidencia").val();
        var porcentaje = $("#avance").val().trim();
        var horas = $("#avance_h").val().trim();
        var texto_slct = $("#slcIncidencia option:selected").text().trim().split(" :: ");
        var texto_inci = texto_slct[0];
        if (incidencia > 0 && porcentaje != '') {
            var horas = number_format($("#slcIncidencia option:selected").data('estima'),2);
            var avanc = number_format($("#slcIncidencia option:selected").data("avance"), 2);
            var resta = parseFloat(horas) * ((100 - parseFloat(avanc)) / 100);
            if (!(resta > 0)) {
                crear_alerta('info', 'No se puede agregar', 'La incidencia ya fue registrada como completada.');
                return false; 
            }
            if (porcentaje > 100) {
                crear_alerta('error', 'Error', 'Los valores no debe exceder el limite permitido');
                $("#avance, #avance_h").val('');
                return false; 
            }
            if ($("#contenedor_detalle_opciones .class_detalle_incidencia[value='"+incidencia+"']").length > 0) {
                crear_alerta('error', 'Error', 'La incidencia ya ha sido ingresada');
                return false;
            }
            if (parseFloat(porcentaje) < parseFloat(avanc)) {
                crear_alerta('error', 'Error', 'El porcentaje no debe ser menor a lo almacenado.');
                return false; 
            }
            tr = '';
            var estimacion = number_format(horas,2);
            var nombre = $("#slcIncidencia option:selected").data('name');
            var etapa = $("#slcIncidencia option:selected").data('etapa');
            var e_efectiva = number_format((estimacion * (porcentaje / 100)), 2);
            var estm_falta = number_format((estimacion - e_efectiva), 2);
            tr += '<tr><td style="text-align: center;"><span>'+texto_inci +'</span>';
            tr += '<input type="hidden" class="class_detalle_incidencia" value="'+incidencia+'" name="detalle_inc[]" >';
            tr += '<input type="hidden" class="est_tot" value="'+number_format(estimacion,2)+'" id="hest_tot_'+incidencia+'">';
            tr += '<input type="hidden" class="est_efe" value="'+number_format(e_efectiva,2)+'" id="hest_efe_'+incidencia+'">';
            tr += '<input type="hidden" value="'+number_format(avanc,2)+'" id="avance_almac_'+incidencia+'">';
            tr += '<input type="hidden" class="est_fal" value="'+number_format(estm_falta,2)+'" id="hest_fal_'+incidencia+'" name="estima_falta[]"></td>';
            tr += '<td style="text-align: center;"><span>'+nombre+'</span></td>';
            tr += '<td style="text-align: center;"><span>'+etapa+'</span></td>';
            tr += '<td style="text-align: center;"><span id="txt_est_'+incidencia+'">'+estimacion+'</span></td>';
            tr += '<td style="text-align: center;"><span id="txt_por_'+incidencia+'">'+number_format(porcentaje,2)+'</span>';
            tr += '<input type="hidden" value="'+number_format(porcentaje,2)+'" id="hdn_porc_'+incidencia+'" >';
            tr += '<input type="text" class="soloNumeros" value="'+number_format(porcentaje,2)+'" id="hpor_ava_'+incidencia+'" name="detalle_avance[]" extras="." style="display: none;"></td>';
            tr += '<td style="text-align: center;"><span id="txt_efe_'+incidencia+'">'+e_efectiva+'</span>';
            tr += '<input type="hidden" value="'+number_format(e_efectiva,2)+'" id="hdn_hora_'+incidencia+'" >';
            tr += '<input type="text" class="soloNumeros" value="'+number_format(e_efectiva,2)+'" id="hhor_ava_'+incidencia+'" extras="." style="display: none;"></td>';
            tr += '<td style="text-align: center;"><span id="txt_fal_'+incidencia+'">'+estm_falta+'</span></td>';
            tr += '<td style="text-align: center;"><button type="button" id="del_'+incidencia+'" class="eliminar_detalle tip btn btn-danger btn-mini" title="Eliminar">Eliminar</button>';
            tr += '<span>&nbsp;</span> <button type="button" id="edt_'+incidencia+'" class="editar_det tip btn btn-info btn-mini" title="Editar" data-id="'+incidencia+'">Editar</button>';
            tr += '<button type="button" id="sav_'+incidencia+'" class="guarda_det tip btn btn-info btn-mini" title="Guardar" data-id="'+incidencia+'" style="display: none;">Guardar</button>';
            tr += '</td></tr>';
            $("#contenedor_detalle_opciones").append(tr);
            $("#avance, #avance_h").val('');
            $("#div_estimacion").hide();
            $("#est_original, #est_avance, #est_restan").html("");
            $("#slcIncidencia option").removeAttr('selected');
            $("#slcIncidencia").select2();
            $("#numero_detalles").val($("#contenedor_detalle_opciones tr").length);
            sumar_horas();
        } else {
            crear_alerta('error', 'Error', 'Incidencia y porcentaje de avance son obligatorios');
        }
    });


    $(".eliminar_detalle").live('click', function(event) {
        $(this).parent().parent().remove(); //eliminar el detalle
        $("#numero_detalles").val($("#contenedor_detalle_opciones tr").length);
        sumar_horas();
    });

    $(".editar_det").live('click', function(event) {
        id = $(this).data("id");
        $("#del_"+id).hide();
        $("#edt_"+id).hide();
        $("#txt_por_"+id).hide();
        $("#txt_efe_"+id).hide();
        $("#hpor_ava_"+id).show();
        $("#hhor_ava_"+id).show();
        $("#sav_"+id).show();        
    });

    $(".guarda_det").live('click', function(event) {
        id = $(this).data("id");
        var valor = $("#hpor_ava_"+id).val().trim();
        var horas = $("#hhor_ava_"+id).val().trim();
        if (valor != "" || horas != "") {
            var orgvl = $("#hdn_porc_"+id).val().trim();
            var orghr = $("#hdn_hora_"+id).val().trim();
            var est_or = $("#hest_tot_" + id).val();
            if (horas != "" && horas != orghr) {
                var nw_por = (parseFloat(horas) * 100) / parseFloat(est_or);
                $("#hpor_ava_"+id).val(number_format(nw_por,2));
            } else {
                if (valor != "" && valor != orgvl) {
                    var new_hor = parseFloat(est_or) * (parseFloat(valor) / 100);
                    $("#hhor_ava_"+id).val(number_format(new_hor,2));
                }
            }
            var porc_act = parseFloat( $("#hpor_ava_"+id).val() );
            if (porc_act > 100) {
                crear_alerta('warning', 'Atención', 'Los valores no debe exceder el limite permitido');
                return false;
            } else {
                var minimo = parseFloat($("#avance_almac_"+id).val());
                if (porc_act < minimo) {
                    crear_alerta('warning', 'Atención', 'Los valores no deben ser menor a lo almacenado');
                    return false;
                }
                var estimacion = parseFloat($("#txt_est_"+id).text());
                var e_efectiva = number_format((estimacion * (porc_act / 100)), 2);
                var estm_falta = number_format((estimacion - e_efectiva), 2);
                $("#hest_fal_"+id).val(number_format(estm_falta,2));
                $("#hest_efe_"+id).val(number_format(e_efectiva,2));
                $("#txt_por_"+id).text(number_format(porc_act,2));
                $("#txt_efe_"+id).text(number_format(e_efectiva,2));
                $("#txt_fal_"+id).text(number_format(estm_falta,2));                
                $("#hpor_ava_"+id).hide();
                $("#hhor_ava_"+id).hide();
                $("#edt_"+id).show();
                $("#sav_"+id).hide();
                $("#txt_por_"+id).show();
                $("#txt_efe_"+id).show();
                $("#del_"+id).show();
                sumar_horas();
            }
        } else {
            crear_alerta('warning', 'Atención', 'Valor numérico requerido');
            return false;
        }
    });

    if ($("#slcConsultor").val()>0) incidencias_consultor();

    $("#slcConsultor").change(function (event) {
        incidencias_consultor();
    });

    $("#regresarlistado").click(function(event) {
        event.preventDefault();
        url_action = $(this).attr('href');
        alerta_confirm(url_action,'Alerta confirmación','Los datos que insertaste no han sido guardados. <br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

});

function sumar_horas() {
    var estima_total = 0;
    var estima_efect = 0;
    var estima_falta = 0;
    var filas = $("#numero_detalles").val();
    $(".est_tot").each(function (index) {
        estima_total += parseFloat($(this).val());
    });
    $(".est_fal").each(function (index) {
        estima_falta += parseFloat($(this).val());
    });
    $(".est_efe").each(function (index) {
        estima_efect += parseFloat($(this).val());
    });
    if (filas > 0) {
        $("#sum_falta").val(number_format(estima_falta, 2));
        $("#total_est_falta").text(number_format(estima_falta, 2));
        $("#total_est_efect").text(number_format(estima_efect, 2));
        $("#total_estima").text(number_format(estima_total, 2));
        $("#pie_tabla").show();
    } else {
        $("#sum_falta").val(0);
        $("#total_est_falta").text("");
        $("#total_est_efect").text("");
        $("#total_estima").text("");
        $("#pie_tabla").hide();
    }
}


function incidencias_consultor() {
    if($("#slcConsultor").val()>0) {
           $.ajax({
               url:window.satelite.base_url('desarrollo/procesos/filtrar_incidencia_consultor'),
               type: 'POST',
               dataType: 'json',
               data: {
                   slcConsultor: $("#slcConsultor").val()
               },
               beforeSend: function () {
                   wait.start('Cargando incidencias...');
               },
               error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                $("#slcIncidencia").html(json.options);
                $("#slcIncidencia").select2();
                wait.close();
            }
        });
    } else {
        $("#slcIncidencia").html('<option value=""></option>');
        $("#slcIncidencia").select2();
    }
}

function validar_fecha() {
    if($("#slcConsultor").val()>0 && $("#txtFecha").val() != '' ) {
        id_edicion = $("#id_scrum").val();
           $.ajax({
               url:window.satelite.base_url('desarrollo/procesos/validar_daily_meeting'),
               type: 'POST',
               dataType: 'json',
               data: {
                   slcConsultor: $("#slcConsultor").val(),
                   txtFecha: $("#txtFecha").val()
               },
               beforeSend: function () {
                   //wait.start('validando...');
               },
               error: function (xhr, status, error){
                exportarError(xhr.responseText);
                wait.close();
            },
            success: function (json) {
                if (!json.exito) {
                  $("#slcIncidencia").html(json.options);
                  $("#slcIncidencia").select2();
                }
                wait.close();
            }
        });
    } 
}


function mueveReloj(){ 
    fecha_actual_php =  $("#txtFecha2").val().split(' ');
    segmento1 = fecha_actual_php[0].split('-');
    segmento2 = fecha_actual_php[1].split(':');
    //alert(segmento2);
    // momentoActual = new Date(segmento1[0],segmento1[1],segmento1[2],segmento2[0],segmento2[1],segmento2[2]); 
    momentoActual = new Date(); 
    dia = momentoActual.getDate();
    mes = momentoActual.getMonth();
    anio = momentoActual.getFullYear();
    hora = momentoActual.getHours() ;
    minuto = momentoActual.getMinutes(); 
    segundo = momentoActual.getSeconds(); 

    horaImprimible1 = segmento1[2] + "-" + segmento1[1] + "-" + segmento1[0]  + " " + hora + ":" + minuto + ":" + segundo ;
    horaImprimible2 = segmento1[2] + "-" + segmento1[1] + "-" + segmento1[0]  + " " + hora + ":" + minuto + ":" + segundo ;

    //alert(horaImprimible2);
    document.form_agregar.txtFecha.value = horaImprimible1;
    $("#txtFecha2").val((segmento1[0] + "-" + segmento1[1] + "-" + segmento1[2] + " " + hora + ":" + minuto + ":" + segundo));
    setTimeout("mueveReloj()",1000) ;
} 