$(document).ready(function(){
	var pathArray = window.location.pathname.split( '/' );
	var urlj=url_base_proyecto;

	// Array de Meses
	var meses = {'Enero': 1, 'Febrero': 2, 'Marzo': 3, 'Abril': 4, 'Mayo': 5, 'Junio': 6, 'Julio': 7, 'Agosto': 8, 'Septiembre': 9, 'Octubre': 10, 	'Noviembre': 11, 'Diciembre': 12};

	$("#telefono").mask("9999-9999");
    $("#supervisor, #estado, #usuario").select2();
    $("#meta_mensual_ventas").numeric(".");
    $("#meta_mensual_cotizaciones").numeric(".");
    $("#supervisor").find("option[value='0']").remove();

    $(".input-fecha").datepicker({
        closeText: 'Cerrar',
        prevText: '<Ant',
        nextText: 'Sig>',
        currentText: 'Hoy',
        monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
        monthNamesShort: ['Ene','Feb','Mar','Abr', 'May','Jun','Jul','Ago','Sep', 'Oct','Nov','Dic'],
        changeMonth: true,
        changeYear: true,
        showButtonPanel: true,
        dateFormat: 'MM-yy',
        onClose: function(dateText, inst) { 
                $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
        }
    });

    // Ocultar el calendario para solo mostrar el mes
    $(".input-fecha").focus(function () {
        $(".ui-datepicker-calendar").hide();
        $("#ui-datepicker-div").position({
            my: "center top",
            at: "center bottom",
            of: $(this)
        });
    });
						
	$("#usuario").on("change",function(){
		var retornar = false;
		var usuario = $(this).val();
		$.ajax({
			url : urlj+"cotizaciones/mantenimientos/validar_existe_vendedor",
			type: "POST",
			dataType: 'json',
			async: false,
			data : { usuario: usuario},
			success: function(data) {
				if(data.existe_usuario_ven > 0) {
					crear_alerta('error','El usuario ya esta registrado','');
					retornar = true;
					$("#usuario").val('').select2();
				}	
			}
		});
		if (retornar){
			return false;
		}
		$.ajax({
			url : urlj+"cotizaciones/mantenimientos/extraerUsuarios",
			type: "POST",
			async: false,
			dataType: 'json',
			data : {idp: $(this).val()},
			success: function(data) {
				$("#div_codigo_vendedor").html(data.codigo);
			  	$("#div_nombre").html(data.nombre);
			  	$("#div_apellido").html(data.apellido);
			  	$("#div_email").html(data.email);
			  	$("#usuario_error").html(data.vendedor);
			}
		});	
	});


	$("#frm-nuevo_vendedor").validate({
		ignore:"",
		rules: {
			usuario:{ required:true, min:1},
			supervisor:{ required: true, min:1},
			email:{email:true},
			estado:{required:true},
		}, 
		messages: {
			usuario: 'Campo requerido',
			supervisor: { min:'Campo requerido'},
			codigo_vendedor: { min:'Campo requerido'},
			estado:{min:'Campo requerido'},
		  }, 
		  errorPlacement: function (error, element) {
			var nombre=$(element).attr("id");
			$('#'+nombre+'_error').html(error);
		},
		submitHandler: function(form) {
			var usuario = $("#usuario").val();
			$.ajax({
				url : urlj+"cotizaciones/mantenimientos/validar_existe_vendedor",
			    type: "POST",
				dataType: 'json',
				data : { usuario: usuario},
			  	
			  success: function(data) {
			  	if ($("#revisar_accion").val() > 0) {
			  		if(!data.existe_usuario_ven > 0) {
						form.submit();
					}else{
						crear_alerta('error','El usuario ya esta registrado','');
					}	
			  	} else {
			  		form.submit();
			  	}
				
			   }
		   	});	
		}
	});

	$("body").on("click", "#btn_guardar_metas", function(e) {
		e.preventDefault();
		$("#tbl_metas").DataTable().fnDestroy();
        var mes 	= $("#mes").val();
        var visitas = ($("#vis_clientes").val() > 0)? parseInt($("#vis_clientes").val()) : 0;
        var ventas  = ($("#venta_meta").val() > 0)? parseFloat($("#venta_meta").val()) : 0;
        var cot  	= ($("#meta_cot").val() > 0)? parseFloat($("#meta_cot").val()) : 0;
        var contador = parseInt($("#metas_contador").val());

        // Obtener la fecha
        var mes_split = mes.split('-'); 
        var fecha = mes_split;

        if(validar_campo_repetido((mes), ".metas_validar", "#tb_metas_ventas")){
            crear_alerta("info", "Aviso", 'El registro ya existe.');
            return false;
        }
        if(mes != ""){
            caja_conf = '<input type="hidden" class="metas_validar" value="'+mes+'">';

            caj_mes = '<input type="hidden" id="metas_mes'+contador+'" name="metas_mes[]" value="'+mes+'">'+
            		  '<input type="hidden" id="metas_fecha_'+contador+'" name="metas_fecha_[]" value="'+fecha[1]+'-'+meses[fecha[0]]+'">'+
                      '<label style="padding: 6px 4px;">'+mes+'</label>';

			caj_meta_venta = '<input type="hidden" id="metas_venta'+contador+'" name="metas_venta[]" value="'+ventas+'">'+
                             '<label style="padding: 6px 4px;">$'+number_format(ventas, 2)+'</label>'; 

            caj_meta_cot = '<input type="hidden" id="metas_cot'+contador+'" name="metas_cot[]" value="'+cot+'">'+
                           '<label style="padding: 6px 4px;">$'+number_format(cot, 2)+'</label>';

            caj_visita_cliente = '<input type="hidden" id="visita_cliente'+contador+'" name="visita_cliente[]" value="'+visitas+'">'+
                                 '<label style="padding: 6px 4px;">'+number_format(visitas)+'</label>';

            eliminar = '<a class="btn btn-danger minia-icon-trashcan white remover_tr action" title="Eliminar Meta" style="margin-right: 5px;cursor:pointer;font-size:15px;">Eliminar</a>';
            caj_acciones = eliminar;

            $("#tb_metas_ventas").append('<tr id="metas_tr'+contador+'" class="metas_tr">'+
                '<td width="10%">'+(contador)+'</td>'+
                '<td width="20%">'+caja_conf + caj_mes+'</td>'+
                '<td width="20%">'+caj_meta_venta+'</td>'+
                '<td width="20%">'+caj_meta_cot+'</td>'+
                '<td width="10%">'+caj_visita_cliente+'</td>'+
                '<td width="20%" style="text-align: center;">'+caj_acciones+'</td></tr>');


            contador += 1;
            $("#metas_contador").val(contador);
        } else{
            if(!(mes != "")){
                $("#mes_error").text('Campo requerido.');
            }
        }

        aplicar_datatable("#tbl_metas");
        $("#tbl_metas").css("width", "100%");

	});

	$("body").on('click', ".remover_tr", function(){ //elimina el componente agregado
		$("#tbl_metas").DataTable().fnDestroy();
        var tr = $(this).closest('tr');
        tr.remove();
        aplicar_datatable("#tbl_metas");
        $("#tbl_metas").css("width", "100%");
    });

}); // End document ready

function validar_campo_repetido(valor, campo, padre){
    var validar_unico = false;
    var validacion = $(padre + ' tr input'+campo+'[value="'+valor+'"]').length;
    if(validacion != 0){
        validar_unico = true;
    }
    $("#tbl_metas").css("width", "100%");
    return validar_unico;
}

function aplicar_datatable(id){
    $(id).dataTable({
        //"sPaginationType": "full_numbers",
        "bFilter": false,
        "bJQueryUI": false,
        "bAutoWidth": true,
        "iDisplayLength": 5,        
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}