jQuery(document).ready(function ($) {
    $('#tabla').dataTable({
      "aaSorting": [[ 1, "desc" ]] //ordena desc
    });
    $("#slcVendedor,#slcMedioContacto,#slcmotivo").select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({dateFormat: 'dd-mm-yy', changeMonth: true, changeYear: true});

    $("#txtFecha_desde,#txtFecha_hasta").change(function(event) {  validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta'); });

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            txtFecha_desde: {required: true},
            txtFecha_hasta: {required: true}
        },
        messages: {
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");
        },
        submitHandler: function (form) {
           wait.start();
           $("#contenedorTabla").hide("slide", { 
            direction: 'right'
          }, 400, function() { //despues de ocultar div enviar el ajax
              url_ajax = window.satelite.base_url('cotizaciones/cotizaciones/filtrar_tabla_llamadas');
               $.ajax({
                   url: url_ajax,
                   type: 'POST',
                   dataType: 'json',
                   data: {
                       txtFecha_desde: $("#txtFecha_desde").val(),
                       txtFecha_hasta: $("#txtFecha_hasta").val(),
                       slcVendedor: $("#slcVendedor").val(),
                       slcmotivo: $("#slcmotivo").val(),
                       slcMedioContacto: $("#slcMedioContacto").val()
                   },
                   beforeSend: function () {
                       wait.start();
                   },
                   error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $("#contenedorTabla").html(json.html);
                    $("#contenedorTabla table:first").attr('style', 'font-size: 14px;');
                    //$('#tabla').dataTable();
                    $('#tabla').dataTable({
                      "aaSorting": [[ 0, "desc" ]] //ordena desc
                    });

                    $("#contenedorTabla").show("slide", {
                      direction: 'left'
                    }, 500);
                    wait.close();
                }
            });

          });
       }
   });

    $('#contenedorTabla').on('click', '.eliminar_registro', function (){
          event.preventDefault();
          /* Act on the event */
         // alert($(this).attr('href')); 
          alerta_confirm($(this).attr('href')
              ,'Alerta confirmación',
              '¿Seguro que quieres borrar este registro?'
              );

    });

 //Modal de Multiselects
    $(".asociarCliente").fancybox({
        width: '50%',
        height: '50%',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
            //var id = $(this.element[0]).attr('data-id');
            var base_datos = $(this.element[0]).attr('data-base');
            $("#hdnBase").val(base_datos);
        },
        beforeClose: function () {
            $("#hdnBase").val('');
        }
    });

    $('#slcCliente').select2();

      $("#slcCliente").change(function () {
        var cliente = $(this).val();
        if (cliente > 0) {
            $("#btnNuevo").hide('500');
            $("#btnAsociar").show('500');
        } else {
            $("#btnAsociar").hide('500');
            $("#btnNuevo").show('500');
        }
    });

        $(".btn-asociar").click(function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        var base = $("#hdnBase").val();
        var cliente = $("#slcCliente").val();
        var traspaso = 1;
        var otro_modulo = 0;
        var modal =0;
        wait.start();
        if (cliente > 0) {
            $('#slcCliente option:selected').removeAttr('selected');
           $('#slcCliente').select2();
            location.href = url + '/' + cliente + '/' + modal + '/' + otro_modulo + '/' + base;
        } else {
            location.href = url + '?bd=' + base;
        }
    });


});