$(document).ready(function () {
    $('select').select2({placeholder: "Seleccione una opción"});

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    function backgroundSelect(element) {
        var id = parseInt(element.id);
        var select = $(this.element[0]).attr('id');
        var img = element.element ? $('#' + element.element[0].id).data('img') : $("#" + select + ' option:selected').data('img');
        var item = (id > 0 && img != '') ? '<span><img src="' + img + '" class="opt-icon" /> ' + element.text + '</span>' : '<span>' + element.text + '</span>';
        return item;
    }

    $("#slcVendedor, #slcEstado").select2({
        formatResult: backgroundSelect,
        formatSelection: backgroundSelect,
        placeholder: "Seleccione una opción"
    });

    $("#slcCliente").select2({
        placeholder: "Buscar Cliente",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'cotizaciones/cotizaciones/get_clientes',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cliente,
                        'text': item.cliente_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $(".image-thumbnail").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            'height': '300',
            type: 'iframe',
            closeBtn: true
        });
    });

    $(".modal-action").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            'height': '300',
            type: 'iframe',
            closeBtn: true
        });
    });

    /*$(".menu-action").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            'height': '300',
            type: 'iframe',
            closeBtn: true
        });
    });*/

    $(".verAnexo").fancybox({});

    $(document).on('contextmenu', '.cot-detail', function (e) {
        var id = $(this).data('id');
        var flagGanada = $(this).data('flag-ganada');
        var flagPerdida = $(this).data('flag-perdida');

        $("#cot-layout a").each(function () {
            var link = $(this).attr('href');
            if(link) {
                $(this).attr('href', link.replace('[COT_ID]', id));
            }
        });

        $("#cot-layout .cot-menu-option").show(); 
        if (flagGanada == 1 || flagPerdida == 1) {
            $("#cot-layout a:contains('Ganada')").parent().hide();
            $("#cot-layout a:contains('Perdida')").parent().hide();
        }

        $("#cot-layout").css({'display': 'block', 'left': e.pageX, 'top': e.pageY});

        return false;
    });

    $(document).click(function (e) {
        if (e.button == 0) {
            $("#cot-layout").css({'display': 'none'});
        }
    });

    $(document).keydown(function (e) {
        if (e.keyCode == 27) {
            $("#cot-layout").css({'display': 'none'});
        }
    });

    $(document).on('click', '.dtl-ctr-addcoment', function (event) {
        event.preventDefault();
        var cot = $("#cot_id").val();
        var link = $(this).attr('href');
        var url = link + '/' + cot + '?iframe=1';
        $.fancybox({
            'href': url,
            'height': '200',
            type: 'iframe',
            closeBtn: true
        });
    });

    $(document).on('click', '.clm-action-close', function () {
        $("#column-detail").hide();
    });

    $(document).on('click', '.cot-detail', function () {
        $(".cot-detail").removeClass('cot-selected-detail');
        $(this).addClass('cot-selected-detail');
        $("#column-detail").show();
        var cot = $(this).data('id');
        if (cot > 0) {
            $.ajax({
                url: urlj + 'cotizaciones/cotizaciones/detalle_cotizacion',
                data: {cotizacion: cot},
                type: 'POST',
                beforeSend: function () {
                    $("#column-detail").html('<div id="loaderDetail"><div id="loaderBar"></div></div>');
                    $("#loaderDetail").css('visibility', 'visible');
                    $("#loaderBar").css('visibility', 'visible');
                },
                success: function (data) {
                    $("#column-detail").html($.trim(data));
                }
            });
        }
    });

    $("#btnFiltrar").click(function (event) {
        event.preventDefault();
        var slcVendedor = $("#slcVendedor").val();
        var slcCliente = $("#slcCliente").val();
        var slcEstado = $("#slcEstado").val();
        var slcEstadoCotizacion = $("#slcEstadoCotizacion").val();
        var txtFechaInicio = $("#txtFechaInicio").val();
        var txtFechaFin = $("#txtFechaFin").val();
        var chkCot = $("#inlineCheckbox7").is(':checked') ? 1 : 0;

        if (txtFechaInicio != '' && txtFechaFin != '' && !validarPeriodo(txtFechaInicio, txtFechaFin)) {
            crear_alerta('error', 'Filtros', 'Verifique el período de las fechas.');
            return false;
        }

        var filtroLabel = [];
        if (slcVendedor) filtroLabel.push('Vendedor: ' + $("#slcVendedor option:selected").text());
        if (slcCliente) filtroLabel.push('Cliente: ' + $("#slcCliente option:selected").text());
        if (slcEstado) filtroLabel.push('Estado: ' + $("#slcEstado option:selected").text());
        if (slcEstadoCotizacion) filtroLabel.push('Estado Cotización: ' + (slcEstadoCotizacion === 'ganada' ? 'Ganada' : 'Perdida'));
        if (txtFechaInicio && txtFechaFin) filtroLabel.push('Fechas: ' + txtFechaInicio + ' - ' + txtFechaFin);
        $("#lblFiltros").text(filtroLabel.join(' | '));
        $("#dvInfoFiltros").show();

        consultar_pipeline({
            vendedor: slcVendedor,
            cliente: slcCliente,
            estado: slcEstado,
            estado_cotizacion: slcEstadoCotizacion,
            fecha_inicio: txtFechaInicio,
            fecha_fin: txtFechaFin,
            chkCot: chkCot,
            json: true
        });
    });

    var h = $(window).height();
    $(".content-work").height(h - 50);

    //setInterval(consultar_cambios, 300000);

    function aplicarSortable() {
        $(".sorteable-cotizacion").sortable({
            connectWith: '.sorteable-cotizacion',
            placeholder: 'placeholder',
            scroll: true,
            scrollSensitivity: 100,
            scrollSpeed: 10,
            tolerance: 'pointer',
            forcePlaceholderSize: true,
            containment: '.content-subparent',
            helper: 'clone',
            start: function (event, ui) {
                $(this).addClass('loading');
                $(this).addClass('without-holder');
                $(".sorteable-cotizacion").addClass('placeholder2');
                $(this).removeClass('placeholder2');
                $('#' + ui.item[0].id).addClass('cot-selected');
                
                //$(".cot-detail").hide();
                var placeholderHeight = $(this).find('.cot-detail').length > 0 ? ui.item.outerHeight() : $(this).height();
            
                ui.placeholder.css({
                    height: placeholderHeight,
                    width: ui.item.outerWidth(),
                    visibility: 'visible'
                });
                $(".cot-detail", this).addClass('cot-hold');
            },
            stop: function (event, ui) {
                $(".sorteable-cotizacion").removeClass('loading');
                $(".sorteable-cotizacion").removeClass('placeholder2');
                $(".sorteable-cotizacion").removeClass('without-holder');
                $('#' + ui.item[0].id).removeClass('cot-selected');
                $(".cot-detail").removeClass('cot-hold');
                $(".cot-detail").show();

                var maxHeight = 150;
                $('.sorteable-cotizacion').each(function() {
                    var totalHeight = 0;
                    $(this).find('.cot-detail').each(function() {
                        totalHeight += $(this).outerHeight(true);
                    });
                    maxHeight = Math.max(maxHeight, totalHeight + 20);
                });
                $('.sorteable-cotizacion').css('min-height', maxHeight + 'px');
            },
            receive: function (event, ui) {
                var cot = $('#' + ui.item[0].id).data('id');
                var etapa = $(this).data('type');
                if (cot > 0 && etapa > 0) {
                    $(this).addClass('loading');
                    $.ajax({
                        url: urlj + 'cotizaciones/cotizaciones/registrar_seguimiento_cotizacion',
                        data: {cotizacion: cot, etapa: etapa},
                        type: 'POST',
                        beforeSend: function () {
                            $(this).addClass('loading');
                        },
                        success: function (data) {
                            $(this).removeClass('loading');
                            setTimeout(function () {
                                consultar_cambios();
                            }, 1000);
                        }
                    });
                }
            }
        }).disableSelection();
    }

    aplicarToolTip();

    function consultar_pipeline(params) {
        $.ajax({
            url: urlj + 'cotizaciones/cotizaciones/consultar_pipeline',
            data: params,
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                
                wait.close();
                cargarCotizaciones(data);
                aplicarSortable();
                contabilizarTotalesEtapa();
                aplicarToolTip();
            }
        });
    }

    function cargarCotizaciones(data) {
        var html = '<ul class="etapas-cotizaciones">';
        $.each(data.etapas, function (i, etapa) {
            html += '<li class="etapa-cotizacion">';
            html += '<ul class="sorteable-cotizacion unstyled" id="etapa_' + etapa.etc_id + '" data-type="' + etapa.etc_id + '">';
            $.each(data.cotizaciones, function (j, cot) {
                if (cot.cot_id_etc == etapa.etc_id) {
                    html += '<li id="cotizacion_' + cot.cot_id + '" class="cot-detail span12 cot-has-avatar etapa_' + etapa.etc_id + '" data-total="' + cot.cot_total + '" data-id="' + cot.cot_id + '" data-flag-ganada="' + cot.flag_ganada + '" data-flag-perdida="' + cot.flag_perdida + '">';
                    html += '<div class="row-top">';
                    html += '<div class="cot-content">';
                    html += '<div class="cot-fields">';
                    html += '<div class="cot-code" title="' + cot.cot_codigo + '"><a href="' + urlj + 'cotizaciones/cotizaciones/editar_cotizacion/' + cot.cot_id + '/1" target="_blank"><label>' + cot.cot_codigo + '</label></a></div>';
                    
                    html += '<div class="cot-summary"><span class="cot-title">' + cot.cot_concepto + '</span></div>';
                    html += '</div></div>';
                    html += '<div class="cot-avatar" title="' + cot.ven_nombre + '">';
                    html += '<span class="cot-avatar-img" style="background-color:' + cot.emp_color_icono + ';">';
                    if (cot.existe_foto_vendedor == 1) { 
                        html += '<img src="' + cot.ven_foto + '" class="cot-avatar-img">';
                    } else {
                        html += cot.ven_nombre.charAt(0);
                    }
                    html += '</span></div>';
                    html += '</div>';
                    html += '<div class="cot-extras">';
                    html += '<span>Cliente: ' + cot.cli_nombre + '</span>';
                    html += '<span>Vendedor: ' + cot.ven_nombre + '</span>';
                    html += '<span>Fecha de Presentación: ' + cot.cot_fecha_pres + '</span>';
                    html += '<span>Total: $' + Math.floor(parseFloat(cot.cot_total)) + '</span>';
                    html += '</div>';
                    html += '</li>';
                }
            });
            html += '</ul></li>';
        });
        html += '</ul>';
        $(".content-cotizaciones").html(html);
        $(".content-cotizaciones").css('margin-top', '-20px');

        var max_height = 150;
        $('.sorteable-cotizacion').each(function() {
            var totalHeight = 0;
            $(this).find('.cot-detail').each(function() {
                totalHeight += $(this).outerHeight(true); 
            });
            
            max_height = Math.max(max_height, totalHeight + 20);
        });
        $('.sorteable-cotizacion').css('min-height', max_height + 'px');

        
        $('.cot-detail').each(function() {
            var margen = 5;
            $(this).find('.row-top').css('margin-bottom', margen + 'px');
        });

        setTimeout(function() {
            $(window).trigger('resize');
        }, 100); 
    }

    function aplicarToolTip() {
        $('.cot-avatar').qtip({
            content: false,
            position: {
                my: 'bottom center',
                at: 'top center',
                viewport: $(window)
            },
            style: {
                classes: 'ui-tooltip-tipsy'
            }
        });
    }

    function contabilizarTotalesEtapa() {
        $(".etapas_pizarra").each(function () {
            var id_etapa = $(this).data('id_etapa');
            var total_monto = 0;
            var numero_cots = 0;
            $(".etapa_" + id_etapa).each(function () {
                total_monto += parseFloat($(this).data('total')) || 0;
                numero_cots++;
            });
            $("#horas_etapa_" + id_etapa).text(' ($' + Math.floor(total_monto) + ' / ' + numero_cots + ' Cot.)');
        });
    }

    function consultar_cambios() {
        var est_id = $("#slcEstado").val();
        var chkCot = $("#inlineCheckbox7").is(':checked') ? 1 : 0;
        var fecha_pasada = $("#txtFechaInicio").val();
        var fecha_actual = $("#txtFechaFin").val();
        var slcVendedor = $("#slcVendedor").val();
        var slcCliente = $("#slcCliente").val();

        $.ajax({
            url: urlj + 'cotizaciones/consultas/consultar_seguimiento_cotizacion',
            data: {estado: est_id, chkCot: chkCot, fecha_inicio: fecha_pasada, fecha_fin: fecha_actual, vendedor: slcVendedor, cliente: slcCliente},
            type: 'POST',
            async: true,
            success: function (data) {
                data = parseInt(data);
                if (data == $("#seguimiento").val()) {
                    // No changes
                } else {
                    $("#seguimiento").val(data);
                    consultar_pipeline({
                        vendedor: slcVendedor,
                        cliente: slcCliente,
                        estado: est_id,
                        fecha_inicio: fecha_pasada,
                        fecha_fin: fecha_actual,
                        chkCot: chkCot,
                        json: true
                    });
                }
            }
        });
    }

    $(".ibutton_filtro").iButton({
        labelOn: "Activas",
        labelOff: "Inactivas",
        //enableDrag: false,
        /*change: function (element) {
            if (element.is(':checked')) {
                $("#slcVendedor").val('').select2();
                $("#btnFiltrar").trigger('click');
            } else {
                if ($("#slcVendedor option[value='" + id_usuario + "']").length > 0) {
                    $("#slcVendedor").val(id_usuario).select2();
                    $("#btnFiltrar").trigger('click');
                } else {
                    crear_alerta("info", 'Sin registros', 'Usuario sin cotizaciones o sin permiso');
                    setTimeout(function () {
                        $('.ibutton_filtro').prop('checked', true);
                        $(".ibutton_filtro").iButton("repaint");
                    }, 150);
                }
            }
        }*/
    });
});