$(document).ready(function () {
    preseleccionar_x_elementos();
    $("select option[value='0']").text('');
    $("select option[value='0']").val('');
    $("select").select2({placeholder: "Seleccione una opción"});
    $(".slc_edit").hide();
    $('#txtCantidad').attr('decimales',$("#cantidaddecimales").val())

    $("#frm-presupuesto").validate({
        ignore: "",
        rules: {
            txtOrden: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').html(error);
        },
        invalidHandler: function (form, validator) {
            var errors = validator.numberOfInvalids();
            if (errors) {
                var primerElemento = validator.errorList[0].element;

                var posiciones = primerElemento.offsetTop;
                $("html, body").animate({scrollTop: posiciones}, 1000);
            }
        },
        submitHandler: function (form) {
            if ($('#tbMateriaPrima .trMateriaPrima').length == 0 && $('#tbManoObra .trManoObra').length == 0 && $('#tbGastos .trGastosInd').length == 0) {
                crear_alerta('error', 'Presupuesto', 'Ingrese al menos un registro');
                return false;
            }else{
                var cont = 0;  
                $('.resp_edit').each(  function( key, value) {
                    if($(this).val()<=0){
                        cont++;
                    }
                });
                // if(cont>0){
                    // crear_alerta('error', 'Mano de obra', 'El responsable es requerido');
                    // return false;
                // }else{
                    form.submit();
                // }
            }
        }
    });

    $("#slcMateriaPrima").change(function () {
        producto = $(this).val();
        $("#slcMedida").html('<option></option>');
        $("#slcMedida").select2({placeholder: "Seleccione una opción"});
        if (producto != '') {
            $.ajax({
                url: urlj + "proyectos/procesos/get_detalles_producto",
                type: 'POST',
                dataType: 'json',
                data: {producto: producto},
                beforeSend: function () {
                    wait.start('Espere un momento por favor... Buscando información del producto.');
                },
                success: function (data) {
                    wait.close();
                    $("#slcMedida").html(data.medidas);
                    $("#slcMedida").select2({placeholder: "Seleccione una opción"});
                    $("#hdnProducto").data('codigo', data.producto.prod_codigo);
                    $("#hdnProducto").data('nombre', data.producto.prod_nombre);
                    var tipo_precio = $("#slcTipoPrecio").val();
                    var producto = $("#slcMateriaPrima").val();
                    var proveedor = $("#slcProveedor").val();
                    obtener_precio(tipo_precio, producto, proveedor);
                }
            });
        }
    });

    $(".buscarResponsable").select2({
        placeholder: "Buscar Responsable",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_empleados_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (empleado) {
                return {
                    empleado: empleado
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.empleado,
                        'text': item.emp_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });
    $(".select-edit").select2('destroy');

    $("#slcProveedor").change(function () {
        var tipo_precio = $("#slcTipoPrecio").val();
        var producto = $("#slcMateriaPrima").val();
        var proveedor = $("#slcProveedor").val();
        obtener_precio(tipo_precio, producto, proveedor);
    });

    $("#slcTipoPrecio").change(function () {
        var tipo_precio = $("#slcTipoPrecio").val();
        var producto = $("#slcMateriaPrima").val();
        var proveedor = $("#slcProveedor").val();
        obtener_precio(tipo_precio, producto, proveedor);
    });

    $("#slcManoObra").change(function () {
        var mano_obra = $(this).val();
        $("#txtPrecioMob").val('');
        if (mano_obra != '') {
            var precio = $('#' + this.id + ' option:selected').data('precio');
            var etapas = $('#' + this.id + ' option:selected').data('etapas');
            $("#txtPrecioMob").val(precio);
            if (etapas > 0) {
                var horas = get_ctdad_hora_mob_gif(mano_obra, 0);
                $("#txtCantidadMob").val(horas);
            } else {
                $("#txtCantidadMob").val('');
            }
        } else {
            $("#slcResponsable").select2("val", "");
            $("#txtCantidadMob").val('');
        }
    });

    //Materia Prima
    $("#btnAgregarMateria").click(function () {
        var row = 0;
        if ($('#tbMateriaPrima .trMateriaPrima').length > 0) {
            row = $("#tbMateriaPrima .trMateriaPrima:last").data('id')+1;
        }

        var slcMateriaPrima = $("#slcMateriaPrima").val();
        var slcMateriaPrimaText = $("#hdnProducto").data('nombre');
        var slcMateriaPrimaHtml = getOpcionesSelect("#slcMateriaPrima");
        var slcMateriaCodigo = $("#hdnProducto").data('codigo');
        var slcProveedor = $("#slcProveedor").val();
        var slcProveedorText = $("#slcProveedor option:selected").text();
        var slcProveedorHtml = getOpcionesSelect("#slcProveedor");
        var slcMedida = $("#slcMedida").val();
        var slcMedidaText = $("#slcMedida option:selected").text();
        var slcMedidaHtml = getOpcionesSelect("#slcMedida");
        var txtPrecio = $("#txtPrecio").val();
        var txtCantidad = $("#txtCantidad").val();

        if($("#decimales").val()>0){
            var decimales = $("#decimales").val();
        }else{
            var decimales = 2;
        }

        if (slcMateriaPrima == '' || txtPrecio == '' || txtCantidad == '') {
            crear_alerta('error', 'Materia Prima', 'Debe completar los campos necesarios.(Materia Prima, Precio, Cantidad).');
            return false;
        }
        if (txtPrecio < 0) {
            crear_alerta('error', 'Materia Prima', 'Ingrese una cantidad válida.');
            return false;
        }

        if (txtCantidad <= 0) {
            crear_alerta('error', 'Materia Prima', 'La Cantidad debe ser mayor a cero.');
            return false;
        }

        if ($("#trMp_" + slcMateriaPrima).length > 0) {
            crear_alerta('error', 'Materia Prima', 'El producto ya fue ingresado.');
            return false;
        }

        slcMateriaPrimaHtml = slcMateriaPrimaHtml.replace(/"/g, "'");
        slcProveedorHtml = slcProveedorHtml.replace(/"/g, "'");
        slcMedidaHtml = slcMedidaHtml.replace(/"/g, "'");

        var html = '';

        var subTotal = (parseFloat(txtPrecio) * parseFloat(txtCantidad));

        html += '<tr id="trMp_' + slcMateriaPrima + '" class="trMateriaPrima" data-id="' + row + '">';

        html += '<td>';
        html += '<input type="hidden" name="hdnDetalleMateria[]" class="tables-input" value="0" />';
        html += '<input type="text" class="text tables-input select-text" value="' + slcMateriaCodigo + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:22%; max-width:22%; font-size:11px;color:#777;font-weight:bold;word-wrap:break-word;">' + slcMateriaPrimaText;
        html += '<select id="slcMateriaPrima_' + row + '" data-id="' + row + '" name="materiaPrima[]" style="display:none;" class="materiaPrima select-edit">' + slcMateriaPrimaHtml + '</select>';
        html += '<input type="hidden" class="id_materia" id="id_materia_' + row + '" value="' + slcMateriaPrima + '" data-id="' + row + '">';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + slcMedidaText + '" readonly="readonly"/>';
        html += '<select id="slcMedida_' + row + '" data-id="' + row + '" name="conversionesMateria[]" style="display:none;" class="conversionMateria select-edit">' + slcMedidaHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<label class="text tables-input select-text">' + slcProveedorText + '</label>';
        html += '<select id="slcProveedor_' + row + '" data-id="' + row + '" name="proveedoresMateria[]" style="display:none;" class="proveedorMateria select-edit">' + slcProveedorHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtCantidad_' + row + '" name="cantidadesMateria[]" class="text tables-input-show tables-input soloDecimales cantidadMateria edit" value="' + txtCantidad + '" decimales = "'+ $("#cantidaddecimales").val() +'"readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtPrecio_' + row + '" name="preciosMateria[]" class="text tables-input-show tables-input soloDecimales precioMateria edit" value="' + number_format(txtPrecio, decimales) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:15%">';
        html += '<input type="text" id="txtSubtotal_' + row + '" name="subtotalesMateria[]" class="text tables-input-show tables-input subtotalMateria" extras="." value="' + number_format(subTotal, decimales) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:10%;text-align: center;">';
        html += '<input type="checkbox" id="chkEstMateria_' + row + '" data-subtotal = "txtSubtotal_' + row + '" class="nostyle aplicar_estimacion est_materia" />';
        html += '<input type="hidden" id="chkEstMateria' + row + '" name="chkEstMateria[]" value="0" />';
        html += '</td>';

        html += '<td>';
        html += '<button type="button"  class="btn btn-primary btn-mini editar_fila btnEditMateriaPrima" data-edit="'+row+'" style="float:left; height:30px;width:50px;"> Editar</button>';
        html += '<button type="button"  class="btn btn-primary btn-mini materiaPrima guardar_fila" data-edit="'+row+'" style="float:left; height:30px; width:50px;display:none;"> Guardar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelMateriaPrima" style="float:left; margin-left:5%; height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
        html += '</td>';

        html += '</tr>';


        var oTable = $('#tblMateriaPrima').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbMateriaPrima").append(html);
        aplicarDataTable('#tblMateriaPrima');

        $("#txtPrecio").val('');
        $("#txtCantidad").val('');
        $("#slcMateriaPrima option:selected").removeAttr('selected');
        $("#slcMateriaPrima").select2({placeholder: "Seleccione una opción"});
        $("#slcProveedor option:selected").removeAttr('selected');
        $("#slcProveedor").select2({placeholder: "Seleccione una opción"});
        $("#slcTipoPrecio option:selected").removeAttr('selected');
        $("#slcTipoPrecio").select2({placeholder: "Seleccione una opción"});

        $("#slcMedida").html('<option></option>');
        $("#slcMedida").select2({placeholder: "Seleccione una opción"});
        calcularTotal("#tbMateriaPrima .trMateriaPrima", ".subtotalMateria", "#txtTotalMateria");
        preseleccionar_x_elementos();
    });

    //Eliminar Materia Prima
    $(".btnDelMateriaPrima").live("click", function () {
        var parent = $(this).parent().parent();
        var oTable = $('#tblMateriaPrima').dataTable();
        oTable.fnDeleteRow(parent[0]);
        if (!(oTable.fnGetData().length) > 0) {
            //Si no hay filas esconder boton
            $("#actualizar_precios").hide();
        }
        calcular_gastos();
        calcularTotal("#tbMateriaPrima .trMateriaPrima", ".subtotalMateria", "#txtTotalMateria");
    });

    $("#actualizar_precios").live("click", function () {
        var materias = {};
        var nu_obj = {};
        wait.start();
        $('.id_materia').each(function(){
            var id = $(this).data('id');
            materias[id] = $(this).val();
        });        
        if (!($.isEmptyObject(materias))) {
            var datos = JSON.stringify(materias);            
            $.ajax({
                type: 'post',
                dataType: 'json',
                async: false,
                url: urlj + 'proyectos/procesos/actualizar_precio_mat_prima/1',
                data: {
                    datos: datos,
                    axc_id: $("#axc").val()
                },
                success: function (data) {
                    if (data.error == 0) {
                        nu_obj = $.parseJSON(data.valores);
                    }
                }
            });
        }
        if (!($.isEmptyObject(nu_obj))) {
            var dec = $("#decimales").val();
            $.each(nu_obj, function( key, value ) {
                if (key != "error") {
                    var ctdad = $("#txtCantidad_" + key).val();
                    var price = ctdad * value;
                    $("#txtPrecio_" + key).val(number_format(value,dec,'.',''));
                    $("#txtSubtotal_" + key).val(number_format(price,dec,'.',''));
                }                
            });            
            calcularTotal("#tbMateriaPrima .trMateriaPrima", ".subtotalMateria", "#txtTotalMateria");
        }
        wait.close();
    });

    $(".editar_fila").live("click", function () {
        $(this).hide();
        var cont = $(this).data('edit');
        var parent = $(this).parent().parent();
        if($(this).hasClass('ManoObra')){
            $(".select-text"+cont).text('');
            $("#empleado_edit_"+cont).show();
            $("#empleado_edit_"+cont).select2({placeholder: "Seleccione una opción"});
        }

        $("#" + parent[0].id + " .edit").removeAttr('readonly');
        $("#" + parent[0].id + " .edit").removeClass('tables-input');
        
        $("#" + parent[0].id + " .guardar_fila").show();
    });

    //--------Boton guardar para la tabla de articulos
$(".guardar_fila").live('click',function(event){
    var cont = $(this).data('edit');

    if($(this).hasClass('materiaPrima')){
        var can = $("#txtCantidad_"+cont).val();
        var cantidad = can.replace(/,/g, "");
        var pre = $("#txtPrecio_"+cont).val();
        var precio = pre.replace(/,/g, "");
    }else if($(this).hasClass('ManoObra')){
        var can = $("#txtCantidadMob_"+cont).val();
        var cantidad = can.replace(/,/g, "");
        var pre = $("#txtPrecioMob_"+cont).val();
        var precio = pre.replace(/,/g, "");
    }else{
        var can = $("#txtCantidadGasto_"+cont).val();
        var cantidad = can.replace(/,/g, "");
        var pre = $("#txtPrecioGasto_"+cont).val();
        var precio = pre.replace(/,/g, "");
    }

    if(!(cantidad > 0) || isNaN(cantidad)){
        crear_alerta('error','Informaci&oacute;n','Ingrese la cantidad'); 
    }
    else if(precio <0 || isNaN(precio)){
        crear_alerta('error','Informaci&oacute;n','El precio del producto debe ser una cantidad válida.');
    }
    else{
        var parent = $(this).parent().parent();
        var subtotal = cantidad * number_format(precio, $("#decimales").val(),'.', '');
  
        if($(this).hasClass('materiaPrima')){
            $("#txtSubtotal_"+cont).val(number_format(subtotal, $("#decimales").val()));
            $("#" + parent[0].id + " .delete_fila").val(number_format(subtotal, $("#decimales").val()));
            calcularTotal("#tbMateriaPrima .trMateriaPrima", ".subtotalMateria", "#txtTotalMateria");
        }else if($(this).hasClass('ManoObra')){

                $("#txtSubtotalMob_"+cont).val(number_format(subtotal, $("#decimales").val()));
                $("#" + parent[0].id + " .delete_fila").val(number_format(subtotal, $("#decimales").val()));
                    
                var resp_id = $("#empleado_edit_"+cont).val();
                $("#slcResponsable_"+cont).val(resp_id); 
                var slcResponsableText = ($("#empleado_edit_"+cont+" option:selected").text()).trim();
                $("#empleado_edit_"+cont).select2("destroy").hide();
                $(".select-text"+cont).text(slcResponsableText);

                calcularTotal("#tbManoObra .trManoObra", ".subtotalMob", "#txtTotalManoObra");
            
        }else{
            $("#txtSubtotalGasto_"+cont).val(number_format(subtotal, $("#decimales").val()));
            $("#" + parent[0].id + " .delete_fila").val(number_format(subtotal, $("#decimales").val()));
            calcularTotal("#tbGastos .trGastosInd", ".subtotalGasto", "#txtTotalGastos");
        }

        $(this).hide();
        $("#" + parent[0].id + " .edit").attr('readonly','readonly');
        $("#" + parent[0].id + " .edit").addClass('tables-input');
        $("#" + parent[0].id + " .editar_fila").show();
    }
    calcular_gastos();
});


    ///////////////////////////////////////////// Mano de Obra  ////////////////////////////////////////////////////
    $("#btnAgregarMob").click(function () {
        var row = 0;
        if ($('#tbManoObra .trManoObra').length > 0) {
            row = $("#tbManoObra .trManoObra:last").data('id')+1;
        }

        var slcManoObra = $("#slcManoObra").val();
        var slcManoObraText = $("#slcManoObra option:selected").text();
        var slcManoObraHtml = getOpcionesSelect("#slcManoObra");
        var slcManoObraCodigo = $("#slcManoObra option:selected").data('codigo');
        var slcResponsable = $("#slcResponsable").val();
        var slcResponsableText = (slcResponsable > 0)?($("#dvResponsable .select2-choice").text()).trim():'';
        var txtPrecio = $("#txtPrecioMob").val();
        var txtCantidad = $("#txtCantidadMob").val();
        var emp_default = $("#emp_default").html();

        if($("#decimales").val()>0){
            var decimales = $("#decimales").val();
        }else{
            var decimales = 2;
        }

        if (slcManoObra == '' || txtPrecio == '' || txtCantidad == '') {
            crear_alerta('error', 'Mano de Obra', 'Debe completar los campos necesarios.(Mano de Obra, Responsable, Precio, Cantidad).');
            return false;
        }

        if (txtCantidad <= 0) {
            crear_alerta('error', 'Mano de Obra', 'La Cantidad debe ser mayor a cero.');
            return false;
        }

        if (txtPrecio <= 0) {
            crear_alerta('error', 'Mano de Obra', 'El precio debe ser mayor a cero.');
            return false;
        }
        if ($("#trMob_" + slcManoObra + '_' + slcResponsable).length > 0) {
            crear_alerta('error', 'Mano de Obra', 'La mano de obra ya fue agregada.');
            return false;
        }

        slcManoObraHtml = slcManoObraHtml.replace(/"/g, "'");
        var html = '';

        var subTotal = (parseFloat(txtPrecio) * parseFloat(txtCantidad));

        html += '<tr id="trMob_' + slcManoObra + '_' + slcResponsable +'" class="trManoObra" data-id="' + row + '">';

        html += '<td style="width:10%">';
        html += '<input type="hidden" name="hdnDetalleMob[]" class="tables-input" value="0" />';
        html += '<input type="text" class="text tables-input select-text" value="' + slcManoObraCodigo + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:23%">';
        html += '<input type="text" class="text tables-input select-text" value="' + slcManoObraText + '" readonly="readonly"/>';
        html += '<select id="slcManoObra_' + row + '" data-id="' + row + '" name="manoObra[]" style="display:none;" class="manoObra select-edit">' + slcManoObraHtml + '</select>';
        html += '</td>';

        html += '<td style="width:23%">';
        html += '<label class="text tables-input select-text'+ row +'"">' + slcResponsableText + '</label>';
        html += '<input type="hidden" id="slcResponsable_' + row + '" name="responsanblesMob[]" class="nostyle select-edit buscarResponsable" value="' + slcResponsable + '"/>';
        html += ' <select name="empleados_edit[]" id="empleado_edit_'+ row +'" placeholder="Seleccione" class="nostyle slc_edit " >'+ emp_default +'</select>';
        html += '</td>';

        html += '<td style="width:10%">';
        html += '<input type="text" id="txtCantidadMob_' + row + '" name="cantidadesMob[]" class="text tables-input-show tables-input soloDecimales cantidadMob edit" value="' + txtCantidad + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:10%">';
        html += '<input type="text" id="txtPrecioMob_' + row + '" name="preciosMob[]" class="text tables-input-show tables-input soloDecimales precioMob edit" value="' + number_format(txtPrecio, decimales) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:10%">';
        html += '<input type="text" id="txtSubtotalMob_' + row + '" names="subtotalesMob[]" class="text tables-input-show tables-input subtotalMob" extras="." value="' + number_format(subTotal, decimales) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:10%;text-align: center;">';
        html += '<input type="checkbox" id="chkEstMob_' + row + '" data-subtotal = "txtSubtotalMob_' + row + '" class="nostyle aplicar_estimacion est_materia" />';
        html += '<input type="hidden" name="chkEstMob[]" value="0" />';
        html += '</td>';

        html += '<td style="width:14%">';
        html += '<button type="button"  class="btn btn-primary btn-mini editar_fila ManoObra" data-edit="'+row+'" style="float:left; height:30px;width:50px;"> Editar</button>';
        html += '<button type="button"  class="btn btn-primary btn-mini ManoObra guardar_fila" data-edit="'+row+'" style="float:left; height:30px; width:50px;display:none;"> Guardar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelManoObra" style="float:left;height:30px;width:50px;margin-left:5%;">Eliminar</button>';
        html += '</td>';

        html += '</tr>';


        var oTable = $('#tblManoObra').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbManoObra").append(html);
        aplicarDataTable('#tblManoObra');

        if(slcResponsable>0){ $("#empleado_edit_"+row).val(slcResponsable); }
        $("#empleado_edit_"+row).select2("destroy").hide();

        $("#txtPrecioMob").val('');
        $("#txtCantidadMob").val('');
        $("#slcManoObra option:selected").removeAttr('selected');
        $("#slcManoObra").select2({placeholder: "Seleccione una opción"});
        $("#slcResponsable").select2('data', null);
        calcularTotal("#tbManoObra .trManoObra", ".subtotalMob", "#txtTotalManoObra");
        preseleccionar_x_elementos();
    });

    //Eliminar Mano de Obra
    $(".btnDelManoObra").live("click", function () {
        var parent = $(this).parent().parent();
        var oTable = $('#tblManoObra').dataTable();
        oTable.fnDeleteRow(parent[0]);
        calcular_gastos();
        calcularTotal("#tbManoObra .trManoObra", ".subtotalMob", "#txtTotalManoObra");
    });


    //GIF
    $("#slcEstimacion").change(function(event) {
        var esm_gif = $(this).val();
        if (esm_gif != "") {
            var monto = $("#slcEstimacion option:selected").data('monto');
            var esm_tipo_calculo = $("#slcEstimacion option:selected").data('valor');
            if($.trim(esm_tipo_calculo) != ''){
                if(esm_tipo_calculo > 0){
                    //Monto
                    var etapas = $("#slcEstimacion option:selected").data('etapas');
                    if (etapas > 0) {
                        var horas = get_ctdad_hora_mob_gif(0, esm_gif);
                        horas = (horas != "") ? horas : 1;
                        $("#txtCantidadGasto").val(horas);
                    }
                    $('#txtPrecioGasto').removeAttr('readonly');
                    $('#txtCantidadGasto').removeAttr('readonly');
                } else {
                    //Porcentaje
                    $('#txtPrecioGasto').removeAttr('readonly');
                    $("#txtCantidadGasto").val(1);
                    $('#txtCantidadGasto').attr('readonly',true);
                    var campo = $("#txtPrecioGasto").val();
                    if($.trim(campo) != ''){
                        var cantidad = parseFloat($("#txtPrecioGasto").val());
                        if(cantidad > 100){
                            $("#txtPrecioGasto").val(number_format(100, decimales,'.',''));
                            crear_alerta('error', 'Alerta', 'No se permite más del 100%');
                            return false;
                        }                    
                    }
                }
            }
            var decimales = $("#decimales").val();
            $("#txtPrecioGasto").val(number_format(monto, decimales,'.',''));
        } else {
            $("#txtPrecioGasto").val("");
            $("#txtCantidadGasto").val(1);
            $('#txtCantidadGasto').attr('readonly',true);
        }
    });

    /*$("#slcEstimacion").change(function(event) {
       var monto = $("#slcEstimacion option:selected").data('monto');
       var esm_tipo_calculo = $("#slcEstimacion option:selected").data('valor');
       if(esm_tipo_calculo == 1){
            $('#txtPrecioGasto').removeAttr('readonly');
       }else{
            $('#txtPrecioGasto').attr('readonly',true);
       }
       var decimales = $("#decimales").val();
       $("#txtPrecioGasto").val(number_format(monto, decimales,'.',''));
    });*/
    $("#txtPrecioGasto").keyup(function(){
        var tipo = $("#slcEstimacion option:selected").data('valor');
        if(tipo == 0){
            var campo = $("#txtPrecioGasto").val();
            if($.trim(campo) != ''){
                var cantidad = parseFloat(campo);
                if(!(cantidad <= 100)){
                    $(this).val(100);
                    crear_alerta('error', 'Alerta', 'No se permite más del 100%');
                    return false;
                }
            }
        }
    })
    $("#txtPrecioGasto").blur(function(){
        var tipo = $("#slcEstimacion option:selected").data('valor');
        if(tipo == 0){
            var campo = $("#txtPrecioGasto").val();
            if($.trim(campo) != ''){
                var cantidad = parseFloat(campo);
                if(!(cantidad <= 100)){
                    $(this).val(100);
                    crear_alerta('error', 'Alerta', 'No se permite más del 100%');
                    return false;
                }
            }
        }
    })

    $("#btnAgregarGasto").click(function () {
        var row = 0;
        if ($('#tbGastos .trGastosInd').length > 0) {
            row = $("#tbGastos .trGastosInd:last").data('id')+1;
        }

        var slcEstimacion = $("#slcEstimacion").val();
        var slcEstimacionText = $("#slcEstimacion option:selected").text();
        var slcEstimacionHtml = getOpcionesSelect("#slcEstimacion");
        var slcEstimacionCodigo = $("#slcEstimacion option:selected").data('codigo');
        var valor_texto = $("#slcEstimacion option:selected").data('valort');
        var valor = $("#slcEstimacion option:selected").data('valor');
        var txtPrecio = $("#txtPrecioGasto").val();
        var txtCantidad = $("#txtCantidadGasto").val();
        var subtotal_gasto = parseFloat(0, 2);
        $('.aplicar_estimacion').each(function(){
            var id = $(this).attr('id');
            var subtotal_id = $(this).data('subtotal');
            var checkeado = $('#'+id+":checked").length;
            if(checkeado === 1){
                var subtotal = $('#'+subtotal_id).val().replace(/\$|\,/gi,'');//nos regresa el total de la caja de a lado del checkbox
                var correlativo = row;
                var tipo_calculo = valor;
                var valor_gasto = parseFloat(txtPrecio.replace(/\$|\,/gi,''), 2);
                if(tipo_calculo == 1){
                    //subtotal_gasto += valor_gasto;
                } else{
                    subtotal_gasto += subtotal * (valor_gasto/100);
                }
                //$('#txtSubtotalGasto_'+correlativo).val(number_format(subtotal_gasto, 2));
            }
        })
        if($("#decimales").val()>0){
            var decimales = $("#decimales").val();
        }else{
            var decimales = 2;
        }
        if (slcEstimacion == '' || txtPrecio == '' || txtCantidad == '') {
            crear_alerta('error', 'Gastos Indirectos', 'Debe completar los campos necesarios.(Estimación de gastos, Precio, Cantidad).');
            return false;
        }
        if (txtCantidad <= 0) {
            crear_alerta('error', 'Gastos Indirectos', 'La Cantidad debe ser mayor a cero.');
            return false;
        }
        if (txtPrecio <= 0) {
            crear_alerta('error', 'Gastos Indirectos', 'El precio debe ser mayor a cero.');
            return false;
        }
        if ($("#trGst_" + slcEstimacion).length > 0) {
            crear_alerta('error', 'Gastos Indirectos', 'La estimación de gasto ya fue agregada.');
            return false;
        }
        slcEstimacionHtml = slcEstimacionHtml.replace(/"/g, "'");
        var html = '';
        var subTotal = 0;
        if(valor == 1){
            subTotal = (parseFloat(txtPrecio) * parseFloat(txtCantidad));
        } else{
            subTotal = parseFloat(subtotal_gasto, 2);
        }
        //var subTotal = (parseFloat(txtPrecio) * parseFloat(txtCantidad));
        //var subTotal = parseFloat(subtotal_gasto, 2);

        html += '<tr id="trGst_' + slcEstimacion + '" class="trGastosInd" data-id="' + row + '">';

        html += '<td>';
        html += '<input type="hidden" name="hdnDetalleGst[]" class="tables-input" value="0" />';
        html += '<input type="text" class="text tables-input select-text" value="' + slcEstimacionCodigo + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + slcEstimacionText + '" readonly="readonly"/>';
        html += '<select id="slcEstimacion_' + row + '" data-id="' + row + '" name="estimacionesGasto[]" style="display:none;" class="estimacionGasto select-edit">' + slcEstimacionHtml + '</select>';
        html += '</td>';

        html += '<td>';
        //html += '<input type="text" id="txtCantidadGasto_' + row + '" name="cantidadesGasto[]" class="text tables-input-show tables-input soloNumeros cantidadGasto edit" value="' + txtCantidad + '" readonly="readonly"/>';
        html += '<input type="text" id="txtTipoCalculo_' + row + '" name="TiposCalculos[]" class="text tables-input-show tables-input otros_gastos edit" value="' + valor_texto + '" data-valor = "' + valor + '" data-correlativo = "' + row + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtCantidadGasto_' + row + '" name="cantidadesGasto[]" class="text tables-input-show tables-input soloDecimales cantidadGasto edit" value="' + number_format(txtCantidad, decimales) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtPrecioGasto_' + row + '" name="preciosGasto[]" class="text tables-input-show tables-input soloDecimales precioGasto edit" value="' + number_format(txtPrecio, decimales) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtSubtotalGasto_' + row + '" names="subtotalesGasto[]" class="text tables-input-show tables-input subtotalGasto" extras="." value="' + number_format(subTotal, decimales) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:12%">';
        //html += '<button type="button"  class="btn btn-primary btn-mini editar_fila btnEditGastoPrima" data-edit="'+row+'" style="float:left; height:30px;width:50px;"> Editar</button>';
        html += '<button type="button"  class="btn btn-primary btn-mini gastoPrima guardar_fila" data-edit="'+row+'" style="float:left; height:30px; width:50px;display:none;"> Guardar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelGasto" style="float:left;height:30px;width:50px;margin-left:5%;">Eliminar</button>';
        html += '</td>';

        html += '</tr>';


        var oTable = $('#tblGastos').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbGastos").append(html);
        aplicarDataTable('#tblGastos');

        $("#txtPrecioGasto").val('');
        //$("#txtCantidadGasto").val('');
        $("#txtCantidadGasto").val(1);
        $("#slcEstimacion option:selected").removeAttr('selected');
        $("#slcEstimacion").select2({placeholder: "Seleccione una opción"});
        calcularTotal("#tbGastos .trGastosInd", ".subtotalGasto", "#txtTotalGastos");
    });

    //Eliminar Gasto Indirectos
    $(".btnDelGasto").live("click", function () {
        var parent = $(this).parent().parent();
        var oTable = $('#tblGastos').dataTable();
        oTable.fnDeleteRow(parent[0]);
        calcularTotal("#tbGastos .trGastosInd", ".subtotalGasto", "#txtTotalGastos");
    });

    //Borrar desde aca
    $("#det_articulo").change(function () {
        art_id = $(this).val();

        $.ajax({
            url: urlj + "proyectos/procesos/data_articulo",
            type: 'POST',
            dataType: 'json',
            data: {art_id: art_id},
            success: function (data) {
                $("#codigo").html(data.dato);
                var pre = $('#precio').val();
                $('#precio_art').val(pre);
            }
        });

    });

    $("#mano_obra").change(function () {
        mob_id = $(this).val();
        $.ajax({
            url: urlj + "proyectos/procesos/data_articulo",
            type: 'POST',
            dataType: 'json',
            data: {mob_id: mob_id},
            success: function (data) {
                $("#cod_obra").html(data.dato);
            }
        });
    });

    $("#estimacion").change(function () {
        esm_id = $(this).val();
        $.ajax({
            url: urlj + "proyectos/procesos/data_articulo",
            type: 'POST',
            dataType: 'json',
            data: {esm_id: esm_id},
            success: function (data) {
                $("#cod_esm").html(data.dato);
            }
        });
    });

    $("#porcentaje").keyup(function(){
        precio_final();
        
    });

    if($("#txtTotalCostos").val()>0){
        precio_final();
    }

    $("#slcMedida").change(function(){
        var defecto = ($.trim($('#slcMedida option[data-def=1]').data('conv')) != '')?$('#slcMedida option[data-def=1]').data('conv'):0;
        var convertir = ($.trim($('#slcMedida option:selected').data('conv')) != '')?$('#slcMedida option:selected').data('conv'):0;
        var precio_temp = $("#precio_temp").val();

        var precio = ($.trim($('#txtPrecio').val()) != '')?$('#txtPrecio').val():0;

        var tipo_precio = $.trim($('#slcTipoPrecio').val());
        var indice_convercion = defecto/convertir;
        var resultado = precio_temp*convertir;
        if(tipo_precio == ""){
            resultado = 0;
        }
        $('#txtPrecio').val(resultado);
    })

    $(".aplicar_estimacion").live('click', function(){
        var id = $(this).attr('id');
        var subtotal_id = $(this).data('subtotal');
        var checkeado = $('#'+id+":checked").length;
        $(this).next().val(checkeado);
        if(checkeado === 1){
            var subtotal = $('#'+subtotal_id).val().replace(/\$|\,/gi,'');
            $('.otros_gastos').each(function(){
                var correlativo = $(this).data('correlativo');
                var tipo_calculo = $(this).data('valor');
                var subtotal_gasto = parseFloat($('#txtSubtotalGasto_'+correlativo).val().replace(/\$|\,/gi,''), 2);
                var valor_gasto = parseFloat($('#txtPrecioGasto_'+correlativo).val().replace(/\$|\,/gi,''), 2);

                if(tipo_calculo == 1){
                    subtotal_gasto += valor_gasto;
                } else{
                    subtotal_gasto += subtotal * (valor_gasto/100);
                    $('#txtSubtotalGasto_'+correlativo).val(number_format(subtotal_gasto, 2));
                }
            })
        } else{
            var subtotal = $('#'+subtotal_id).val().replace(/\$|\,/gi,'');
            $('.otros_gastos').each(function(){
                var correlativo = $(this).data('correlativo');
                var tipo_calculo = $(this).data('valor');
                var subtotal_gasto = parseFloat($('#txtSubtotalGasto_'+correlativo).val().replace(/\$|\,/gi,''), 2);
                var valor_gasto = parseFloat($('#txtPrecioGasto_'+correlativo).val().replace(/\$|\,/gi,''), 2);

                if(tipo_calculo == 1){
                    subtotal_gasto -= valor_gasto;
                } else{
                    subtotal_gasto -= subtotal * (valor_gasto/100);
                    $('#txtSubtotalGasto_'+correlativo).val(number_format(subtotal_gasto, 2));
                }
            })
        }
        calcularTotal("#tbGastos .trGastosInd", ".subtotalGasto", "#txtTotalGastos");
    })

    $("#allMat").live('click', function(){
        var checkeado = $('#allMat:checked').length;
        $(".est_materia").each(function(){
            var id_check = $(this).attr('id');
            if(checkeado == 1){
                $("#"+id_check).attr('checked','checked');
            } else{
                $("#"+id_check).removeAttr('checked');
            }
            $(this).next().val(checkeado);
        })
        calcular_gastos();
    })

    $("#allObr").live('click', function(){
        var checkeado = $('#allObr:checked').length;
        $(".est_mano").each(function(){
            var id_check = $(this).attr('id');
            if(checkeado == 1){
                $("#"+id_check).attr('checked','checked');
            } else{
                $("#"+id_check).removeAttr('checked');
            }
            $(this).next().val(checkeado);
        })
        calcular_gastos();
    })
    
    calcular_gastos();
}); // End jQuery

function calcular_gastos(){
    $('.otros_gastos').each(function(){
        var correlativo = $(this).data('correlativo');
        var tipo_calculo = $(this).data('valor');
        if(tipo_calculo != 1){
            $('#txtSubtotalGasto_'+correlativo).val(0);
        }
    })

    $('.aplicar_estimacion').each(function(){
        var id = $(this).attr('id');
        var subtotal_id = $(this).data('subtotal');
        var checkeado = $('#'+id+":checked").length;
        var dec = $("#decimales").val();
        //console.log(subtotal_id);
        if(checkeado === 1){
            var subtotal = parseFloat($('#'+subtotal_id).val().replace(/\$|\,/gi,''), dec);
            $('.otros_gastos').each(function(){
                var correlativo = $(this).data('correlativo');
                var tipo_calculo = $(this).data('valor');
                var subtotal_gasto = parseFloat($('#txtSubtotalGasto_'+correlativo).val().replace(/\$|\,/gi,''), dec);
                var valor_gasto = parseFloat($('#txtPrecioGasto_'+correlativo).val().replace(/\$|\,/gi,''), dec);

                if(tipo_calculo == 1){
                    var cantidad_est = $("#txtCantidadGasto_" + correlativo).val();
                    subtotal_gasto = cantidad_est*valor_gasto;
                } else{
                    subtotal_gasto += subtotal * (valor_gasto/100);
                }
                $('#txtSubtotalGasto_'+correlativo).val(number_format(subtotal_gasto, dec));
            })
        }
    })
    if(($("#tblMateriaPrima tr.trMateriaPrima").length > 0 || $("#tblManoObra tr.trManoObra").length > 0) && ($("#tblGastos tr.trGastosInd").length)){
        calcularTotal("#tbGastos .trGastosInd", ".subtotalGasto", "#txtTotalGastos");
    }
}

/* ===============================================================================================================
                                FIN DOCUMENT READY
=============================================================================================================== */

function getOpcionesSelect(idElemento) {
    var opciones = "";

    $(idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        //console.log($(this).attr('selected'));
        //console.log(this);
        opciones += this.outerHTML;
    });

    return opciones;
}

function obtener_precio(tipo_precio, producto, proveedor) {
    if (tipo_precio != '' && producto != '') {
        $.ajax({
            url: urlj + "proyectos/procesos/get_calculo_precio",
            type: 'POST',
            dataType: 'json',
            data: {tipo_precio: tipo_precio, producto: producto, proveedor: proveedor},
            beforeSend: function () {
                wait.start('Espere un momento... Verificando precios.');
            },
            success: function (data) {
                wait.close();
                var convertir = ($.trim($('#slcMedida option:selected').data('conv')) != '')?$.trim($('#slcMedida option:selected').data('conv')):0;
                $("#txtPrecio").val(data.precio*convertir);
                $("#precio_temp").val(data.precio);
            }
        });
    } else if(tipo_precio == ''){
        $("#txtPrecio").val(0);
        $("#precio_temp").val(0);
    }
}

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
    });
}

function calcularTotal(idTbody, selectorMontos, idTxtTotal) {
    var total = 0;
    $(idTbody).each(function () {
        var subtotal = parseFloat($(this).find(selectorMontos).val().replace(/,/g, ""));
        total += subtotal;
    });
    $(idTxtTotal).val(number_format(total, $("#decimales").val()));

    calcularTotalCostos();
}

function calcularTotalCostos() {
    var total = 0;

    var totalMateria = parseFloat($("#txtTotalMateria").val().replace(/,/g, ""));
    var totalManoObra = parseFloat($("#txtTotalManoObra").val().replace(/,/g, ""));
    var totalGastos = parseFloat($("#txtTotalGastos").val().replace(/,/g, ""));
    var cantidad_productos = $("#txtCantidadProd").val();

    total = (totalMateria + totalManoObra + totalGastos);// * cantidad_productos;

    $("#txtTotalCostos").val(number_format(total, $("#decimales").val()));
    $("#txt_total_unitario").val(number_format((total / cantidad_productos), $("#decimales").val()));

    if($("#porcentaje").val()<=0){
        $("#porcentaje").val(0.00);
    }
    precio_final();
}

function precio_final(){
    var por;
    var p;
    var t;
    var tl;
    var rp;
    var cantidad_productos = $("#txtCantidadProd").val();
    t= parseFloat($("#txtTotalCostos").val().replace(/,/g, ""));
    p= parseFloat($("#porcentaje").val().replace(/,/g, ""));
        if(p <= 0 || isNaN(p)){
            p=0;
        }
      
        if(t <=0 || isNaN(t)){
            crear_alerta('error', 'Error', 'Debe ingresar los datos correspondientes a cada detalle');
            rp=0;
        }else{  
            por=parseFloat(p);
            tl=parseFloat(t);

            var porcen = p / 100;
            var fin= porcen * t;    
            var resultado = tl + fin;
            var fint=0;
             rp= resultado.toFixed(2);
             fint = fin.toFixed(2);
        }
    
    $("#margen").val(number_format(fint, $("#decimales").val()));
    if (p == '') {
        $("#margen").val(0.00);
    };
    $("#pre_esm").val(number_format(rp, 2));      
    $("#txt_precio_unitario").val(number_format(rp/cantidad_productos, 2));  
}

function preseleccionar_x_elementos(){
    var elementos = $(".aplicar_estimacion").length;
    if (elementos > 0) {
        $(".aplicar_estimacion").each(function(){
            $(this).attr('checked','checked');
        });
    }
}

function get_ctdad_hora_mob_gif(id_mob, id_gif) {
    var valor_horas = "";
    var id_art = $('#art_id').val();
    var id_cva = $('#cva_defecto').val();
    $.ajax({
        async: false,
        type: 'post',
        dataType: 'json',
        url: urlj + 'proyectos/mantenimientos/get_suma_horas_mob_gif',
        data: {
            art: id_art,
            cva: id_cva,
            mob: id_mob,
            gif: id_gif
        },
        beforeSend: function () {
            wait.start();
        },
        success: function (data) {
            var mob_val = parseFloat(data.ctdad_mob);
            var gif_val = parseFloat(data.ctdad_gif);
            if (mob_val > 0) {
                valor_horas = mob_val;
            }else if (gif_val > 0) {
                valor_horas = gif_val;
            }
            wait.close();
        }
    });
    return valor_horas;
}