$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');

    $('select').select2({placeholder: 'Seleccione una opción'});
    //$('#slcSucursal').select2('disable');

    $(".soloNumeros").numeric();
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        timeFormat: 'hh:mm'
    });

    $('#txtHora').timepicker({timeFormat: 'H:mm:ss'});
    $('#txtHora').mask('99:99:99');
    $('#txtHora').attr('placeholder', 'ejemplo: 08:00:00');
    $('#txtHora').attr('placeholder', 'ejemplo: 16:00:00');

    (function($) {
        $.timepicker.regional['es'] = {
                timeOnlyTitle: 'Elegir una hora',
                timeText: 'Hora',
                hourText: 'Horas',
                minuteText: 'Minutos',
                secondText: 'Segundos',
                millisecText: 'Milisegundos',
                timezoneText: 'Huso horario',
                currentText: 'Ahora',
                closeText: 'Cerrar',
                timeFormat: 'hh:mm',
                amNames: ['a.m.', 'AM', 'A'],
                pmNames: ['p.m.', 'PM', 'P'],
                ampm: false
        };
        $.timepicker.setDefaults($.timepicker.regional['es']);
    });

    

    $(".ver_en_modal").fancybox({
        openEffect  : 'elastic',
        closeEffect : 'elastic',
        href: $(this).attr('href'),
        type: 'iframe',
        closeBtn : true,
        keys : {
            close  : null
        },
        helpers: {
            overlay: { closeClick: false } 
        },
        afterClose: function () {
            id_cliente = $("#id_cliente").val();
           
                $.ajax({
                    dataType: 'json',
                    type: 'POST',
                    url: urlj+'cotizaciones/cotizaciones/get_contactos_dropdown',
                    data: {cliente:id_cliente},
                    beforeSend: function () {
                        if($.trim(id_cliente) != ''){
                            wait.start();
                        }
                    },
                    success: function(data){
                        $("#slcContacto").attr("placeholder","Seleccione una opción");
                        $("#slcContacto").html(data);
                        $("#slcContacto option[value=0]").val('');
                        $("#slcContacto").select2();
                        wait.close();
                    }
                });
           
        }
    });

    $("#slcSucursal").change(function(event) {
       sucursal = $(this).val();

        $.ajax({
            url: urlj+'cotizaciones/cotizaciones/get_sucursal_info',
            type: 'POST',
            dataType: 'json',
            data: {sucursal: sucursal},
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                wait.close();   
                $("#txtDireccion").val(data);
            }
        })
       
    });

    $(".btn-close").live('click', function () {
        alerta_confirm_ajax(cerrar_modal, '', 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    var id_bod;
    var id_cat;
    var id_prod;

    $("#frm-envio").validate({
        ignore: [],
        rules: {
            txtCotizacion: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            if ($('#tbProductos .trProducto').length == 0) {
                crear_alerta('error', 'Envío Parcial', 'Debe seleccionar al menos un producto.');
                return false;
            }
            form.submit();
        }
    });


    //Calculo de la URL PATH

    $("#slcProducto").change(function () {
        var CantidadDisponible = '';
        if ($(this).val() != '') {
            CantidadDisponible = $("#slcProducto option:selected").data('disponible');
        }
        $("#txtCantidadEnvio").val(CantidadDisponible);
    });


    var row = 0;
    if ($('#tbProductos .trProducto').length > 0) {
        row = $("#tbProductos .trServicio").length;
    }
    $("#btnAgregar").click(function () {

        var txtFechaEnvio = $("#txtFechaEnvio").val();
        var txtCantidadEnvio = $("#txtCantidadEnvio").val().replace(/,/g, "");
        var slcProducto = $("#slcProducto").val();
        var slcProductoText = $("#slcProducto option:selected").data('nombre');
        var CantidadDisponible = $("#slcProducto option:selected").data('disponible');
        var slcSucursal = ($("#slcSucursal").val() != '') ? $("#slcSucursal").val() : Math.random();
        var slcSucursalTxt = $("#slcSucursal option:selected").text();

        var direccion = $("#txtDireccion").val();

        var slcContacto = $("#slcContacto").val();
        var slcContactoTxt = $("#slcContacto option:selected").text();
        var txtHora = $("#txtHora").val();

        if (txtFechaEnvio == '' || slcProducto == '' || txtCantidadEnvio == '' || txtHora == '') {
            crear_alerta('error', 'Envío Parcial', 'Debe completar todos los campos. (Producto, Fecha, Cantidad, Sucursal).');
            return false;
        }
        
        var prodSucId = slcProducto + '_' + slcSucursal;
        if (txtCantidadEnvio < 0) {
            crear_alerta('error', 'Envío Parcial', 'La cantidad debe ser mayor a cero.');
            return false;
        }

        if ($(".trProducto").attr('data-prodsuc') == prodSucId) {
            crear_alerta('error', 'Envío Parcial', 'El producto ya fue ingresado a esta sucursal.');
            return false;
        }

        txtCantidadEnvio = parseFloat(txtCantidadEnvio);
        CantidadDisponible = parseFloat(CantidadDisponible);

        if (txtCantidadEnvio > CantidadDisponible) {
            crear_alerta('error', 'Envío Parcial', 'La cantidad de envío no puede superar la cantidad pendiente (' + number_format(CantidadDisponible, 2) + ').');
            return false;
        }
        var cantidadHabilitada = (CantidadDisponible - txtCantidadEnvio);

        $("#slcProducto option:selected").data('disponible', cantidadHabilitada);
        $("#slcProducto option:selected").text(slcProductoText + " (" + number_format(cantidadHabilitada, 2) + ").");


        var slcProductoHtml = getOpcionesSelect("slcProducto");
        var slcSucursalHtml = getOpcionesSelect("slcSucursal");
        var slcContactoHtml = getOpcionesSelect("slcContacto");

        slcProductoHtml = slcProductoHtml.replace(/"/g, "'");
        slcSucursalHtml = slcSucursalHtml.replace(/"/g, "'");
        slcContactoHtml = slcContactoHtml.replace(/"/g, "'");

        var html = '';

        html += '<tr id="tr_' + row + '" class="trProducto" data-id="' + row + '" data-prodsuc="' + prodSucId + '">';

        html += '<td>';
        html += '<input type="hidden" name="hdnDetalle[]" class="tables-input" value="0" />';
        html += '<input type="text" class="text tables-input select-text" value="' + slcProductoText + '" readonly="readonly"/>';
        html += '<select id="slcProducto_' + row + '" data-id="' + row + '" name="productos[]" style="display:none;" class="slcProducto select-edit">' + slcProductoHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtFechaEnvio_' + row + '" name="fechasEnvio[]" class="text tables-input-show tables-input fechaContrato" value="' + txtFechaEnvio +'" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtHoraEnvio_' + row + '" name="horasEnvio[]" class="text tables-input-show tables-input horaContrato" value="'+ txtHora +'" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + slcSucursalTxt + '" readonly="readonly"/>';
        html += '<select id="slcSucursal_' + row + '" data-id="' + row + '" name="sucursalProducto[]" style="display:none;" class="slcSucursal select-edit">' + slcSucursalHtml + '</select>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="direccionSuc_' + row + '" data-id="' + row + '" name="direccionSuc[]" class="text tables-input-show tables-input" value="' + direccion + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtCantidadEnvio_' + row + '" name="cantidades[]" class="text tables-input-show tables-input cantidadProducto soloNumeros" extras="." value="' + txtCantidadEnvio + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="hidden" name="hdnDetalle[]" class="tables-input" value="0" />';
        html += '<input type="text" class="text tables-input select-text" value="' + slcContactoTxt + '" readonly="readonly"/>';
        html += '<select id="slcContacto_' + row + '" data-id="' + row + '" name="contactos[]" style="display:none;" class="slcContacto select-edit">' + slcContactoHtml + '</select>';
        html += '</td>';


        html += '<td>';
        html += '<button type="button" class="btn btn-primary btn-mini btnGuardarProd" style="margin-right: 5px;float: left; height: 30px; width: 50px;display: none;"><input type="hidden" value="6" id="txtest">Guardar</button>';
        html += '<button type="button" class="btn btn-primary btn-mini btnEditProd" style="margin-right: 5px;float: left; height: 30px; width: 50px; display: block;"><input type="hidden" value="6" id="txtest">Editar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelProd" style="float:left; /*margin-left:5%;*/ height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
        html += '</td>';

        html += '</tr>';

        var oTable = $('#tblProductos').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbProductos").append(html);
        aplidarDataTable('#tblProductos');

        row = row + 1;

        $("#txtFechaEnvio").val('');
        $("#txtHora").val('');
        $("#txtCantidadEnvio").val('');
        $("#txtDireccion").val('');
        $("#slcProducto option:selected").removeAttr('selected');
        $("#slcProducto").select2({placeholder: "Seleccione una opción"});
        $("#slcSucursal option:selected").removeAttr('selected');
        $("#slcSucursal").select2({placeholder: "Seleccione una opción"});
        $("#slcContacto option:selected").removeAttr('selected');
        $("#slcContacto").select2({placeholder: "Seleccione una opción"});
    });//En of function agregar

    $(".btnEditProd").live('click', function () {
        var parent = $(this).parent().parent();

        $("#" + parent[0].id + " .select-text").hide();

        $("#" + parent[0].id + " .select-edit").select2({placeholder: "Seleccione una opción"});
        $("#" + parent[0].id + " .select2-container").css('width', '100%');
        $("#" + parent[0].id + " .tables-input-show").removeClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").removeAttr('readonly');

        $("#" + parent[0].id + " .fechaContrato").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
                    //minDate: 0
        });

        $('.horaContrato').timepicker({timeFormat: 'H:mm:ss'});
        $('.horaContrato').mask('99:99:99');

        $(this).hide();
        $("#" + parent[0].id + " .btnGuardarProd").show();
    });

    //Guardar
    $(".btnGuardarProd").live('click', function () {
        var parent = $(this).parent().parent();

        var id_parent = $("#" + parent[0].id).data('id');

        var txtFechaEnvio = $("#txtFechaEnvio_" + id_parent).val();
        var txtHoraEnvio = $("#txtHoraEnvio_" + id_parent).val();
        var txtCantidadEnvio = $("#txtCantidadEnvio_" + id_parent).val();
        var slcProducto = $("#slcProducto_" + id_parent).val();
        var slcSucursal = $("#slcSucursal_" + id_parent).val();
        var slcContacto = $("#slcContacto_" + id_parent).val();
        var CantidadDisponible = $("#slcProducto_" + id_parent + " option:selected").data('disponible');

        if (txtFechaEnvio == '' || txtCantidadEnvio == '' || slcProducto == '' || slcSucursal == '' || slcContacto<=0 || txtHoraEnvio == '') {
            crear_alerta('error', 'Envío Parcial', 'Debe completar todos los campos. (Producto, Fecha, Hora, Cantidad, Sucursal y Contacto).');
            return false;
        }


        var existe = 0;
        $("#tbProductos > tr").each(function () {
            var dataId = $(this).attr('data-id');
            var slcProductosExistentes = $(this).find('.slcProducto').val();
            if (id_parent != dataId) {
                if (slcProductosExistentes == slcProducto) {
                    existe = 1;
                }
            }
        });

        if (existe > 0) {
            crear_alerta('error', 'Envío Parcial', 'El producto ya fue ingresado.');
            return false;
        }

        if (txtCantidadEnvio > CantidadDisponible) {
            crear_alerta('error', 'Envío Parcial', 'La cantidad de envío no puede superar la cantidad pendiente (' + number_format(CantidadDisponible, 2) + ').');
            return false;
        }

        $("#" + parent[0].id + " .select-edit").each(function () {
            var select_id = $(this).attr('id');
            var valor = $("#" + select_id).val();
            var text = $("#" + select_id + " option:selected").text();
            if (valor != '') {
                $("#" + select_id).prev().val(text);
            } else {
                $("#" + select_id).prev().val('');
            }
            $("#" + select_id).prev().show();
        });

        $("#" + parent[0].id + " .select-edit").select2('destroy');
        $("#" + parent[0].id + " .select-edit").hide();

        $("#" + parent[0].id + " .tables-input-show").addClass('tables-input');
        $("#" + parent[0].id + " .tables-input-show").attr('readonly', 'readonly');
        $("#" + parent[0].id + " .fechaContrato").datepicker('destroy');
        $(this).hide();
        $("#" + parent[0].id + " .btnEditProd").show();
    });


    //Eliminar Producto
    $(".btnDelProd").live("click", function () {
        var parent = $(this).parent().parent();

        var oTable = $('#tblProductos').dataTable();

        oTable.fnDeleteRow(parent[0]);
    });
});

function getOpcionesSelect(idElemento) {

    var opciones = "";

    $("#" + idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        //console.log($(this).attr('selected'));
        //console.log(this);
        opciones += this.outerHTML;
    });

    return opciones;
}

function cerrar_modal() {
    //alert('asdasd');
    jQuery.fancybox.close();
}

function aplidarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": true,
        "bInfo": false,
        "bSort": false,
        "bLengthChange": false,
        "bFilter": false
    });
}