$(document).ready(function () {
    var pathArray = window.location.pathname.split('/');
    var urlj = url_base_proyecto;
    $('select option[value="0"]').text('');
    $('select option[value="0"]').val('');

    $('select').select2({placeholder: 'Seleccione una opción'});

    //$("#txtTelefono").mask('9999-9999');

    $("#frm-base").validate({
        ignore: [],
        rules: {
            slcPersoneria: {required: true},
            slcSegmento: {required: true},
            txtEmpresa: {required: true},
            slcOrigen: {required: true},
            slcEstado: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
        },
        submitHandler: function (form) {
            form.submit();
        }
    });

    $("#slcPersoneria").change(function () {

        if ($(this).val() == 1) {
            $("#lblEmpresa").html("Nombre:<b style='color:red;'>*</b>");
        } else {
            $("#lblEmpresa").html("Empresa:<b style='color:red;'>*</b>");
        }
    });


    $("#slcNacionalidad").change(function () {
        var pais = $(this).val();
        $("#slcDepartamento option:selected").removeAttr('selected');
        $("#slcDepartamento").select2({placeholder: 'Seleccione una opción'});
        $("#slcMunicipio option:selected").removeAttr('selected');
        $("#slcMunicipio").select2({placeholder: 'Seleccione una opción'});
        $("#slcZona option:selected").removeAttr('selected');
        $("#slcZona").select2({placeholder: 'Seleccione una opción'});
        if (pais > 0) {
            $.ajax({
                url: urlj + 'cotizaciones/cotizaciones/get_departamentos_municipio',
                type: 'post',
                data: {pais: pais},
                dataType: 'json',
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    $("#slcDepartamento").html(result.departamentos);
                    $("#slcDepartamento").select2({placeholder: 'Seleccione una opción'});
                }
            });
        }
    });

    $("#slcDepartamento").change(function () {
        var departamento = $(this).val();
        $("#slcMunicipio option:selected").removeAttr('selected');
        $("#slcMunicipio").select2({placeholder: 'Seleccione una opción'});
        $("#slcZona option:selected").removeAttr('selected');
        $("#slcZona").select2({placeholder: 'Seleccione una opción'});
        if (departamento > 0) {
            $.ajax({
                url: urlj + 'cotizaciones/cotizaciones/get_departamentos_municipio',
                type: 'post',
                data: {departamento: departamento},
                dataType: 'json',
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    $("#slcMunicipio").html(result.municipios);
                    $("#slcMunicipio").select2({placeholder: 'Seleccione una opción'});
                    $("#slcZona").html(result.zonas);
                    $("#slcZona").select2({placeholder: 'Seleccione una opción'});
                }
            });
        }
    });
});
