$(document).ready(function() {
	var url = url_base_proyecto;
	aplicar_datatable("#tbl_contactos");
	aplicar_datatable("#tbl_contactos_agregar");
	$('select').select2();	
    $(".input-fecha").mask("99-99-9999");
    $(".input-fecha").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("body").on("click", "#btnFiltrar", function(e) {
    	e.preventDefault();
    	$("#tbl_contactos").DataTable().fnDestroy();
    	var segmento = $("#campana_segmento").val();
    	var origen 	 = $("#campana_origen").val();
    	var etiquetas= $("#campana_etiqueta").val();

        $.ajax({
             url: url + "cotizaciones/cotizaciones/get_contactos_db",
             type: 'POST',
             data: {segmento: segmento, origen: origen, etiquetas: etiquetas},
             dataType: 'json',
             beforeSend: function () {
                 wait.start('Cargando..');
             },
             error: function (xhr, status, error){
              exportarError(xhr.responseText);
              wait.close();
          },
              success: function (json) {

                $('#tb_detalle_contactos').html(json.html);
	            $("#div_contenedor_campana").show("slide", {
	                direction: 'left'
	            }, 400);
                
                wait.close();
          }

      	});
      	aplicar_datatable("#tbl_contactos");

    });

    var base=urlj;
    var carpeta = $('#documento_add').val();
    var ruta = urlj+'cotizaciones/cotizaciones/registrar_anexo/'+carpeta;
    new FUload('btn',ruta, {
        start:function(file){
            wait.start();
        },sucess:function(data){
            wait.close();
            if($.trim(data)!="") {
                var select = $("#doc_tipo_anexo").html();
                //obtener la extención
                //tipo 0 eliminar al guardar, 1 sin cambios, 2 nuevo anexo
                var correlativo_anexo = $("#correlativo").val();
                a_exten = $.trim(data).split('.');
                exten = "."+a_exten[(a_exten.length - 1)];
                // var carpeta_url = carpeta.replace("-", "/");
                var link_temporal = urlj+"uploads/"+ carpeta +"/"+$.trim(data);

                var extension_imagen = '';
                var ext_data = data.split('.');
                switch ($.trim(ext_data[1]).toLowerCase()) {
                	case 'docx':
                		extension_imagen = 'docx';
                		break;
                	case 'doc':
                		extension_imagen = 'doc';
                		break;
                	case 'pdf':
                		extension_imagen = 'pdf';
                		break;
                	case 'xlsx':
                		extension_imagen = 'xlsx';
                		break;
                	case 'xls':
                		extension_imagen = 'xls';
                		break;
					case 'txt':
                		extension_imagen = 'txt';
                		break;
					case 'rar':
                		extension_imagen = 'rar';
                		break;
					case 'png':
                		extension_imagen = 'png';
                		break;
					case 'jpg':
						extension_imagen = 'jpg';
						break;    
					case 'jpeg':
						extension_imagen = 'jpeg';
						break;            		
                	default:
						extension_imagen = 'txt';
                		break;                		
                }
                
                var preview="<tr id='anexo_doc_"+correlativo_anexo+"' style='display:none;' class='preview_documento'>";
                preview+="<td><a  title=\"Ver Anexo\" class='verAnexo fancybox-buttons' data-fancybox-group='button' href='"+urlj+"uploads/"+ carpeta +"/"+$.trim(data)+"'>";
                preview+="<img id='pre"+correlativo_anexo+"' src='"+(base+"media/imagenes/sistema/"+extension_imagen+".png")+"' width='88' height='88' class='imagen_documento'></a></td>";
                preview+="<td><input maxlength='50' required style='width:50%;margin-bottom:0px !important;' class='titulo_documento' type='text' name='titulo_doc' value='"+$.trim(data).replace(exten,'')+"' corr='"+correlativo_anexo+"'><span style='display:none;' id='titulo_doc"+correlativo_anexo+"'></span><br><small style='text-align:left;'>Nombre del documento</small></td>";
                
                preview+="<td style='vertical-align:middle !important; width:10% !important;text-align:center;'>";
                preview+="<span class='editar_documento icon16 icomoon-icon-pencil-5' title='Editar' corr='"+correlativo_anexo+"' title='Editar' value='titulo_doc"+correlativo_anexo+"' style='margin-right:10px;cursor:pointer''></span>";
                
                preview+="</td>";

                preview+="<input type='hidden' name='ruta' id='ruta"+correlativo_anexo+"'  value='"+$.trim(data)+"' readonly>";
                preview+="<input type='hidden' name='registro_documento'  value='0' readonly>";
                preview+="<input type='hidden' name='estado_anexo' id='estado_anexo"+correlativo_anexo+"'  value='2' readonly>";
                preview+="</tr>";
                // $(".tabla_datos").DataTable().fnDestroy();
                $("#previews").html(preview).show(300);
                //$("#awesome_form").append("<input type='hidden' name='ruta[]' id='ruta"+correlativo_anexo+"'  value='"+$.trim(data)+"' readonly></div>");
                $("#anexo_doc_"+correlativo_anexo).fadeIn(400);

                $('input[name=titulo_doc'+correlativo_anexo+']').focus();
                $(".eliminar_anexo, .verAnexo, .descargar_anexo, .editar_documento").tooltip();
                // aplicar_datatable('.tabla_datos');
                var NC = parseInt($("#correlativo").val()) + 1;
                $("#correlativo").val(NC);
                cargar_fancy();
                
            } else { //el formato es incorrecto
                crear_alerta('error','Formato Incorrecto', 'El archivo es inválido');
            }
        }
    });

    $("#edit_imagen").submit( function (event) {
        event.preventDefault();
        url = urlj+"uatm/solucions/datos_imagen_gral";
        valor_nombre = $("#nombre_i").val();
        ruta = $("#ruta").val();
        if(valor_nombre != "" && ruta!= ""){
            $.ajax({
                type: 'POST',
                url: url,
                data: $("#edit_imagen").serialize(),
                success: function(data){
                    $.fancybox(data);
                }
            });
        }else{
            if(valor_nombre ==""){
            $("#ingrese_nombre").html("<label style='color:red;'>Ingrese titulo de documento</label>");
            $("#ingrese_nombre").fadeIn(500);
            }else{
                $("#ingrese_nombre").fadeOut(500);
            }
            if(ruta ==""){
                $("#ingrese_imagen").html("<label style='color:red;'>Ingrese un documento</label>");
                $("#ingrese_imagen").fadeIn(500);
            } else{
                $("#ingrese_imagen").fadeOut(500);
            }
        }
    });

    $(".eliminar_imagen").live("click", function(event){
        event.preventDefault(); 
        var nombre = $(this).attr("custom");
        var id_key = $(this).attr("custom_id");
        var carpeta = $(this).attr("carpeta");
        var tipo = $(this).attr("tipo");
        if(tipo == 1){
            $.ajax({
                type: 'POST',
                url: urlj+'orientacion_atencion/procesos/eliminar_anexos/'+carpeta,
                data: {nombre:nombre, tipo:tipo},
                success: function(data){
                    $("#previews").dataTable().fnDestroy();
                    $("#ruta"+id_key).val("");
                    $("#anexo_doc_"+id_key).remove().delay(300);
                    aplicar_datatable('.tabla_datos');
                }
            });
        } else{
            $("#anexo_doc_"+id_key).hide();
            $("#estado_anexo"+id_key).val(0);
        }
    });

    $('.titulo_documento').live('blur',function(event) {
        var nombre = $(this).val();
        if(nombre == ''){
            crear_alerta('error','Error', 'Debe proporcionar un nombre para el documento');
            $(this).focus();
        } else if(nombre.length > 50) {
            crear_alerta('error','Error', 'El nombre no debe sobrepasar los 50 caracteres');
            $(this).focus();
        } else{
            $(this).hide();
            var ocultar = $(this).attr('corr');
            $('span[id=titulo_doc'+ocultar+']').html(nombre);
            $('span[id=titulo_doc'+ocultar+']').show();
            $(this).closest("tr").find('.editar_documento').show();
        }
    });

    $('.editar_documento').live("click", function(event) {
        var mostrar = $(this).attr('corr');

        $('span[id=titulo_doc'+mostrar+']').hide();
        $('input[corr='+mostrar+']').show();
        $('input[name='+mostrar+']').focus();
    });

    $("body").on("change", "#btnTodoContactos", function(e) {
    	e.preventDefault();
    	$("#tbl_contactos").DataTable().fnDestroy();
    	if ($(this).prop("checked")) {
    		$(".tr_contactos").each(function(e) {
    			var id = $(this).data("id");
    			$("#chbxContacto_"+id).prop("checked", true);
    		});
    	} else {
    		$(".tr_contactos").each(function(e) {
    			var id = $(this).data("id");
    			$("#chbxContacto_"+id).prop("checked", false);
    		});
    	}
    	aplicar_datatable("#tbl_contactos");
    });

    $("body").on("click", "#btnAgregarContacto", function(e) {
    	e.preventDefault();
    	$("#tbl_contactos").DataTable().fnDestroy();
    	$("#tbl_contactos_agregar").DataTable().fnDestroy();
    	var cantidad_tr = $(".tr_contactos").length;
    	if (cantidad_tr > 0) {
    		$(".tr_contactos").each(function() {
	    		var id = $(this).data(id);
	    		var contact_sel = $(this).find(".seleccionar_contacto").prop("checked");
	    		if (contact_sel) {

	    			var contador  	= parseInt($("#contacto_contador_a").val());
	    			var nombre      = $(this).find(".c_nombre_").text();
	    			var contacto_id = $(this).find(".contacto_").val();
	    			var contacto    = $(this).find(".c_contacto_").text();
	    			var segmento    = $(this).find(".c_segmento_").text();
	    			var origen      = $(this).find(".c_origen_").text();
	    			var condicion   = true;

	    			if(validar_campo_repetido((contacto_id), ".contacto_validar", "#tbl_contactos_agregar") == 1){
			            condicion = false;
			        }

			        if (condicion) {
			        	caja_conf = '<input type="hidden" class="contacto_validar" value="'+contacto_id+'">';

			            caj_nombre = '<input type="hidden" id="contacto_nombre_a'+contador+'" name="contacto_nombre_a[]" value="'+contacto_id+'">'+
			                                 '<label style="padding: 6px 4px;">'+nombre+'</label>';

			            caj_contacto = '<label style="padding: 6px 4px;">'+contacto+'</label>';

			            caj_segmento = '<label style="padding: 6px 4px;">'+segmento+'</label>';

			            caj_origen = '<label style="padding: 6px 4px;">'+origen+'</label>';

			            eliminar = '<a class="btn btn-danger minia-icon-trashcan white remover_tr action" title="Eliminar Contacto" style="margin-right: 5px;cursor:pointer;font-size:15px;">Eliminar</a>';
			            caj_acciones = eliminar;

			            $("#tb_detalle_contactos_agregar").append('<tr id="contacto_tr_a'+contador+'" class="contacto_tr_a">'+
			                '<td width="40%">'+caja_conf + caj_nombre+'</td>'+
			                '<td width="15%">'+ caj_contacto+'</td>'+
			                '<td width="15%">'+ caj_segmento+'</td>'+
			                '<td width="15%">'+ caj_origen+'</td>'+
			                '<td width="10%" style="text-align: center;">'+caj_acciones+'</td></tr>');

			            contador += 1;
			            $("#contacto_contador_a").val(contador);
			        } else {
			        	condicion = true;
			        }
	    		}
	    	});
    	} else {
    		console.log("No hay tr agregados");
    	}

        if ($("#btnTodoContactos").attr("checked")) {
            $("#btnTodoContactos").attr("checked", false);
        }

    	aplicar_datatable("#tbl_contactos");
    	aplicar_datatable("#tbl_contactos_agregar");
    });

    $("body").on('click', '.remover_tr', function(){ 
    	$("#tbl_contactos_agregar").DataTable().fnDestroy();
        var tr = $(this).closest('tr');
        tr.remove();
        aplicar_datatable("#tbl_contactos_agregar");
    });

    $(".fancybox-buttons").click(function(event){
        event.preventDefault(); 
        var url=$(this).attr('href');
        $.fancybox({
            'href': url,
            'height': '600',
            width  : '88%',
            type   :'iframe',
            closeBtn  : true
        });
    });

    $("#frm_campana").validate({
        ignore: "",
        rules: {
            'campana_estado'             : {required: true},
            'campana_observacion'        : {required: true}
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').text('Campo requerido');
        },
        submitHandler: function (form) {
            form.submit();
        }
    });

    $("body").on("click", "#btn_cancelar", function() {
        parent.jQuery.fancybox.close();
    });

    $("body").on("click", "#btn_procesar", function(e) {
        $("#frm_campana").submit();
    });

    $("body").on("click", "#btn_procesar_permiso", function(e) {
        //utilizado en acciones de personal->aprobacion de permisos
        var estado = $('#campana_estado').val();
        var coment = $('#campana_observacion').val();
        var aplica = $('#tac_id_tdc').val();
        var tpl_id = $('#campana_planilla').val();
        if (estado > 0 && coment.trim() != '') {
            if (estado == 2 && aplica > 0 && tpl_id == '') {
                crear_alerta('error','Atención', 'Debe seleccionar tipo de planilla');
                return false;
            }
            $("#frm_campana").submit();
        }else{
            crear_alerta('error','Atención', 'Complete los campos requeridos');
            return false;
        }
    });

});

function cargar_fancy(){
    $(".fancybox-buttons").click(function(event){
        event.preventDefault(); 
        var url=$(this).attr('href');
        $.fancybox({
            'href': url,
            'height': '600',
            width  : '88%',
            type   :'iframe',
            closeBtn  : true
        });
    });
}

function validar_archivos(){
    var error = 0;
    var mensaje = '';
    var regresar = false;
    $("#previews").dataTable().fnDestroy();
    if($("#previews tbody tr").length > 0){
        $("#previews tbody tr").each(function(){
            var nombre_anexo = $(this).find(".titulo_documento").val();
            var select_anexo = $(this).find(".seleccione").val();
            if($.trim(nombre_anexo) == ""){
                error = 1;
                mensaje = "Debe proporcionar un nombre para el documento";
            }
            if(nombre_anexo.length > 50 ){
                error = 1;
                mensaje = "El nombre no debe sobrepasar los 50 caracteres";
            }
            if(!(select_anexo > 0)){
                error = 1;
                mensaje = "El tipo de anexo es requerido";
            }
        })
    }
    aplicar_datatable('#previews');
    
    if(error != 0){
        crear_alerta('error','Error', mensaje);
        regresar = true;
    }
    return regresar;
}

function aplicar_datatable(id){

	$(id).dataTable({
	    "bPaginate": true,
	    "bInfo": false,
	    "bSort": false,
	    "bAutoWidth": false,
	    "bLengthChange": false,
        "bDestroy": true,
	    "bFilter": false
	});
}

function validar_campo_repetido(valor, campo, padre){
    var validar_unico = 0;
    var validacion = $(padre + ' tr input'+campo+'[value="'+valor+'"]').length;
    if(validacion != 0){
        validar_unico = 1;
    }
    return validar_unico;
}