$(document).ready(function () {

    $('#btnExport').click(function(){       
        window.location.href = window.gSateliteWhite.baseUrl('cotizaciones/cotizaciones/obtener_reporte_base_datos');
    });

    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});
    
    /*Busqueda*/
    $("#btnConsultar").click(function () {
        var personeria = $("#slcPersoneria").val();
        var actividad = $("#slcActividadEco").val();
        var etiqueta =  $("#slcEtiquetas").val();
        personeria = (personeria == null) ? '' : personeria;
        actividad = (actividad == null) ? '' : actividad;
        etiqueta = (etiqueta == null || etiqueta == 'null') ? '' : etiqueta;
        $("#dv_contenedor").hide('slide', {
            direction: 'right'
        },
        400, function () {
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('cotizaciones/cotizaciones/base_datos/1'),
                data: {personeria: personeria, actividad: actividad, etiqueta: etiqueta},
                beforeSend: function () {
                    wait.start();
                },
                success: function (result) {
                    wait.close();
                    var oTabla = $("#tblListado").dataTable();
                    $('#control').css('display','block');
                    $('#personeria').val(personeria);
                    $('#actividad').val(actividad);
                    $('#etiquetas').val(etiqueta);
                    oTabla.fnDestroy();
                    $("#tbContenedor").html(result);
                    $("#dv_contenedor").show("slide", {
                        direction: 'left'
                    }, 500);
                    aplidarDataTable('tblListado');
                }
            });
        });
    });

    //Modal de Multiselects
    $(".asociarCliente").fancybox({
        width: '50%',
        height: '50%',
        autoSize: false,
        closeClick: false,
        type: 'inline',
        beforeLoad: function () {
            //var id = $(this.element[0]).attr('data-id');
            var base_datos = $(this.element[0]).attr('data-base');
            $("#hdnBase").val(base_datos);
        },
        beforeClose: function () {
            $("#hdnBase").val('');
        }
    });

    $("#slcCliente").change(function () {
        var cliente = $(this).val();
        if (cliente > 0) {
            $("#btnNuevo").hide('500');
            $("#btnAsociar").show('500');
        } else {
            $("#btnAsociar").hide('500');
            $("#btnNuevo").show('500');
        }
    });

    $(".base_etq").live('click', function(event) {
        var base = $(this).data('base');
        $("#id_base").val(base);

        $.ajax({
            type: 'post',
            url: window.gSateliteWhite.baseUrl('cotizaciones/cotizaciones/get_etiquetas_base'),
            data: {base: base},
            beforeSend: function () {
                wait.start();
            },
            success: function (result) {
                wait.close();
                $("#slcEtiqueta").html(result);
                $("#slcEtiqueta").select2();
                
            }
        });
    });

    $("#btnEtiquetas").click(function(event){
        var base = $("#id_base").val();
        var etiqueta = $("#slcEtiqueta").val();
        $.ajax({
            type: 'post',
            url: window.gSateliteWhite.baseUrl('cotizaciones/cotizaciones/guardar_etiquetas_base'),
            data: {base: base, etiqueta: etiqueta},
            beforeSend: function () {
                wait.start();
            },
            success: function(result){
                wait.close();
                $.fancybox.close();
                if(result>0){
                    crear_alerta('success', 'Etiquetas', 'Etiquetas guardadas con éxito.');
                }else{
                    crear_alerta('error', 'Etiquetas', 'Ocurrió un error al guardar las etiquetas.');
                }
            }
        });
    });

    $(".btn-asociar").click(function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        var base = $("#hdnBase").val();
        var cliente = $("#slcCliente").val();
        wait.start();
        if (cliente > 0) {
            location.href = url + '/' + cliente + '/' + base;
        } else {
            if(base != ''){
                location.href = url + '?bd=' + base;
            }else{
                 location.href = url;
            }
            
        }
    });
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}
