$(document).ready(function () {
    var cantidad_decimales = $("#decimales").val();
    $("select option[value='0']").text('');
    $("select option[value='0']").val('');
    $("select").select2({placeholder: "Seleccione una opción"});
    $(".slc_edit").hide();
    $("#frm-presupuesto").validate({
        ignore: "",
        rules: {
            txtOrden: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $('#' + nombre + '_error').html(error);
        },
        invalidHandler: function (form, validator) {
            var errors = validator.numberOfInvalids();
            if (errors) {
                var primerElemento = validator.errorList[0].element;

                var posiciones = primerElemento.offsetTop;
                $("html, body").animate({scrollTop: posiciones}, 1000);
            }
        },
        submitHandler: function (form) {
            if ($('#tbMateriaPrima .trMateriaPrima').length == 0 && $('#tbManoObra .trManoObra').length == 0 && $('#tbGastos .trGastosInd').length == 0) {
                crear_alerta('error', 'Presupuesto', 'Ingrese al menos un registro');
                return false;
            }else{
                form.submit();
            }
        }
    });

    $("#slcMateriaPrima").change(function () {
        producto = $(this).val();
        $("#slcMedida").html('<option></option>');
        $("#slcMedida").select2({placeholder: "Seleccione una opción"});
        if (producto != '') {
            $.ajax({
                url: urlj + "proyectos/procesos/get_detalles_producto",
                type: 'POST',
                dataType: 'json',
                data: {producto: producto},
                beforeSend: function () {
                    wait.start('Espere un momento por favor... Buscando información del producto.');
                },
                success: function (data) {
                    wait.close();
                    $("#slcMedida").html(data.medidas);
                    $("#slcMedida").select2({placeholder: "Seleccione una opción"});
                    $("#hdnProducto").data('codigo', data.producto.prod_codigo);
                    $("#hdnProducto").data('nombre', data.producto.prod_nombre);
                    var tipo_precio = $("#slcTipoPrecio").val();
                    var producto = $("#slcMateriaPrima").val();
                    var proveedor = $("#slcProveedor").val();
                    obtener_precio(tipo_precio, producto, proveedor);
                }
            });
        }
    });

    $(".buscarResponsable").select2({
        placeholder: "Buscar Responsable",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'proyectos/procesos/get_empleados_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (empleado) {
                return {
                    empleado: empleado
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.empleado,
                        'text': item.emp_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });
    $(".select-edit").select2('destroy');

    $("#slcProveedor").change(function () {
        var tipo_precio = $("#slcTipoPrecio").val();
        var producto = $("#slcMateriaPrima").val();
        var proveedor = $("#slcProveedor").val();
        obtener_precio(tipo_precio, producto, proveedor);
    });

    $("#slcTipoPrecio").change(function () {
        var tipo_precio = $("#slcTipoPrecio").val();
        var producto = $("#slcMateriaPrima").val();
        var proveedor = $("#slcProveedor").val();
        obtener_precio(tipo_precio, producto, proveedor);
    });

    $("#slcManoObra").change(function () {
        var mano_obra = $(this).val();
        $("#txtPrecioMob").val('');
        if (mano_obra != '') {
            var precio = $('#' + this.id + ' option:selected').data('precio');
            $("#txtPrecioMob").val(precio);
        }
    });

    //Materia Prima
    $("#btnAgregarMateria").click(function () {
        var row = 0;
        if ($('#tbMateriaPrima .trMateriaPrima').length > 0) {
            row = $("#tbMateriaPrima .trMateriaPrima:last").data('id')+1;
        }

        var slcMateriaPrima = $("#slcMateriaPrima").val();
        var slcMateriaPrimaText = $("#hdnProducto").data('nombre');
        var slcMateriaPrimaHtml = getOpcionesSelect("#slcMateriaPrima");
        var slcMateriaCodigo = $("#hdnProducto").data('codigo');
        var slcProveedor = $("#slcProveedor").val();
        var slcProveedorText = $("#slcProveedor option:selected").text();
        var slcProveedorHtml = getOpcionesSelect("#slcProveedor");
        var slcMedida = $("#slcMedida").val();
        var slcMedidaText = $("#slcMedida option:selected").text();
        var slcMedidaHtml = getOpcionesSelect("#slcMedida");
        var txtPrecio = $("#txtPrecio").val();
        var txtCantidad = $("#txtCantidad").val();
        var slcEtapa = $("#slcEtapa").val();
        var slcEtapaText = $("#slcEtapa option:selected").text();

        if($("#decimales").val()>0){
            var decimales = $("#decimales").val();
        }else{
            var decimales = 2;
        }

        if (slcMateriaPrima == '' || txtPrecio == '' || txtCantidad == '' || slcEtapa == '') {
            crear_alerta('error', 'Materia Prima', 'Debe completar los campos necesarios.(Materia Prima, Precio, Cantidad, Etapa).');
            return false;
        }
        if (txtPrecio <= 0) {
            crear_alerta('error', 'Materia Prima', 'El precio debe ser mayor a cero.');
            return false;
        }

        if (txtCantidad <= 0) {
            crear_alerta('error', 'Materia Prima', 'La Cantidad debe ser mayor a cero.');
            return false;
        }

        if ($("#trMp_" + slcMateriaPrima).length > 0) {
            crear_alerta('error', 'Materia Prima', 'El producto ya fue ingresado.');
            return false;
        }

        slcMateriaPrimaHtml = slcMateriaPrimaHtml.replace(/"/g, "'");
        slcProveedorHtml = slcProveedorHtml.replace(/"/g, "'");
        slcMedidaHtml = slcMedidaHtml.replace(/"/g, "'");

        var html = '';

        var subTotal = (parseFloat(txtPrecio) * parseFloat(txtCantidad));

        html += '<tr id="trMp_' + slcMateriaPrima + '" class="trMateriaPrima" data-id="' + row + '">';

        html += '<td style="width:10%">';
        html += '<input type="hidden" name="hdnDetalleMateria[]" class="tables-input" value="0" />';
        html += '<input type="hidden" name="hdnEtapas[]" class="tables-input" value="'+slcEtapa+'" />' + slcEtapaText;
        //html += '<input type="text" class="text tables-input select-text" value="' + slcMateriaCodigo + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:18%">';
        html += '<input type="text" class="text tables-input select-text" value="' + slcMateriaPrimaText + '" readonly="readonly"/>';
        html += '<select id="slcMateriaPrima_' + row + '" data-id="' + row + '" name="materiaPrima[]" style="display:none;" class="materiaPrima select-edit">' + slcMateriaPrimaHtml + '</select>';
        html += '</td>';

        html += '<td style="width:10%">';
        html += '<input type="text" class="text tables-input select-text" value="' + slcMedidaText + '" readonly="readonly"/>';
        html += '<select id="slcMedida_' + row + '" data-id="' + row + '" name="conversionesMateria[]" style="display:none;" class="conversionMateria select-edit">' + slcMedidaHtml + '</select>';
        html += '</td>';

        html += '<td style="width:19%">';
        html += '<label class="text tables-input select-text">' + slcProveedorText + '</label>';
        html += '<select id="slcProveedor_' + row + '" data-id="' + row + '" name="proveedoresMateria[]" style="display:none;" class="proveedorMateria select-edit">' + slcProveedorHtml + '</select>';
        html += '</td>';

        html += '<td style="width:7%">';
        html += '<input type="text" id="txtCantidad_' + row + '" name="cantidadesMateria[]" class="text tables-input-show tables-input soloDecimales cantidadMateria edit" decimales="' + cantidad_decimales + '" value="' + txtCantidad + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:5%">';
        html += '<input type="text" id="txtPrecio_' + row + '" name="preciosMateria[]" class="text tables-input-show tables-input soloDecimales precioMateria edit" decimales="' + cantidad_decimales + '" value="' + number_format(txtPrecio, decimales) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:10%">';
        html += '<input type="text" id="txtSubtotal_' + row + '" name="subtotalesMateria[]" class="text tables-input-show tables-input subtotalMateria" extras="." value="' + number_format(subTotal, decimales) + '" readonly="readonly"/>';
        html += '</td>';

      //  html += '<td style="width:10%;text-align: center;">';
      //  html += '<input type="checkbox" id="chkEstMateria_' + row + '" data-subtotal = "txtSubtotal_' + row + '" class="nostyle aplicar_estimacion est_materia" />';
      //  html += '<input type="hidden" id="chkEstMateria' + row + '" name="chkEstMateria[]" value="0" />';
    //    html += '</td>';

        html += '<td style="width:10%">';
        html += '<button type="button"  class="btn btn-primary btn-mini editar_fila btnEditMateriaPrima" data-edit="'+row+'" style="float:left; height:30px;width:50px;"> Editar</button>';
        html += '<button type="button"  class="btn btn-primary btn-mini materiaPrima guardar_fila" data-edit="'+row+'" style="float:left; height:30px; width:50px;display:none;"> Guardar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelMateriaPrima" style="float:left; margin-left:5%; height:30px;width:50px;"><input type="hidden" value="6" id="txtest">Eliminar</button>';
        html += '</td>';

        html += '</tr>';


        var oTable = $('#tblMateriaPrima').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbMateriaPrima").append(html);
        aplicarDataTable('#tblMateriaPrima');

        $("#txtPrecio").val('');
        $("#txtCantidad").val('');
        $("#slcMateriaPrima option:selected").removeAttr('selected');
        $("#slcMateriaPrima").select2({placeholder: "Seleccione una opción"});
        $("#slcProveedor option:selected").removeAttr('selected');
        $("#slcProveedor").select2({placeholder: "Seleccione una opción"});
        $("#slcTipoPrecio option:selected").removeAttr('selected');
        $("#slcTipoPrecio").select2({placeholder: "Seleccione una opción"});

        $("#slcMedida").html('<option></option>');
        $("#slcMedida").select2({placeholder: "Seleccione una opción"});
        calcularTotal("#tbMateriaPrima .trMateriaPrima", ".subtotalMateria", "#txtTotalMateria");
    });

    //Eliminar Materia Prima
    $(".btnDelMateriaPrima").live("click", function () {
        var parent = $(this).parent().parent();
        var oTable = $('#tblMateriaPrima').dataTable();
        oTable.fnDeleteRow(parent[0]);
        calcular_gastos();
        calcularTotal("#tbMateriaPrima .trMateriaPrima", ".subtotalMateria", "#txtTotalMateria");
    });

     $(".editar_fila").live("click", function () {
        $(this).hide();
        var cont = $(this).data('edit');
        var parent = $(this).parent().parent();
        if($(this).hasClass('ManoObra')){
            $(".select-text"+cont).text('');
            $("#empleado_edit_"+cont).show();
            $("#empleado_edit_"+cont).select2({placeholder: "Seleccione una opción"});
        }

        $("#" + parent[0].id + " .edit").removeAttr('readonly');
        $("#" + parent[0].id + " .edit").removeClass('tables-input');

        $("#" + parent[0].id + " .guardar_fila").show();
    });

    //--------Boton guardar para la tabla de articulos
    $(".guardar_fila").live('click',function(event){
        var cont = $(this).data('edit');

        if($(this).hasClass('materiaPrima')){
            var cantidad = $("#txtCantidad_"+cont).val();
            var pre = $("#txtPrecio_"+cont).val();
            var precio = pre.replace(',','');
        }else if($(this).hasClass('ManoObra')){
            var cantidad = $("#txtCantidadMob_"+cont).val();
            var pre = $("#txtPrecioMob_"+cont).val();
            var precio = pre.replace(',','');
        }else{
            var cantidad = $("#txtCantidadGasto_"+cont).val();
            var pre = $("#txtPrecioGasto_"+cont).val();
            var precio = pre.replace(',','');
        }

        if(cantidad <= 0 || isNaN(cantidad)){
            crear_alerta('error','Informaci&oacute;n','Ingrese la cantidad');
        }
        else if(precio <0 || isNaN(precio)){
            crear_alerta('error','Informaci&oacute;n','El precio del producto debe ser mayor que $0.00');
        }
        else{
            var parent = $(this).parent().parent();
            var subtotal = cantidad * precio;

            $(this).hide();
            if($(this).hasClass('materiaPrima')){
                $("#txtSubtotal_"+cont).val(number_format(subtotal, $("#decimales").val()));
                $("#" + parent[0].id + " .delete_fila").val(subtotal);
                calcularTotal("#tbMateriaPrima .trMateriaPrima", ".subtotalMateria", "#txtTotalMateria");
            }else if($(this).hasClass('ManoObra')){
                $("#txtSubtotalMob_"+cont).val(number_format(subtotal, $("#decimales").val()));
                $("#" + parent[0].id + " .delete_fila").val(subtotal);

                var resp_id = $("#empleado_edit_"+cont).val();
                if(resp_id>0){
                    $("#slcResponsable_"+cont).val(resp_id);
                    var slcResponsableText = ($("#empleado_edit_"+cont+" option:selected").text()).trim();
                }else{
                     $("#slcResponsable_"+cont).val('');
                     var slcResponsableText = '-';
                }
                    $("#empleado_edit_"+cont).select2("destroy").hide();
                    $(".select-text"+cont).text(slcResponsableText);

                calcularTotal("#tbManoObra .trManoObra", ".subtotalMob", "#txtTotalManoObra");
            }else{

                $("#txtSubtotalGasto_"+cont).val(number_format(subtotal, $("#decimales").val()));
                $("#" + parent[0].id + " .delete_fila").val(subtotal);
                calcularTotal("#tbGastos .trGastosInd", ".subtotalGasto", "#txtTotalGastos");
            }

            $("#" + parent[0].id + " .edit").attr('readonly','readonly');
            $("#" + parent[0].id + " .edit").addClass('tables-input');
            $("#" + parent[0].id + " .editar_fila").show();
        }
        calcular_gastos();
    });



    //Mano de Obra
    $("#btnAgregarMob").click(function () {
        var row = 0;
        if ($('#tbManoObra .trManoObra').length > 0) {
            row = $("#tbManoObra .trManoObra:last").data('id')+1;
        }

        var slcManoObra = $("#slcManoObra").val();
        var slcManoObraText = $("#slcManoObra option:selected").text();
        var slcManoObraHtml = getOpcionesSelect("#slcManoObra");
        var slcManoObraCodigo = $("#slcManoObra option:selected").data('codigo');
        var slcResponsable = $("#slcResponsable").val();
        var txtPrecio = $("#txtPrecioMob").val();
        var txtCantidad = $("#txtCantidadMob").val();
        var emp_default = $("#emp_default").html();

        if($("#decimales").val()>0){
            var decimales = $("#decimales").val();
        }else{
            var decimales = 2;
        }

        if(slcResponsable>0){
            slcResponsableText = ($("#dvResponsable .select2-choice").text()).trim();
        }else{
            slcResponsableText = '-';
        }

        if (slcManoObra == ''  || txtPrecio == '' || txtCantidad == '') {
            crear_alerta('error', 'Mano de Obra', 'Debe completar los campos necesarios.(Mano de Obra, Precio, Cantidad).');
            return false;
        }

        if (txtCantidad <= 0) {
            crear_alerta('error', 'Mano de Obra', 'La Cantidad debe ser mayor a cero.');
            return false;
        }

        if (txtPrecio <= 0) {
            crear_alerta('error', 'Mano de Obra', 'El precio debe ser mayor a cero.');
            return false;
        }
        if ($("#trMob_" + slcManoObra + '_' + slcResponsable).length > 0) {
            crear_alerta('error', 'Mano de Obra', 'La mano de obra ya fue agregada.');
            return false;
        }

        slcManoObraHtml = slcManoObraHtml.replace(/"/g, "'");
        var html = '';

        var subTotal = (parseFloat(txtPrecio) * parseFloat(txtCantidad));

        html += '<tr id="trMob_' + slcManoObra + '_' + slcResponsable +'" class="trManoObra" data-id="' + row + '">';

        html += '<td style="width:10%">';
        html += '<input type="hidden" name="hdnDetalleMob[]" class="tables-input" value="0" />';
        html += '<input type="text" class="text tables-input select-text" value="' + slcManoObraCodigo + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:23%">';
        html += '<input type="text" class="text tables-input select-text" value="' + slcManoObraText + '" readonly="readonly"/>';
        html += '<select id="slcManoObra_' + row + '" data-id="' + row + '" name="manoObra[]" style="display:none;" class="manoObra select-edit">' + slcManoObraHtml + '</select>';
        html += '</td>';

        html += '<td style="width:23%">';
        html += '<label class="text tables-input select-text'+ row +'">' + slcResponsableText + '</label>';
        html += '<input type="hidden" id="slcResponsable_' + row + '" name="responsanblesMob[]" class="nostyle select-edit buscarResponsable" value="' + slcResponsable + '"/>';
        html += ' <select name="empleados_edit[]" id="empleado_edit_'+ row +'" placeholder="Seleccione" class="nostyle slc_edit " style="width:90%" >'+ emp_default +'</select>';
        html += '</td>';

        html += '<td style="width:10%">';
        html += '<input type="text" id="txtCantidadMob_' + row + '" name="cantidadesMob[]" class="text tables-input-show tables-input soloDecimales cantidadMob edit" decimales="' + cantidad_decimales + '" value="' + txtCantidad + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:10%">';
        html += '<input type="text" id="txtPrecioMob_' + row + '" name="preciosMob[]" class="text tables-input-show tables-input soloDecimales precioMob edit" decimales="' + cantidad_decimales + '" value="' + number_format(txtPrecio, decimales) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td style="width:10%">';
        html += '<input type="text" id="txtSubtotalMob_' + row + '" name="subtotalesMob[]" class="text tables-input-show tables-input subtotalMob" extras="." value="' + number_format(subTotal, decimales) + '" readonly="readonly"/>';
        html += '</td>';

      //  html += '<td style="width:10%;text-align: center;">';
      //  html += '<input type="checkbox" id="chkEstMob_' + row + '" data-subtotal = "txtSubtotalMob_' + row + '" class="nostyle aplicar_estimacion est_materia" />';
      //  html += '<input type="hidden" name="chkEstMob[]" value="0" />';
      //  html += '</td>';

        html += '<td style="width:14%">';
        html += '<button type="button"  class="btn btn-primary btn-mini editar_fila ManoObra" data-edit="'+row+'" style="float:left; height:30px;width:50px;"> Editar</button>';
        html += '<button type="button"  class="btn btn-primary btn-mini ManoObra guardar_fila" data-edit="'+row+'" style="float:left; height:30px; width:50px;display:none;"> Guardar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelManoObra" style="float:left;height:30px;width:50px;margin-left:5%;">Eliminar</button>';
        html += '</td>';

        html += '</tr>';


        var oTable = $('#tblManoObra').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbManoObra").append(html);
        aplicarDataTable('#tblManoObra');

        if(slcResponsable>0){ $("#empleado_edit_"+row).val(slcResponsable); }
        $("#empleado_edit_"+row).select2("destroy").hide();

        $("#txtPrecioMob").val('');
        $("#txtCantidadMob").val('');
        $("#slcManoObra option:selected").removeAttr('selected');
        $("#slcManoObra").select2({placeholder: "Seleccione una opción"});
        $("#slcResponsable").select2('data', null);
        calcularTotal("#tbManoObra .trManoObra", ".subtotalMob", "#txtTotalManoObra");
    });

    //Eliminar Mano de Obra
    $(".btnDelManoObra").live("click", function () {
        var parent = $(this).parent().parent();
        var oTable = $('#tblManoObra').dataTable();
        oTable.fnDeleteRow(parent[0]);
        calcular_gastos();
        calcularTotal("#tbManoObra .trManoObra", ".subtotalMob", "#txtTotalManoObra");
    });


    //Mano de Obra

    $("#slcEstimacion").change(function(event) {
       var monto = $("#slcEstimacion option:selected").data('monto');
       var esm_tipo_calculo = $("#slcEstimacion option:selected").data('valor');
      // if(esm_tipo_calculo == 1){
    //        $('#txtPrecioGasto').removeAttr('readonly');
            //$('#txtPrecioGasto').attr('readonly',true);
    //        $('#txtCantidadGasto').removeAttr('readonly');
  //     }else{
    //        $('#txtPrecioGasto').removeAttr('readonly');
            //$('#txtPrecioGasto').attr('readonly',true);
  //          $('#txtCantidadGasto').attr('readonly',true);
    //   }
       var decimales = $("#decimales").val();
       $("#txtPrecioGasto").val(number_format(monto, decimales,'.',''));
    });

    $("#btnAgregarGasto").click(function () {
        var row = 0;
        if ($('#tbGastos .trGastosInd').length > 0) {
            row = $("#tbGastos .trGastosInd:last").data('id')+1;
        }
        var slcEstimacion = $("#slcEstimacion").val();
        var slcEstimacionText = $("#slcEstimacion option:selected").text();
        var slcEstimacionHtml = getOpcionesSelect("#slcEstimacion");
        var slcEstimacionCodigo = $("#slcEstimacion option:selected").data('codigo');
        var valor_texto = $("#slcEstimacion option:selected").data('valort');
        var valor = $("#slcEstimacion option:selected").data('valor');
        var txtPrecio = $("#txtPrecioGasto").val();
        var txtCantidad = $("#txtCantidadGasto").val();
        var subtotal_gasto = parseFloat(0, 2);
        $('.aplicar_estimacion').each(function(){
            var id = $(this).attr('id');
            var subtotal_id = $(this).data('subtotal');
            var checkeado = $('#'+id+":checked").length;
            if(checkeado === 1){
                var subtotal = $('#'+subtotal_id).val();//nos regresa el total de la caja de a lado del checkbox
                var correlativo = row;
                var tipo_calculo = valor;
                var valor_gasto = parseFloat(txtPrecio.replace(/\$|\,/gi,''), 2);

                if(tipo_calculo == 1){
                    //subtotal_gasto += valor_gasto;
                } else{
                    subtotal_gasto += subtotal * (valor_gasto/100);
                }
                //$('#txtSubtotalGasto_'+correlativo).val(number_format(subtotal_gasto, 2));
            }
        })
        console.log(subtotal_gasto);

        if($("#decimales").val()>0){
            var decimales = $("#decimales").val();
        }else{
            var decimales = 2;
        }

        if (slcEstimacion == '' || txtPrecio == '' || txtCantidad == '') {
            crear_alerta('error', 'Gastos Indirectos', 'Debe completar los campos necesarios.(Estimación de gastos, Precio, Cantidad).');
            return false;
        }

        if (txtCantidad <= 0) {
            crear_alerta('error', 'Gastos Indirectos', 'La Cantidad debe ser mayor a cero.');
            return false;
        }

        if (txtPrecio <= 0) {
            crear_alerta('error', 'Gastos Indirectos', 'El precio debe ser mayor a cero.');
            return false;
        }
        if ($("#trGst_" + slcEstimacion).length > 0) {
            crear_alerta('error', 'Gastos Indirectos', 'La estimación de gasto ya fue agregada.');
            return false;
        }

        slcEstimacionHtml = slcEstimacionHtml.replace(/"/g, "'");
        var html = '';
        var subTotal = 0;
      //  if(valor == 1){
            subTotal = (parseFloat(txtPrecio) * parseFloat(txtCantidad));
    //    } else{
    //        subTotal = parseFloat(subtotal_gasto, 2);
  //      }

        html += '<tr id="trGst_' + slcEstimacion + '" class="trGastosInd" data-id="' + row + '">';

        html += '<td>';
        html += '<input type="hidden" name="hdnDetalleGst[]" class="tables-input" value="0" />';
        html += '<input type="text" class="text tables-input select-text" value="' + slcEstimacionCodigo + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" class="text tables-input select-text" value="' + slcEstimacionText + '" readonly="readonly"/>';
        html += '<select id="slcEstimacion_' + row + '" data-id="' + row + '" name="estimacionesGasto[]" style="display:none;" class="estimacionGasto select-edit">' + slcEstimacionHtml + '</select>';
        html += '</td>';

      //  html += '<td>';
      //  html += '<input type="text" id="txtTipoCalculo_' + row + '" name="TiposCalculos[]" class="text tables-input-show tables-input otros_gastos edit" value="' + valor_texto + '" data-valor = "' + valor + '" data-correlativo = "' + row + '" readonly="readonly"/>';
    //    html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtCantidadGasto_' + row + '" name="cantidadesGasto[]" class="text tables-input-show tables-input soloDecimales cantidadGasto edit" decimales="' + cantidad_decimales + '" value="' + txtCantidad + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtPrecioGasto_' + row + '" name="preciosGasto[]" class="text tables-input-show tables-input soloDecimales precioGasto edit" decimales="' + cantidad_decimales + '" value="' + number_format(txtPrecio, decimales) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<input type="text" id="txtSubtotalGasto_' + row + '" name="subtotalesGasto[]" class="text tables-input-show tables-input subtotalGasto" extras="." value="' + number_format(subTotal, decimales) + '" readonly="readonly"/>';
        html += '</td>';

        html += '<td>';
        html += '<button type="button"  class="btn btn-primary btn-mini editar_fila btnEditGastoPrima" data-edit="'+row+'" style="float:left; height:30px;width:50px;"> Editar</button>';
        html += '<button type="button"  class="btn btn-primary btn-mini gastoPrima guardar_fila" data-edit="'+row+'" style="float:left; height:30px; width:50px;display:none;"> Guardar</button>';
        html += '<button type="button" class="btn btn-danger btn-mini btnDelGasto" style="float:left;height:30px;width:50px;margin-left:4%;">Eliminar</button>';
        html += '</td>';

        html += '</tr>';


        var oTable = $('#tblGastos').dataTable();

        content += html;
        //Se destruye el datatable para luego volver a crearla
        oTable.fnDestroy();

        $("#tbGastos").append(html);
        aplicarDataTable('#tblGastos');

        $("#txtPrecioGasto").val('');
        $("#txtCantidadGasto").val('');
        $("#slcEstimacion option:selected").removeAttr('selected');
        $("#slcEstimacion").select2({placeholder: "Seleccione una opción"});
        calcularTotal("#tbGastos .trGastosInd", ".subtotalGasto", "#txtTotalGastos");
    });

    //Eliminar Gasto Indirectos
    $(".btnDelGasto").live("click", function () {
        var parent = $(this).parent().parent();
        var oTable = $('#tblGastos').dataTable();
        oTable.fnDeleteRow(parent[0]);
        calcularTotal("#tbGastos .trGastosInd", ".subtotalGasto", "#txtTotalGastos");
    });

    //Borrar desde aca
    $("#det_articulo").change(function () {
        art_id = $(this).val();

        $.ajax({
            url: urlj + "proyectos/procesos/data_articulo",
            type: 'POST',
            dataType: 'json',
            data: {art_id: art_id},
            success: function (data) {
                $("#codigo").html(data.dato);
                var pre = $('#precio').val();
                $('#precio_art').val(pre);
            }
        });

    });

    $("#mano_obra").change(function () {
        mob_id = $(this).val();
        $.ajax({
            url: urlj + "proyectos/procesos/data_articulo",
            type: 'POST',
            dataType: 'json',
            data: {mob_id: mob_id},
            success: function (data) {
                $("#cod_obra").html(data.dato);
            }
        });
    });

    $("#estimacion").change(function () {
        esm_id = $(this).val();
        $.ajax({
            url: urlj + "proyectos/procesos/data_articulo",
            type: 'POST',
            dataType: 'json',
            data: {esm_id: esm_id},
            success: function (data) {
                $("#cod_esm").html(data.dato);
            }
        });
    });

    $("#slcMedida").change(function(){

        var defecto = ($.trim($('#slcMedida option[data-def=1]').data('conv')) != '')?$('#slcMedida option[data-def=1]').data('conv'):0;
        var convertir = ($.trim($('#slcMedida option:selected').data('conv')) != '')?$('#slcMedida option:selected').data('conv'):0;
        var precio_temp = $("#precio_temp").val();

        var precio = ($.trim($('#txtPrecio').val()) != '')?$('#txtPrecio').val():0;

        var tipo_precio = $.trim($('#slcTipoPrecio').val());
        var indice_convercion = defecto/convertir;
        var resultado = precio_temp*convertir;
        if(tipo_precio == ""){
            resultado = 0;
        }
        $('#txtPrecio').val(resultado);
        //console.log(resultado);
    })

    $(".aplicar_estimacion").live('click', function(){
        var id = $(this).attr('id');
        var subtotal_id = $(this).data('subtotal');
        var checkeado = $('#'+id+":checked").length;
        $(this).next().val(checkeado);
        if(checkeado === 1){
            var subtotal = $('#'+subtotal_id).val();
            console.log(subtotal);
            $('.otros_gastos').each(function(){
                var correlativo = $(this).data('correlativo');
                var tipo_calculo = $(this).data('valor');
                var subtotal_gasto = parseFloat($('#txtSubtotalGasto_'+correlativo).val().replace(/\$|\,/gi,''), 2);
                var valor_gasto = parseFloat($('#txtPrecioGasto_'+correlativo).val().replace(/\$|\,/gi,''), 2);

                if(tipo_calculo == 1){
                    subtotal_gasto += valor_gasto;
                } else{
                    subtotal_gasto += subtotal * (valor_gasto/100);
                    $('#txtSubtotalGasto_'+correlativo).val(number_format(subtotal_gasto, 2));
                }

            })
        } else{
            var subtotal = $('#'+subtotal_id).val();
            $('.otros_gastos').each(function(){
                var correlativo = $(this).data('correlativo');
                var tipo_calculo = $(this).data('valor');
                var subtotal_gasto = parseFloat($('#txtSubtotalGasto_'+correlativo).val().replace(/\$|\,/gi,''), 2);
                var valor_gasto = parseFloat($('#txtPrecioGasto_'+correlativo).val().replace(/\$|\,/gi,''), 2);

                if(tipo_calculo == 1){
                    subtotal_gasto -= valor_gasto;
                } else{
                    subtotal_gasto -= subtotal * (valor_gasto/100);
                    $('#txtSubtotalGasto_'+correlativo).val(number_format(subtotal_gasto, 2));
                }
            })
        }
        calcularTotal("#tbGastos .trGastosInd", ".subtotalGasto", "#txtTotalGastos");
    })
});

function calcular_gastos(){
    $('.otros_gastos').each(function(){
        var correlativo = $(this).data('correlativo');
        if(tipo_calculo != 1){
            $('#txtSubtotalGasto_'+correlativo).val(0);
        }
    })

    $('.aplicar_estimacion').each(function(){
        var id = $(this).attr('id');
        var subtotal_id = $(this).data('subtotal');
        var checkeado = $('#'+id+":checked").length;
        if(checkeado === 1){
            var subtotal = $('#'+subtotal_id).val();
            $('.otros_gastos').each(function(){
                var correlativo = $(this).data('correlativo');
                var tipo_calculo = $(this).data('valor');
                var subtotal_gasto = parseFloat($('#txtSubtotalGasto_'+correlativo).val().replace(/\$|\,/gi,''), 2);
                var valor_gasto = parseFloat($('#txtPrecioGasto_'+correlativo).val().replace(/\$|\,/gi,''), 2);

                if(tipo_calculo == 1){
                    subtotal_gasto = valor_gasto;
                } else{
                    subtotal_gasto += subtotal * (valor_gasto/100);
                    $('#txtSubtotalGasto_'+correlativo).val(number_format(subtotal_gasto, 2));
                }

            })
        }
    })
    calcularTotal("#tbGastos .trGastosInd", ".subtotalGasto", "#txtTotalGastos");
}

/* ===============================================================================================================
                                FIN DOCUMENT READY
=============================================================================================================== */
function getOpcionesSelect(idElemento) {
    var opciones = "";

    $(idElemento + " option").each(function () {

        if (!$(this).attr('selected')) {
            $(this).removeAttr('selected');
        } else {
            $(this).attr('selected', 'selected');
        }
        //console.log($(this).attr('selected'));
        //console.log(this);
        opciones += this.outerHTML;
    });

    return opciones;
}

function obtener_precio(tipo_precio, producto, proveedor) {
    if (tipo_precio != '' && producto != '') {
        $.ajax({
            url: urlj + "proyectos/procesos/get_calculo_precio",
            type: 'POST',
            dataType: 'json',
            data: {tipo_precio: tipo_precio, producto: producto, proveedor: proveedor},
            beforeSend: function () {
                wait.start('Espere un momento... Verificando precios.');
            },
            success: function (data) {
                wait.close();
                var convertir = ($.trim($('#slcMedida option:selected').data('conv')) != '')?$.trim($('#slcMedida option:selected').data('conv')):0;
                $("#txtPrecio").val((data.precio*convertir));
                $("#precio_temp").val(data.precio);
            }
        });
    } else if(tipo_precio == ''){
        $("#txtPrecio").val(0);
        $("#precio_temp").val(0);
    }
}

function aplicarDataTable(idTabla) {
    $(idTabla).dataTable({
        "bPaginate": false,
        "bInfo": false,
        "bSort": false,
        "bFilter": false,
    });
}

function calcularTotal(idTbody, selectorMontos, idTxtTotal) {
    var total = 0;
    $(idTbody).each(function () {
        var subtotal = parseFloat($(this).find(selectorMontos).val().replace(/,/g, ""));

        total += subtotal;
    });
    $(idTxtTotal).val(number_format(total, 2));
    calcularTotalCostos();
}

function calcularTotalCostos() {
    var total = 0;

    var totalMateria = parseFloat($("#txtTotalMateria").val().replace(/,/g, ""));
    var totalManoObra = parseFloat($("#txtTotalManoObra").val().replace(/,/g, ""));
    var totalGastos = parseFloat($("#txtTotalGastos").val().replace(/,/g, ""));

    total = totalMateria + totalManoObra + totalGastos;


    $("#txtTotalCostos").val(number_format(total, 2));
}
