$(document).ready(function($) {
	var fec_pres = $("#fecha_presentacion").val().split('-');
	$('select').select2();

	suma_parte_pendiente();

	$(".datePicker").datepicker({
		minDate: new Date(fec_pres[0], (fec_pres[1] - 1), fec_pres[2]),
		showButtonPanel: true,
		changeMonth: true,
		changeYear: true,
		dateFormat: 'dd-mm-yy',
		monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
		dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
		nextText: "Siguiente",
		prevText: "Anterior",
		closeText: 'Cerrar',
		currentText: 'Hoy'
	});

	$(".datePicker").mask("99-99-9999");

	$("#frm_pagos").validate({
		ignore: [],
		submitHandler: function (form){
			wait.start();
			var nFilas = $("#contenedor tr").length;
			var emptys = $("#contenedor .dataTables_empty").length;
			if (nFilas > 0 && emptys == 0) {
				var oTable = $('#tblDocumentos').dataTable();
				oTable.fnDestroy(); 
				form.submit();
			} else {
				wait.close();
				crear_alerta('error', 'Formas de Pago', 'Debe agregar al menos un detalle.');
				return false;
			}
		}
	});

	$("#fec_pago").change(function() {
		var fecha = $(this).val();
		var desde = fec_pres[2] + "-" + fec_pres[1] + "-" + fec_pres[0];
		if (fecha != "") {
			var dias = dias_fechas(desde, fecha);
			$("#dia_pago").val(dias);
		} else {
			$("#dia_pago").val('');
		}
	});

	$("#porcent_pago").live("keyup", function() {
		var valor = $(this).val();
		if (valor != "" && valor > 0) {
			var dispo = $("#hdn_otros_porcent").val();
			var monto = $("#hdn_monto_total").val();
			if (parseFloat(valor) > parseFloat(dispo)) {
				if (parseFloat(valor) > 100) {
					crear_alerta('warning', 'Porcentaje', 'Porcentaje no puede sobre pasar el 100%');
					$("#porcent_pago").val("");
				} else{
					if (parseFloat(dispo) > 0) {
						crear_alerta('warning', 'Porcentaje', 'Solo está pendiente el '+ dispo +'%');
					} else {
						crear_alerta('warning', 'Porcentaje', 'Ya se cubrió la totalidad del pago.'); 
					}
				}
				$("#txt_este_pago").val("");
			} else {
				var calculo = round_number((parseFloat(monto) * (parseFloat(valor) / 100)), 2);
				$("#txt_este_pago").val(calculo);
			}
		} else {
			$("#txt_este_pago").val("");
		}
	});


	$("#add_pago").click(function(){
		var sugerido = $("#sugerido").val();
		var num_pago = $("#num_pago").val();
		var nom_pago = $("#nom_pago").val();
		var pct_pago = $("#porcent_pago").val();
		var val_pago = $("#txt_este_pago").val();
		var ya_pagdo = $("#hdn_monto_pagado").val();
		var ya_perct = $("#hdn_otros_porcent").val();
		var fec_pago = $("#fec_pago").val();
		var dia_pago = $("#dia_pago").val();
		var slc_entr = $("#slc_entregables").val();
		var txt_prod = "";
		var ids_prod = "";
		var txt_entr = "";
		var ids_entr = "";
		if (slc_entr != null) {
			ids_entr = slc_entr.join();
			var selected = $('#slc_entregables').select2("data");
			for (var i = 0; i < selected.length; i++) {
				txt_entr += selected[i].text;
				txt_entr += (i == (selected.length-1)) ? "" : ", ";
			}
		}
		if ($("#tr_"+ num_pago).length > 0) {
			crear_alerta('error', 'Forma de Pago', 'Ese correlativo ya ha sido registrado');
			return false;
		}
		if (num_pago != "" && nom_pago != "" && pct_pago != "" && val_pago != "" && fec_pago != "" && dia_pago != "") {
			var fila = '<tr id="tr_' + num_pago + '" >';
			fila += '<td><span>'+num_pago+'</span><input type="hidden" name="numero_pago[]" value="'+num_pago+'"><input type="hidden" name="ids_pago[]" value="0"></td>';
			fila += '<td><span>'+nom_pago+'</span><input type="hidden" name="nombre_pago[]" value="'+nom_pago+'"></td>';
			fila += '<td style="text-align: right;"><span>'+round_number(pct_pago,2)+'%</span><input type="hidden" name="percnt_pago[]" value="'+pct_pago+'" class="percent"></td>';
			fila += '<td style="text-align: right;"><span>$'+val_pago+'</span><input type="hidden" name="monto_pago[]" value="'+val_pago+'" class="pagado"></td>';
			fila += '<td><span>'+fec_pago+'</span><input type="hidden" name="fecha_pago[]" value="'+fec_pago+'"></td>';
			fila += '<td><span>'+dia_pago+'</span><input type="hidden" name="dias_pago[]" value="'+dia_pago+'"></td>';
			fila += '<td><span>'+txt_entr+'</span><input type="hidden" name="ids_entr_pago[]" value="'+ids_entr+'"></td>';
			fila += '<td><button class="btn btn-danger btn-mini borrar_fila" type="button" data-id="'+num_pago+'">Eliminar</button></td>';
			fila += '</tr>';
			var oTable = $('#tblDocumentos').dataTable();
			sugerido++;
			oTable.fnDestroy(); 
			$('#contenedor').append(fila);
			$("#nom_pago").val("");
			$("#fec_pago").val("");
			$("#dia_pago").val("");	
			$("#porcent_pago").val("");
			$("#txt_este_pago").val("");
			$("#sugerido").val(sugerido);
			$("#num_pago").val(sugerido);
			$('#slc_entregables').val(-1).trigger('change');
			suma_parte_pendiente();
			aplidarDataTable('tblDocumentos');
		} else {
			crear_alerta('error','Valores Requeridos','Favor Verificar los Campos Requeridos (<b style="color:red">*</b>)');
			return false;
		}
	});

	$(".borrar_fila").live("click", function() {
		var id = $(this).data('id');
		var oTable = $('#tblDocumentos').dataTable();
		oTable.fnDestroy(); 
		$("#tr_"+id).remove();
		suma_parte_pendiente();
		aplidarDataTable('tblDocumentos');
	});

});

function dias_fechas(fecha_ini, fecha_fin){
	var aFecha1 = fecha_ini.split('-'); 
	var aFecha2 = fecha_fin.split('-'); 
	var fFecha1 = Date.UTC(aFecha1[2],aFecha1[1]-1,aFecha1[0]); 
	var fFecha2 = Date.UTC(aFecha2[2],aFecha2[1]-1,aFecha2[0]);
	var dif = fFecha2 - fFecha1;
	var dias = Math.floor(dif / (1000 * 60 * 60 * 24)); 
	return dias;
}

function aplidarDataTable(idTabla) {
	$('#' + idTabla).dataTable({
		"sPaginationType": "full_numbers",
		"bJQueryUI": false,
		"bAutoWidth": false,
		// "iDisplayLength": 20,
		"bLengthChange": false,
		"bDestroy": true,
		"order": [[ 0, "asc" ]],
		"fnInitComplete": function (oSettings, json) {
			$('.dataTables_filter>label>input').attr('id', 'search');
		}
	});
}

function suma_parte_pendiente() {
	var pagos_ya = 0;
	var porct_ya = 0;
	$('#contenedor .pagado').each(function(index) {
		pagos_ya += parseFloat($(this).val());
	});
	$('#contenedor .percent').each(function(index) {
		porct_ya += parseFloat($(this).val());
	});
	$("#hdn_monto_pagado").val(pagos_ya);
	$("#hdn_otros_porcent").val((100 - porct_ya));
	$("#total_porcent").html(number_format(porct_ya, 2) + '%');
	$("#total_monto").html('$' + number_format(pagos_ya, 2));
}