$(document).ready(function($) {
	var fec_pres = $("#fecha_presentacion").val().split('-');

	$(".datePicker").datepicker({
		minDate: new Date(fec_pres[0], (fec_pres[1] - 1), fec_pres[2]),
		showButtonPanel: true,
		changeMonth: true,
		changeYear: true,
		dateFormat: 'dd-mm-yy',
		monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
		dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
		nextText: "Siguiente",
		prevText: "Anterior",
		closeText: 'Cerrar',
		currentText: 'Hoy'
	});

	$(".datePicker").mask("99-99-9999");

	$("#frm_entregable").validate({
		ignore: [],
		// rules: {
		// 	txt_fecha_ini: {required: true},
		// },
		submitHandler: function (form){
			wait.start();
			var nFilas = $("#contenedor tr").length;
			var emptys = $("#contenedor .dataTables_empty").length;
			if (nFilas > 0 && emptys == 0) {
				var oTable = $('#tblDocumentos').dataTable();
				oTable.fnDestroy(); 
				form.submit();
			} else {
				wait.close();
				crear_alerta('error', 'Entregables', 'Debe agregar al menos un detalle.');
				return false;
			}
		}
	});

	$("#fec_entregable").change(function() {
		var fecha = $(this).val();
		var desde = fec_pres[2] + "-" + fec_pres[1] + "-" + fec_pres[0];
		if (fecha != "") {
			var dias = dias_fechas(desde, fecha);
			$("#dia_entregable").val(dias);
		} else {
			$("#dia_entregable").val('');
		}
	}); 


	$("#add_entrega").click(function(){
		var num_ent = $("#num_entregable").val();
		var nom_ent = $("#nom_entregable").val();
		var fec_ent = $("#fec_entregable").val();
		var dia_ent = $("#dia_entregable").val();
		var descrip = $("#dsc_entregable").val();
		var sugerido = $("#sugerido").val();
		if ($("#tr_"+ num_ent).length > 0) {
			crear_alerta('error', 'Entregables', 'Ese correlativo ya ha sido registrado');
			return false;
		}
		if (num_ent != "" && nom_ent != "" && fec_ent != "" && dia_ent != "") {
			var fila = '<tr id="tr_' + num_ent + '" >';
			fila += '<td><span>'+num_ent+'</span><input type="hidden" name="numero_entregable[]" value="'+num_ent+'"><input type="hidden" name="ids_ent[]" value="0"></td>';
			fila += '<td><span>'+nom_ent+'</span><input type="hidden" name="nombre_entregable[]" value="'+nom_ent+'"></td>';
			if (descrip != "") {
				fila += '<td><textarea name="descript_entregas[]" readonly style="width: 100%;">'+descrip+'</textarea></td>';
			} else {
				fila += '<td><span></span><input type="hidden" name="descript_entregas[]" value=""></td>';
			}
			fila += '<td><span>'+dia_ent+'</span><input type="hidden" name="dias_entregable[]" value="'+dia_ent+'"></td>';
			fila += '<td><span>'+fec_ent+'</span><input type="hidden" name="fecha_entregable[]" value="'+fec_ent+'"></td>';
			fila += '<td><button class="btn btn-danger btn-mini borrar_fila" type="button" data-id="'+num_ent+'">Eliminar</button></td>';
			fila += '</tr>';
			var oTable = $('#tblDocumentos').dataTable();
			sugerido++;
			oTable.fnDestroy(); 
			$('#contenedor').append(fila);
			$("#nom_entregable").val("");
			$("#fec_entregable").val("");
			$("#dia_entregable").val("");
			$("#dsc_entregable").val("");			
			$("#sugerido").val(sugerido);
			$("#num_entregable").val(sugerido);
			aplidarDataTable('tblDocumentos');
		} else {
			crear_alerta('error','Valores Requeridos','Favor Verificar los Campos Requeridos (<b style="color:red">*</b>)');
			return false;
		}
	});

	$(".borrar_fila").live("click", function() {
		var id = $(this).data('id');
		var oTable = $('#tblDocumentos').dataTable();
		oTable.fnDestroy(); 
		$("#tr_"+id).remove();
		aplidarDataTable('tblDocumentos');
	});





});

function dias_fechas(fecha_ini, fecha_fin){
	var aFecha1 = fecha_ini.split('-'); 
	var aFecha2 = fecha_fin.split('-'); 
	var fFecha1 = Date.UTC(aFecha1[2],aFecha1[1]-1,aFecha1[0]); 
	var fFecha2 = Date.UTC(aFecha2[2],aFecha2[1]-1,aFecha2[0]);
	var dif = fFecha2 - fFecha1;
	var dias = Math.floor(dif / (1000 * 60 * 60 * 24)); 
	return dias;
}

function aplidarDataTable(idTabla) {
	$('#' + idTabla).dataTable({
		"sPaginationType": "full_numbers",
		"bJQueryUI": false,
		"bAutoWidth": false,
		// "iDisplayLength": 20,
		"bLengthChange": false,
		"bDestroy": true,
		"order": [[ 0, "asc" ]],
		"fnInitComplete": function (oSettings, json) {
			$('.dataTables_filter>label>input').attr('id', 'search');
		}
	});
}