$(document).ready(function () { 
    $(".datePicker").datepicker({
            showButtonPanel: true,
            changeMonth: true,
            changeYear: true,
            dateFormat: 'dd-mm-yy',
            monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
            dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
            nextText: "Siguiente",
            prevText: "Anterior",
            closeText: 'Cerrar',
            currentText: 'Hoy'
    });
    $(".datePicker").mask("99-99-9999");
    
    $(document).on('change', '#txtFechaIni', function() {
        validar_fecha_inicio_fin('txtFechaIni', 'txtFechaFin');
        $("#filtro_inicio").val($(this).val());
    });

    $(document).on('change', '#txtFechaFin', function() {
        validar_fecha_inicio_fin('txtFechaIni', 'txtFechaFin');
        $("#filtro_fin").val($(this).val());
    });


    $('#dependencia option[value="0"]').text('');
    $('#dependencia option[value="0"]').val('');

    $('#dependencia').select2({placeholder: 'Seleccione una opción'});
    
    //Consultar los datos
    $("#btnConsultar").click(function() {
        var fecha_inicio = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();
        var cliente = $("#slcCliente").val();
        var seguimientopor = $("#slcSeguimientoPor").val();
        var selTextselText = '';
        var contador = 0;
        
        //Asignacion de valores a los campos ocultos para pdf        
        $("#htxtFechaIni").val(fecha_inicio);
        $('#htxtFechaFin').val(fecha_fin);
        $("#hslcCliente").val(cliente);
        $("#slcCliente option:selected").each(function () {
          var $this = $(this);
          if ($this.length) {
            if(contador == 0){
              selTextselText  += $this.text();  
            }else{
              selTextselText  += ',' + $this.text();  
            }                          
          }
          contador++;
        });
        $('#hslcClientetext').val(selTextselText);


        $("#hslcSeguimientoPor").val(seguimientopor);
        $('#hslcSeguimientoPortext').val($("#slcSeguimientoPor option:selected").text());
                
        if(fecha_inicio != '' &&  fecha_fin != ''){
            $.ajax({
              dataType: 'text',
              type: 'POST',          
              url: urlj + 'cotizaciones/consultas/reporte_seguimiento_cotizaciones/1',
              data: {fecha_inicio: fecha_inicio, fecha_fin: fecha_fin, cliente: cliente, seguimientopor: seguimientopor},              
              beforeSend: function () {
                wait.start();
              },
              success: function (data) {
                //var oTable = $('#tblListado').dataTable();
                //oTable.fnDestroy();

                $("#dv_contenedor_listado").html(data);
                aplidarDataTable('tblListado');

                $("#pdf").css("display", "");
                $("#excel").css("display", "");

                //$('#cuenta').html(data.options);
                
                //$('#cuenta').select2();            
                wait.close();            
              }                       
            });
        }else{            
            crear_alerta('error', 'Campos requeridos', 'Campos con asterisco son requeridos');
        }                
    });
        
    //Aplicar estilo a los select a algunos tab de ficha general
    $("#slcSeguimientoPor, #slcCliente").select2();

    //Ajax para carga de clientes
    $("#slcSeguimientoPor").change(function() {
        var seguimientopor = $("#slcSeguimientoPor").val();                
                
        if(seguimientopor > 0 ){
          $.ajax({
            dataType: 'text',
            type: 'POST',          
            url: urlj + 'cotizaciones/consultas/get_cliente_con_seguimiento',
            data: {seguimientopor: seguimientopor},
            beforeSend: function () {
              wait.start();
            },
            success: function (data) {                
              $('#slcCliente').html(data);                              
              wait.close();            
            }                       
          });
        }else{                        
          $('#slcCliente').html('');
          $('#slcCliente').select2('destroy');
          $('#slcCliente').select2();
        }                
    });

    $("#slcDepartamento").change(function(event) {
      
      if ($(this).val() > 0 ) {
        url_ajax = window.satelite.base_url('expediente_personal/empleado/filtrar_municipio_option');
         $.ajax({
             url: url_ajax,
             type: 'POST',
             dataType: 'json',
             data: {
                 slcDepartamento: $("#slcDepartamento").val()
             },
             beforeSend: function () {
                 wait.start('Cargando municipios...');
             },
             error: function (xhr, status, error){
              exportarError(xhr.responseText);
              wait.close();
          },
          success: function (json) {
              $("#slcMunicipio").html(json.options);
              $("#slcMunicipio").select2();
              wait.close();

          }
      });
       } else {
          $("#slcMunicipio").html('<option value=""></option>');
          $("#slcMunicipio").select2();
       }

    });
    
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "aaSorting": [],
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}