$(document).ready(function () {
    $('select option[value=0]').text('');
    $('select option[value=0]').val('');
    $('select').select2({placeholder: "Seleccione una opción"});

    $("#frm-reportes").validate({
        rules: {
            txtFechaIni: {required: true},
            txtFechaFin: {required: true}
        },
        errorPlacement: function (error, element) {
            var nombre = $(element).attr("id");
            $("#" + nombre + "_error").html(error);
            crear_alerta('error', 'Campos necesarios', 'Favor ingrese los campos obligatorios');
        },
        submitHandler: function (form) {
            if (!validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val())) {
                crear_alerta('error', 'Filtros', 'Verifique el período de las fechas.');
                return false;
            }
            $("#filtro_inicio").val($("#txtFechaIni").val());
            $("#filtro_fin").val($("#txtFechaFin").val());

            var banco = ($("#slcBanco").val() > 0) ? $("#slcBanco").val() : "";
            $("#filtro_banco").val(banco);

            form.submit();
        }
    });

    $(".datePicker").mask('99-99-9999');
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    /*Busqueda*/
    $("#btnConsultar").click(function () {

        var vendedores = ($("#slcVendedor").val() > 0) ? $("#slcVendedor").val() : "";
        var fecha_ini = $("#txtFechaInicio").val();
        var fecha_fin = $("#txtFechaFin").val();


        var vendedores = $("#slcVendedor option:selected").map(function () {
                    return $(this).val();
        }).get().join();


        if (fecha_ini == '' || fecha_fin == '') {
            crear_alerta('error', 'Filtros', 'Verifique los filtros de búsqueda.');
            return false;
        }

        if (!validarPeriodo(fecha_ini, fecha_fin)) {
            crear_alerta('error', 'Filtros', 'Verifique el período de las fechas.');
            return false;
        }

        $("#dv_contenedor_listado").hide('slide', {
            direction: 'right'
        },
                400, function () {
                    $.ajax({
                        type: 'post',
                        url: window.gSateliteWhite.baseUrl('cotizaciones/consultas/reporte_proyeccion_ventas/1'),
                        data: {vendedores: vendedores, fecha_ini: fecha_ini, fecha_fin: fecha_fin},
                        beforeSend: function () {
                            wait.start();
                        },
                        success: function (result) {
                            wait.close();
                            $(".print").show();
                            var vendedores = $("#slcVendedor option:selected").map(function () {
                                return $(this).val();
                            }).get().join();
                            var fecha_ini = $("#txtFechaInicio").val();
                            var fecha_fin = $("#txtFechaFin").val();

                            $("#filtro_vendedores").val(vendedores);
                            $("#filtro_fecha_inicio").val(fecha_ini);
                            $("#filtro_fecha_fin").val(fecha_fin);

                            var oTable = $('#tblListado').dataTable();
                            oTable.fnDestroy();

                            $("#tbContenedorListado").html(result);
                            aplicarDataTable('tblListado');

                            $("#dv_contenedor_listado").show("slide", {
                                direction: 'left'
                            }, 500);

                        }
                    });
                }
        );
    });


    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type: 'iframe',
            //width:'100%',
            closeBtn: true
        });
    });
});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 20,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}