$(document).ready(function () {
    gSateliteWhite.jsSelect();
    $("#slcCliente").select2();       
    var estados= ''; 

    //Validaciones de filtros
    $("#frm-listado").validate({
        ignore:"",
        rules: {
            txtFechaIni: {required: true},
            txtFechaFin: {required: true}
        }, 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').html('Campo requerido');           
        },
        submitHandler: function(form) { 
            form.submit(); 
        }
    }); 

    //Formato en fechas
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    }); 

    //Ajax en filtros
    $("#slcCliente").change(function () {
        var cliente = $(this).val();
        //Ajax Proyectos
        if (cliente != '') {
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'cotizaciones/consultas/get_proyectos',
                data: {cliente: cliente},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    if(!($.trim(estados) != '')){
                        estados = $("#slcEstado").html();
                    }
                    $("#slcProyecto").html(data.proyectos);
                    $('#slcProyecto').select2({placeholder: "Seleccione un Proyecto"});
                    $("#slcEstado").html(data.estado);
                    $("#slcEstado").select2();
                    wait.close();                    
                }
            }); 
        }else  {            
            $("#slcProyecto").html('<option value=""></option>');
            $('#slcProyecto').select2({placeholder: "Seleccione un Proyecto"});            
            $("#slcEstado").html(estados);
            $('#slcEstado').removeAttr('disabled');
            $("#slcEstado").select2();            
        } 
    });

    //Cargar Estado segun Cliente o proyecto
    $("#slcCliente").change(function () {
        var cli = $(this).val();
        //Ajax Estado segun cliente
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'cotizaciones/consultas/get_estado_cotizaciones_cliente',
                data: {cli: cli},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                    $("#slcEstado").html(data.resp);
                }
            }); 
    });

    $("#slcProyecto").change(function () {
        var proyecto = $(this).val();
        if (proyecto!= '') {
            //Ajax Estado segun proyecto
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj + 'cotizaciones/consultas/get_estado_cotizaciones_proyecto',
                data: {proyecto: proyecto},
                beforeSend: function () {
                    wait.start();
                },
                success: function (data) {
                    wait.close();
                    $("#slcEstado").html(data.resp);
                    var posicion = $("#slcEstado").prop('value');
                    $("#slcEstado option[value='"+posicion+"']").attr("selected","selected");
                    $('#slcEstado').attr('disabled','disabled');
                    $('#slcEstado').select2();
                }
            }); 
        } else{
            $("#slcEstado").html('<option value=""></option>');
            $('#slcEstado').removeAttr('disabled');
            $('#slcEstado').select2({placeholder: "Seleccione un Estado"});
            var cli = $("#slcCliente").val();
            //Ajax Estado segun cliente
                $.ajax({
                    dataType: 'json',
                    type: 'POST',
                    url: urlj + 'cotizaciones/consultas/get_estado_cotizaciones_cliente',
                    data: {cli: cli},
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (data) {
                        wait.close();
                        $("#slcEstado").html(data.resp);
                    }
                }); 
        } 
    });

    //PDF o Excel
    $(".print").live('click',function(event){
        var tipo = $(this).val();
        
        $("#rpt_tipo").val(tipo);
        $("#frm-listado").submit();
    })
    //Validar periodo de fechas
    $("#txtFechaIni, #txtFechaFin").change(function(){
        validar_fecha_inicio_fin('txtFechaIni', 'txtFechaFin');
    })

    //Búsqueda
    $("#btnConsultar").click(function(){
        var cliente = $("#slcCliente").val();
        var proyecto = ($.trim($("#slcProyecto").val()) > 0) ? $("#slcProyecto").val() : "";
        var estado = ($.trim($("#slcEstado").val()) > 0) ? $("#slcEstado").val() : "";
        var fecha_ini = $("#txtFechaIni").val();
        var fecha_fin = $("#txtFechaFin").val();

        if(!$("#frm-listado").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            return false;
        }

        $("#dv_contenedor_reg").hide('slide',{
                direction:'right'
            },
            400,function(){
                $.ajax({
                   type:'post',
                   url:window.gSateliteWhite.baseUrl('cotizaciones/consultas/consolidado_cotizaciones_proyecto/1'),
                   data:{cliente:cliente, proyecto:proyecto, estado:estado,fecha_ini:fecha_ini, fecha_fin:fecha_fin},
                   beforeSend:function(){
                       wait.start();
                   },
                   success:function(result){
                        $('#rpt_cliente').val(cliente)
                        $('#rpt_proyecto').val(proyecto)
                        $('#rpt_estado').val(estado)
                        $("#filtro_ini").val(fecha_ini);
                        $("#filtro_fin").val(fecha_fin);


                        $('#encabezado').show();
                        $("#dv_contenedor_reg").html(result);
                        aplidarDataTable('datagried')
                        $("#control").show();
                        wait.close();
                        $(".btn-info").show(500);
                        $("#dv_contenedor_reg").show("slide", {
                           direction: 'left'
                        }, 500);
                   }
                });
            }
        );
    });    
});

    function aplidarDataTable(idTabla) {
        $('#' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 20,
            "bLengthChange": false,
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }    
    aplidarDataTable('datagried');