$(document).ready(function () {

    aplidarDataTable('datagried');

    $("#slcCliente").select2({
        placeholder: "Seleccione",
        minimumInputLength: 3,
        multiple: true,
        ajax: {
            url: urlj + 'modulo_cuentas_cobrar/procesos/get_clientes_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (cliente) {
                return {
                    cliente: cliente
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.cli_id,
                        'text': item.cli_codigo + " - " + item.nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        }
    });

    $("#btnConsultar").click(function(){
        $(".btnp, .btne").hide();
        var clientes = ($.trim($("#slcCliente").val()) != "") ? $("#slcCliente").val() : "";
        $.ajax({
            type:'post',
            dataType:'json',
            url: urlj + 'cotizaciones/consultas/lista_precio_clientes/1',
            data:{
                reporte: "",
                clientes: clientes
            },
            beforeSend:function(){
                wait.start();
            },
            success:function(result){
                $("#dv_contenedor").html(result.tabla);
                aplidarDataTable('datagried');
                if (result.registros > 0) {
                    $(".btne").show();
                    $("#clientes").val(clientes);
                    if (result.registros <= 900) {//SE PROBO CON 1000 APROX 4MIN, 8K CLIENTES SE MUERE, SOLO SE DEJA EXCEL
                        $(".btnp").show();
                    } else {
                        $(".btnp").hide();
                    }
                }
                wait.close();
            }
        });
    });
    
});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 25,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}    
    