$(document).ready(function() {
    $('#tabla').dataTable({
        "aaSorting": [[ 1, "desc" ]] //ordena desc
       // "paging":   true
      });

    $(".datePicker").datepicker({
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"]
        
    }); 

    $("#txtFecha_desde, #txtFecha_hasta").change(function(){
        validar_fecha_inicio_fin('txtFecha_desde', 'txtFecha_hasta');
    });

    $("#btnConsultar").click(function() {
        var desde = $("#txtFecha_desde").val();
        var hasta = $("#txtFecha_hasta").val();
        if (desde=="" || hasta =="") {
            crear_alerta('error','Alerta','Campos con * son requeridos.');
          //  return false;
        }else{
        $.ajax({
            type: 'post',
            url: window.satelite.base_url('cotizaciones/consultas/get_reporte_cot_personalizada'),
            dataType: 'html',
            data:{txtFecha_desde:desde,txtFecha_hasta:hasta},
            beforeSend: function () {
                wait.start();
            },
            error: function (xhr, status, error){
             //exportarError(xhr.responseText);
             wait.close();
         },
         success: function (datos) {
            var oTable = $('#tabla').dataTable();
            oTable.fnDestroy(); 

            $("#tbContenedor").html(datos);
            aplidarDataTable('tabla');
            
             wait.close();
             $("#exportar").show();
             $("#imprimir_pdf").show();
         }
        
        });
    }
    });



});

function aplidarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}