$(document).ready(function () {
    $("select").select2();
    $("#acciones").hide();


    $("#slcProducto").select2({
        placeholder: "Buscar Producto",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'cotizaciones/cotizaciones/get_productos_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto,
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.producto,
                        'text': item.codigo+' - '+item.prod_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });


    //Búsqueda
    $("#btnConsultar").click(function(){
        $('#acciones').hide();
        var producto = $("#slcProducto").val();
        if (producto > 0) {
            $.ajax({
                type:'post',
                dataType: 'json',
                url: urlj + 'cotizaciones/consultas/costeo_receta/1',
                data:{
                    producto: producto,
                    tipo_reporte: ""
                },
                beforeSend:function(){
                    wait.start();
                },
                success:function(data){
                    $('#producto').val(producto);
                    $("#dv_contenedor_reg").html(data.filas);
                    if (data.cantidad > 0) {
                        $('#acciones').show();
                    }
                    wait.close();
                }
            });
        } else {
            crear_alerta('error','Atención','El Producto es requerido');
            return false;
        }
    });    

});
