var urlj = url_base_proyecto;
$(document).ready(function () {

    $(".telefonoMask").mask('9999-9999');
    $(".soloNumeros").numeric();

    $("#telefono_contacto").mask('9999-9999');
    $("#contacto_celular").mask('9999-9999');
    $("input[name^='txtFecha']").mask('99-99-9999');
    $('select').select2({placeholder: 'Seleccione una opción'});
    $("#slcProducto").select2();

    $(".txtFechas").datepicker('destroy');
    $(".txtFechas").datepicker('destroy');
    $("input[name*='fecha'], input[name^='txtFecha']").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        //minDate: 0
    });

    $(".btn-close").live('click', function () {

        alerta_confirm_ajax(cerrar_modal, '', 'Alerta de Confirmación', 'Los datos que insertaste no han sido guardados.<br /> ¿Éstas seguro que quieres regresar a la lista?');
    });

    $("#frm-orden").validate({
        ignore: [],
        rules: {
            //slcPersoneria: {required: true},
            txtNombre: {required: true},
            txtApellido: {required: true},
            slcEjecutivo: {required:true, min:1},
            // cliente_n:{required:true},
            // slcMotivo: {required: true},
            slcPersoneria: {required: true},
            // txtMensaje: {required: true}
        },
        messages: {
            txtNombre: "Campo requerido",
            txtApellido: "Campo requerido",
            slcEjecutivo: "Campo requerido",
            slcPersoneria: "Campo requerido"
        },
        errorPlacement: function(error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }
        $("[for=txtNombre],[for=txtApellido]").css("margin-left", "17%");
        $("[for=txtNombre],[for=txtApellido]").css('margin-top', '-10px');
            wait.close();
        }
    });

    $("#cliente_n").change(function () {  
        if($("#cliente_n:checked").val()) {
            $("#slcCliente option").removeAttr('selected');
            $("#slcCliente").select2();
            $("#slcCliente").select2('disable');
            $("#slcCliente").trigger('change');
        } else {
            $("#slcCliente").select2('enable');
            $("#slcCliente").trigger('change');
            $("#txtNombre, #txtApellido").attr('readonly','readonly');//se agrega readonly si se selecciona nuevo cliente

        }
    });

    $("#slcPersoneria").change(function () {  
        if($(this).val()==1 || $(this).val()=='') { //natural
           $("#nombre_label").html(($("#nombre_label").html().replace('Nombre de la Empresa','Nombres')));
           $("#apellido_label").html(($("#apellido_label").html().replace('Razón Comercial','Apellidos')));
           $("#lbEdad").html(($("#lbEdad").html().replace('Edad de la Empresa','Edad')));
           $("#lbNacimiento").html("Fecha Nacimiento:");
           $("#txtFechaNacimiento").attr('placeholder', "Fecha Nacimiento");
           $("#txtEdad").attr('placeholder', "Fecha Nacimiento");
        } else { // Juridica
            $("#nombre_label").html(($("#nombre_label").html().replace('Nombres','Nombre de la Empresa')));
            $("#apellido_label").html(($("#apellido_label").html().replace('Apellidos','Razón Comercial')));
            $("#lbEdad").html(($("#lbEdad").html().replace('Edad','Edad de la Empresa')));
            $("#lbNacimiento").html("Fecha Creación:");
            $("#txtFechaNacimiento").attr('placeholder', "Fecha Creación");
            $("#txtEdad").attr('placeholder', "Edad de la Empresa");
        }
    });

    $(document).on('change', '#txtFechaNacimiento', function() {
        
        if ($(this).val() != '') {
            var fecha = obtenerEdad($(this).val());
            $("#txtEdad").val(fecha);
        } else {
            $("#txtEdad").val('');
        }

    });
    $(document).on('click', '.savebutton', function () {
        wait.start();
        $("#frm-orden").submit();
    });

    $("#txtNombre").keyup(function () {
        var value = $(this).val();
        if ($("#slcPersoneria").val() == 2) {
            $("#txtApellido").val(value);    
        }
    }).keyup();

    $("#slcCliente").change(function () {  
        if($(this).val()>0) { // Existe cliente
           $("#txtNombre, #txtApellido").attr('readonly',true);
           $("#txtNombre, #txtApellido").val('-');
           $("#slcPersoneria_requerido").text('');
           wait.start();
           $.ajax({
               url: urlj + 'cotizaciones/cotizaciones/get_info_cliente',
               dataType:'json',
               data: {id_cliente: $("#slcCliente").val()},
               type: "POST",
               success: function (result) {
                   wait.close();
                   $("#txtNombre").val(result.cli_nombre);
                   $("#txtApellido").val(result.cli_apellido);
                   $("#txtApellido").val(result.cli_apellido);
                   $("#correo").val(result.cli_email);
                   $("#txtDireccion").val(result.cli_direccion);
                   $("#slcMedios").html(result.medios);
                   $("#slcMedios").select2();
                   $("#telefono_contacto").val(result.tel_oficina);
                   $("#contacto_celular").val(result.tel_celular);
                   $("#txtContacto").val(result.nombre_contacto);

                   $("#slcPersoneria option").removeAttr('selected');
                   personeria = (result.cli_personeria>0)? result.cli_personeria:1;
                   $("#slcPersoneria option[value='"+personeria+"']").attr('selected',true);
                   $("#slcPersoneria").trigger('change');
                   $("#slcPersoneria").select2('disable');

                    // Vendedor
                    $("#slcEjecutivo").val(result.vendedor_cli);
                    $("#slcEjecutivo").select2();
               }
           });

           $('.quitar_requerido').text('');
        } else {
            $("#txtNombre, #txtApellido").removeAttr('readonly');
            $("#txtNombre, #txtApellido").val('');
            $("#slcPersoneria").attr('required',true);
            $("#slcPersoneria_requerido").text('*');
            $("#slcPersoneria").val('');
            $("#slcPersoneria").select2('enable');
            $('.quitar_requerido').text('*');
        }
    });


    $("#slcCategoria").change(function () {
        //$("#slcProducto").html('');
        $("#slcProducto").select2({placeholder: 'Seleccione una opción'});
        
        if ($(this).val() > 0) {
            wait.start();
            var filtro = $(this).val();

            $.ajax({
                url: urlj + 'cotizaciones/cotizaciones/get_art_x_tia',
                data: {filtro: filtro},
                type: "POST",
                success: function (result) {
                    wait.close();
                    $("#slcProducto").html(result);
                    $("#slcProducto").select2({placeholder: 'Seleccione una opción'});
                }
            });
        }
    });
    
});

/**
* @description: Retorna la edad
* @param {fecha} date
* @returns {edad}
* @fecha permitida '0000-00-00' o '0000/00/00'
*/
function obtenerEdad(fecha) {
    
    var date = new Date(fecha.replace( /(\d{2})-(\d{2})-(\d{4})/, "$2/$1/$3"))
    var today = new Date(); 
    var birthDate = new Date(date); 
    var age = today.getFullYear() - birthDate.getFullYear();
    var m = today.getMonth() - birthDate.getMonth();
    if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
        age--;
    }
    return age;
};

function cargar_categorias(tipoOrden, edicion) {

    $("#div-categorias").html('');
    $("#slcProducto").html('');
    $("#slcProducto").select2('destroy').select2();
    if (edicion == '') {
        $("#datagried tbody").html('');
    }

    if (tipoOrden) {
        tipoOrden = parseInt(tipoOrden);
        switch (tipoOrden) {
            case 1:
                $("#dvImpuestos").show();
                $("#slcMedidas").html('');
                $("#dvMedidas").show();
                $("#slcMedidas").select2();
                $("#lblProducto").html('Producto:<b class="orange">*<b/>');
                break;
            case 2:
                //$("#dvImpuestos").hide();
                $("#slcMedidas").html('');
                $("#dvMedidas").hide();
                $("#slcMedidas").select2();
                $("#lblProducto").html('Producto/Servicio:<b class="orange">*<b/>');
                break;
            case 3:
                $("#slcMedidas").html('');
                $("#slcMedidas").select2('destroy');
                $("#dvMedidas").hide();
                $("#lblProducto").html('Producto/Servicio:<b class="orange">*<b/>');
                //$("#dvImpuestos").hide();
                //$("#slcImpuestos").select2('destroy');
                //$("#slcImpuestos").html('');
                break;
        }

        $.ajax({
            dataType: 'json',
            type: 'POST',
            url: urlj + 'modulo_compras/procesos/get_categorias_productos',
            data: {tipo: tipoOrden},
            success: function (data) {
                //$("#departamento").html(data.drop);

                $("#div-categorias").html(''
                        + '<div class="span7">'
                        + '<div class="row-fluid">'
                        + '<label class="form-label span3">Categoría<b class="orange">*</b>:</label>'
                        + '<div class="span6 controls">'
                        + '<select class="dinamic" name="filtro" style="width:80%"></select>'
                        + '</div></div></div>');
                $(".dinamic").html(data.categoria);
                $('.dinamic option[value="0"]').text('');
                $('.dinamic option[value="0"]').val('');
                $('.dinamic').select2({placeholder: "Seleccione una opción"});
                producto = data.producto;
                $("#slcProducto").html(producto);
                $('#slcProducto option[value="0"]').text('');
                $('#slcProducto option[value="0"]').val('');
                $("#slcProducto").select2('destroy').select2({placeholder: "Seleccione una opción"});
            }
        });
    }
}