/**
 * Descripcion: Interaccion con el usuario en àsignacion de activo fijo
 * @author:     Alan Alvarenga.
 * @version:    0.1 2013-07-26
 * @since:      2013-07-26
 * @package:    CONAMYPE
 * @type {Object}
 * =================================================================================================
 * Nomenclatura:
 * + AGREGADO
 * - ELIMINADO
 * * ACTUALIZADO
 * -------------------------------------------------------------------------------------------------
 * Bitacora:
 * 2013-07-26 v0.1
 * + trasladoActivo.fn.getDetalles 	- 	Obtiene detalles por ID de traslado
 * + trasladoActivo.fn.setDetalles 	- 	Procesa los datos para mostrarlos en la vista del usuario
 * + trasladoActivo.fn.getModalTraslado 	- 	Carga el model con informacion detallada de un 
 * 												activo fijo
 * + trasladoActivo.ajax.getDetallesTraslado 	- 	Obtiene detalles por ID de activo fijo 
 * 													disponible para traslado
 * + trasladoActivo.ajax.getEmpleadosArea	- 	Obtiene filtro de empleados por area
 * + trasladoActivo.alerts.checkTraslado 	- 	Verifica resultado de la asignacion de activo fijo
 * + trasladoActivo.onReady 	- 	Agrega EventListeners a los elementos del DOM
 * + trasladoActivo.init 	- 	Inicializa el objeto
 * 
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 */
//Contiene todas las funciones de Traslado de Activo Fijo
var trasladoActivo = {
	//Namespace con todas las funciones de proceso de traslado de activo fijo
    fn: {
    	/**
    	 * Obtiene detalles por ID de traslado
    	 */
        getDetalles: function (event) {
            event.preventDefault();
            //Obtener ID activo disponible para traslado
            var $this = $(this);
            var id_traslado = $this.attr('data-id-traslado');
            var values = {
                id_traslado: id_traslado
            };
            //Obtener los detalles del activo fijo disponible para traslado
            trasladoActivo.ajax.getDetallesTraslado(values);
            //Fancybox Modal
			$.fancybox({
				'href': '#detalles_activo',
				'speedIn': 500,
				'speedOut': 500,
				'transitionIn':'fade',
				'transitionOut':'fade'
			});
        },
        /**
         * Procesa los datos para mostrarlos en la vista del usuario
         * @param  object detalles listado de detalles correspondientes al activo fijo
         */
        setDetalles: function(detalles){
        	//Revisar estado
        	var estado = ( parseInt( detalles.estado ) === 1 ) ? 'Activo' : 'Inactivo'; 
        	$('span.nombre').text(detalles.nombre);
        	$('span.codigo').text(detalles.codigo);
        	$('span.descripcion').text(detalles.descripcion);
        	$('span.estado').text(estado);
        	$('span.fecha').text(detalles.fecha_asignacion);
        	$('span.empleado').text(detalles.empleado);
        	$('span.area').text(detalles.area);
        	$('input[type="hidden"]').val(detalles.id);
        	
        },
        /**
         * Carga el model con informacion detallada de un activo fijo
         */
        getModalTraslado: function(event){
        	event.preventDefault();
        	//Obtener ID activo disponible para traslado
        	var $this = $(this);
            var id_traslado = $this.attr('data-id-traslado');
            var values = {
                id_traslado: id_traslado
            };
            //Obtener los detalles del activo fijo disponible para traslado
        	trasladoActivo.ajax.getDetallesTraslado( values );
        	//Fancybox Modal
        	$.fancybox({
        		'href': '#traslado_activo',
                'autoDimensions': false,
                'height': 300,
                'width': 400,
        		'speedIn': 600,
				'speedOut': 600,
				'transitionIn':'fade',
				'transitionOut':'fade'
        	});
        }
    },
    /**
     * Namespace que contiene todas las funciones que manipulan AJAX
     * @type Object
     */
    ajax: {
    	/**
    	 * Obtiene detalles por ID de activo fijo disponible para traslado
    	 * @param  object values ID del activo fijo
    	 */
        getDetallesTraslado: function (values) {
            var url = window.gSateliteWhite.baseUrl('activo/traslado/get_detalles_traslado');
            $.ajax({
                url: url,
                dataType: 'json',
                data: values,
                type: 'GET',
                success: function (data) {
                    if (data.response === true) {
                    	var detalles = data.message;
                        trasladoActivo.fn.setDetalles(detalles);
                    } else {
                        console.log('No data found!!');
                    }
                }
            });
        },
        /**
         * Obtiene filtro de empleados por area
         */
        getEmpleadosArea: function(){
        	//Inicializando variables y objetos
            //Donde se insertaran las opciones?
            var insert = 'tra_empleado';
            //Parametros para el query 
            var where = { "emp_id_are": $(this).val() }; 
            //Enviar por get
            var options = {
                    tabla: 'emp_empleado',
                    where: where,
                    insert: insert,
                    display: 'emp_nombres'
                }
            //Generar filtro para empleados por area
            window.gSateliteWhite.jsSelectFilter(options);
        }
    },
    alerts: {
        //Verifica resultado de la asignacion de activo fijo
        checkTraslado: function(){
            //Obtener el resultado de la operacion
            var result_assign = window.location.search;
            //Verificar si el resultado ha sido enviado desde el servidor
            if( typeof result_assign !== 'undefined' && result_assign !== "" ){
                //Evaluar resultado
                result_assign = parseInt( result_assign.substr(result_assign.length -1));
                if(result_assign === 1){
                    //Registro de activo exitoso
                    create("note_success", {
                        title: 'Operaci&oacute;n Completada',
                        text: 'Activo Fijo Trasladado Correctamente'
                    }, {
                        expires: false
                    });
                } else {
                    //Registro de activo fallo
                    create("note_error", {
                        title: 'Operaci&oacute;n Fallo',
                        text: 'El Activo no pudo ser trasladado, por favor intentalo de nuevo'
                    }, {
                        expires: false
                    });
                }

            }  
        }//fin checkTraslado
    },
    /**
     * Agrega EventListeners a los elementos del DOM
     */
    onReady: function () {
        $('table.data_table').dataTable({
            "sPaginationType": "full_numbers"
        });
        $('table tbody.traslado').on( 'click', 'a.detalles', trasladoActivo.fn.getDetalles );
        $('table tbody.traslado').on(' click', 'a.trasladar', trasladoActivo.fn.getModalTraslado );
		$('select[name="tra_empleado"]').select2();
		$('select[name="tra_area"]').select2();
		$('select[name="tra_area"]').on( 'change', trasladoActivo.ajax.getEmpleadosArea );
    },
    /**
     * Inicializa el objeto
     */
    init: function () {
        trasladoActivo.onReady();
        trasladoActivo.alerts.checkTraslado();
    }
};

jQuery(document).ready(function ($) {
    trasladoActivo.init();
});