$(document).ready(function () {
    $("#txtFechaIni").mask('99-99-9999');
    $("#txtFechaFin").mask('99-99-9999');
    $('select').select2();
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $("#txtFechaIni,#txtFechaFin").change(function(event) {
        validar_fecha_inicio_fin('txtFechaIni', 'txtFechaFin','La fecha de desde debe ser menor a la fecha hasta');
    });    

    //$('select option[value=0]').text('Todos');
    gSateliteWhite.jsSelect();
    window.gSateliteWhite.jsSelect();

    function aplicarDataTable(idTabla) {
        $('#' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 10,
            "bLengthChange": false,
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }
    
    //$('#datagried').dataTable({"sPaginationType": "full_numbers"});

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            txtFechaIni: {required: true},
            txtFechaFin: {required: true}
        },
        messages: {
            txtFechaIni: "Campo requerido",
            txtFechaFin: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }

        },
        submitHandler: function (form) {
           $("#contenedorTabla").hide("slide", { 
            direction: 'right'
          }, 400, function() { //despues de ocultar div enviar el ajax

              url_ajax = window.satelite.base_url('activo/reportes/filtrar_solicitud_traslados');
               $.ajax({
                   url: url_ajax,
                   type: 'POST',
                   dataType: 'json',
                   data: {
                       txtFechaIni: $("#txtFechaIni").val(),
                       txtFechaFin: $("#txtFechaFin").val(),
                   },
                   beforeSend: function () {
                       wait.start();
                   },
                   error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $("#contenedorTabla").html(json.html);
                    $("#contenedorTabla").show("slide", {
                      direction: 'left'
                    }, 500);
                    
                    $('#container-export').show();

                    let labelInformativo = json.labelInformativo;
                    if (labelInformativo != '') {
                        $('#labelInformativo').text(labelInformativo);
                    } else {
                        $('#labelInformativo').text('');
                    }

                    wait.close();

                }
            });
        });
       }
   });

    $("#reporte").validate({
        rules: {
            exportar: {required: true},
        },
        errorPlacement: function (error, element) {
            crear_alerta('error', 'Error', 'Debe filtrar la información a exportar');
        },
        submitHandler: function (form) {
            exp = $("#exportar").val();
            if (exp > 0) {
                form.submit();
            }
        }
    });

}); //End jQuery
