$(document).ready(function () {
    $("#fec_ini, #fec_fin").mask('99-99-9999');
    $('select').select2({placeholder: "Seleccione..."});
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });


    //COMPRA DE ACTIVOS
    $("#btn_compra_activo").click(function () {
        $("#acciones").hide();
        fecha_ini = $('#fec_ini').val();
        fecha_fin = $('#fec_fin').val();
        are_unity = $('#slc_are').val();
        carcterst = ($.isArray($("#slc_caract").val()) && $("#slc_caract").val() != null) ? $("#slc_caract").val().toString() : "";
        if (fecha_ini != "" && fecha_fin != "") {
            if (!verifica_fecha(fecha_ini, fecha_fin)) {
                return false;        
            }            
        }
        $.ajax({
            type: 'post',
            url: urlj + 'activo/reportes/rpt_compras_act/1',
            dataType:'json',
            data:{
                fecha_ini: fecha_ini,
                fecha_fin: fecha_fin,
                are_unity: are_unity,
                carcterst: carcterst,
                tipo_reporte: ""
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#contenedor").html(data.tabla);
                if (data.filas > 0) {
                    $('#fecha_ini').val(fecha_ini);
                    $('#fecha_fin').val(fecha_fin);
                    $('#are_unity').val(are_unity);
                    $('#carcterst').val(carcterst);
                    $("#acciones").show();
                }
                wait.close();
            }
        });
    });

    //ACTIVOS POR GRUPO
    $("#btn_activo_grupos").click(function () {
        $("#acciones").hide();
        fecha_ini = $('#fec_ini').val();
        fecha_fin = $('#fec_fin').val();
        grp_grupo = $('#slc_grp').val();
        carcterst = ($.isArray($("#slc_caract").val()) && $("#slc_caract").val() != null) ? $("#slc_caract").val().toString() : "";
        if (fecha_ini != "" && fecha_fin != "") {
            if (!verifica_fecha(fecha_ini, fecha_fin)) {
                return false;        
            }            
        }
        $.ajax({
            type: 'post',
            url: urlj + 'activo/reportes/rpt_act_grp/1',
            dataType:'json',
            data:{
                fecha_ini: fecha_ini,
                fecha_fin: fecha_fin,
                grp_grupo: grp_grupo,
                carcterst: carcterst,
                tipo_reporte: ""
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#contenedor").html(data.tabla);
                if (data.filas > 0) {
                    $('#fecha_ini').val(fecha_ini);
                    $('#fecha_fin').val(fecha_fin);
                    $('#grp_grupo').val(grp_grupo);
                    $('#carcterst').val(carcterst);
                    $("#acciones").show();
                }
                wait.close();
            }
        });
    });

    //ACTIVOS POR CUENTA DE ADQUISICION
    $("#btn_cta_compra").click(function () {
        $("#acciones").hide();
        fecha_ini = $('#fec_ini').val();
        fecha_fin = $('#fec_fin').val();
        cta_adqui = $('#slc_cta').val();
        carcterst = ($.isArray($("#slc_caract").val()) && $("#slc_caract").val() != null) ? $("#slc_caract").val().toString() : "";
        if (fecha_ini != "" && fecha_fin != "") {
            if (!verifica_fecha(fecha_ini, fecha_fin)) {
                return false;        
            }            
        }
        $.ajax({
            type: 'post',
            url: urlj + 'activo/reportes/rpt_act_cta_adq/1',
            dataType:'json',
            data:{
                fecha_ini: fecha_ini,
                fecha_fin: fecha_fin,
                cta_adqui: cta_adqui,
                carcterst: carcterst,
                tipo_reporte: ""
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#contenedor").html(data.tabla);
                if (data.filas > 0) {
                    $('#fecha_ini').val(fecha_ini);
                    $('#fecha_fin').val(fecha_fin);
                    $('#cta_adqui').val(cta_adqui);
                    $('#carcterst').val(carcterst);
                    $("#acciones").show();
                }
                wait.close();
            }
        });
    });

    //TRASLADO DE ACTIVOS POR ASIGNACION
    $("#btn_traslados_asg").click(function () {
        $("#acciones").hide();
        fecha_ini = $('#fec_ini').val();
        fecha_fin = $('#fec_fin').val();
        slc_areas = $('#slc_unidad').val();
        carcterst = ($.isArray($("#slc_caract").val()) && $("#slc_caract").val() != null) ? $("#slc_caract").val().toString() : "";
        if (fecha_ini != "" && fecha_fin != "") {
            if (!verifica_fecha(fecha_ini, fecha_fin)) {
                return false;        
            }            
        }
        $.ajax({
            type: 'post',
            url: urlj + 'activo/reportes/rpt_act_tra_asg/1',
            dataType:'json',
            data:{
                fecha_ini: fecha_ini,
                fecha_fin: fecha_fin,
                slc_areas: slc_areas,
                carcterst: carcterst,
                tipo_reporte: ""
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#contenedor").html(data.tabla);
                if (data.filas > 0) {
                    $('#fecha_ini').val(fecha_ini);
                    $('#fecha_fin').val(fecha_fin);
                    $('#slc_areas').val(slc_areas);
                    $('#carcterst').val(carcterst);
                    $("#acciones").show();
                }
                wait.close();
            }
        });
    });

    //ASIGNACION DE ACTIVOS 
    $("#btn_asign_act").click(function () {
        $("#acciones").hide();
        fecha_ini = $('#fec_ini').val();
        fecha_fin = $('#fec_fin').val();
        slc_areas = $('#slc_unidad').val();
        carcterst = ($.isArray($("#slc_caract").val()) && $("#slc_caract").val() != null) ? $("#slc_caract").val().toString() : "";
        if (fecha_ini != "" && fecha_fin != "") {
            if (!verifica_fecha(fecha_ini, fecha_fin)) {
                return false;        
            }            
        }
        $.ajax({
            type: 'post',
            url: urlj + 'activo/reportes/rpt_asign_act/1',
            dataType:'json',
            data:{
                fecha_ini: fecha_ini,
                fecha_fin: fecha_fin,
                slc_areas: slc_areas,
                carcterst: carcterst,
                tipo_reporte: ""
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#contenedor").html(data.tabla);
                if (data.filas > 0) {
                    $('#fecha_ini').val(fecha_ini);
                    $('#fecha_fin').val(fecha_fin);
                    $('#slc_areas').val(slc_areas);
                    $('#carcterst').val(carcterst);
                    $("#acciones").show();
                }
                wait.close();
            }
        });
    });

    //ACTIVOS DE BAJA
    $("#btn_act_baja").click(function () {
        $("#acciones").hide();
        fecha_ini = $('#fec_ini').val();
        fecha_fin = $('#fec_fin').val();
        moti_baja = $('#slc_motivo').val();
        carcterst = ($.isArray($("#slc_caract").val()) && $("#slc_caract").val() != null) ? $("#slc_caract").val().toString() : "";
        if (fecha_ini != "" && fecha_fin != "") {
            if (!verifica_fecha(fecha_ini, fecha_fin)) {
                return false;        
            }            
        }
        $.ajax({
            type: 'post',
            url: urlj + 'activo/reportes/rpt_act_baja/1',
            dataType:'json',
            data:{
                fecha_ini: fecha_ini,
                fecha_fin: fecha_fin,
                moti_baja: moti_baja,
                carcterst: carcterst,
                tipo_reporte: ""
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#contenedor").html(data.tabla);
                if (data.filas > 0) {
                    $('#fecha_ini').val(fecha_ini);
                    $('#fecha_fin').val(fecha_fin);
                    $('#moti_baja').val(moti_baja);
                    $('#carcterst').val(carcterst);
                    $("#acciones").show();
                }
                wait.close();
            }
        });
    });

    //REPORTE POR TIPO DE ACTIVO
    $("#btn_tipo_activo").click(function () {
        $("#acciones").hide();
        fecha_ini = $('#fec_ini').val();
        fecha_fin = $('#fec_fin').val();
        tipo_acti = $('#slc_tipo').val();
        carcterst = ($.isArray($("#slc_caract").val()) && $("#slc_caract").val() != null) ? $("#slc_caract").val().toString() : "";
        if (fecha_ini != "" && fecha_fin != "") {
            if (!verifica_fecha(fecha_ini, fecha_fin)) {
                return false;        
            }            
        }
        $.ajax({
            type: 'post',
            url: urlj + 'activo/reportes/rpt_act_tipo/1',
            dataType:'json',
            data:{
                fecha_ini: fecha_ini,
                fecha_fin: fecha_fin,
                tipo_acti: tipo_acti,
                carcterst: carcterst,
                tipo_reporte: ""
            },
            beforeSend: function () {
                wait.start();
            },
            success: function (data) {
                $("#contenedor").html(data.tabla);
                if (data.filas > 0) {
                    $('#fecha_ini').val(fecha_ini);
                    $('#fecha_fin').val(fecha_fin);
                    $('#tipo_acti').val(tipo_acti);
                    $('#carcterst').val(carcterst);
                    $("#acciones").show();
                }
                wait.close();
            }
        });
    });

    
    $('body').on('change', '#fec_ini, #fec_fin', function(){
        if ($("#fec_ini").val() != "" && $("#fec_ini").val() != "") {
            verifica_fecha($("#fec_ini").val(), $("#fec_fin").val());
        }
    });

}); //End jQuery

function verifica_fecha(fecha_ini, fecha_fin) {
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if (Date.parse(fecha_i) > Date.parse(fecha_f)) {
        crear_alerta('error','Fechas','Verifique las fechas del período');
        return false;
    }else{
        return true;
    }
}