$(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $("select option[value=0]").val('');
    
      $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").attr('placeholder', "dd-mm-yyyy");
    $("input[name^='fecha']").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        //minDate: 0
    });

    $("#consultar").click(function(event) {
        event.preventDefault();

        fecha_ini=$("#fecha_ini").val();
        fecha_fin=$("#fecha_fin").val();

        if(fecha_ini!='' || fecha_fin!=''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
             crear_alerta('error', 'Error', 'Verifique las fechas de periodo'); 
            return false;
            }
        }
        wait.start();
        $("#contenedor_index").hide("slide", {
            direction: 'right'
        }, 400, function () { //despues de ocultar div enviar el ajax
            $.ajax({
                type: 'post',
                url: window.gSateliteWhite.baseUrl('activo/nuevo/listado_asignacion'),
                data: $("#frm_filtros").serialize(),
                success: function (data) {
                    var oTable = $('#tabla').dataTable();
                    oTable.fnDestroy();
                    $("#contenedor_index").html(data);
                    $('#tabla').dataTable({
                        'iDisplayLength': 20,
                        "aLengthMenu": [[20, 40, 60, 80, 100], [20, 40, 60, 80, 100]],
                        'oLanguage': {
                            'sLengthMenu': 'Mostrando _MENU_ entradas'
                        }
                    });
                    $('#tabla').css('width', '100%');
                    $("#tabla_length").css('width', '25%');
                    $("select[name='tabla_length']").css('width','25%');
                    wait.close();
                   
                    $("#contenedor_index").show("slide", {
                        direction: 'left'
                    }, 300);
                    $("#exportar").val(1);
                }
            });
        });
    });

}); // End jQuery

function verifica_fecha(fecha_ini, fecha_fin){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
            $("#fecha_fin_error").text('Verifique las fechas del periodo');
            $("#fecha_fin").removeClass('valid');
            $("#fecha_fin").addClass('error');
          return false;
      }

      if(Date.parse(fecha_i) < Date.parse(fecha_f)){
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin").addClass('valid');
        $("#fecha_fin_error").text('');
        return true;
      }
  }