$(document).ready(function () {
    $("#txtFechaIni").mask('99-99-9999');
    $("#txtFechaFin").mask('99-99-9999');
    $('select').select2();
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    //$('select option[value=0]').text('Todos');
    gSateliteWhite.jsSelect();
    window.gSateliteWhite.jsSelect();

    $(document).on('change', '#slcSucursales',function(){
        var suc = $(this,'option:selected').val();
        if (suc != '') {
            $.ajax({
                type : 'post',
                url  :  urlj+'activo/nuevo/get_deptos',
                data : {suc:suc},
                dataType : 'json',
                beforeSend:function(){
                    wait.start();
                },
                success:function(data){
                    wait.close();
                    $('#slcDepartamento').html(data.options);
                }
            });
        }
    });

    function aplicarDataTable(idTabla) {
        $('#' + idTabla).dataTable({
            "sPaginationType": "full_numbers",
            "bJQueryUI": false,
            "bAutoWidth": false,
            "iDisplayLength": 10,
            "bLengthChange": false,
            "bDestroy": true,
            "fnInitComplete": function (oSettings, json) {
                $('.dataTables_filter>label>input').attr('id', 'search');
            }
        });
    }
    
    //$('#datagried').dataTable({"sPaginationType": "full_numbers"});

    $("#consultar").click(function () {
        prov       = $('#slcProveedor option:selected').val();
        tipoActivo = $('#slcTipoActivo option:selected').val();
        sucursal   = $('#slcSucursales option:selected').val();
        tipo_adq   = $('#slcAdquisicion option:selected').val();
        depto      = $('#slcDepartamento option:selected').val();
        cec        = $('#slcCosto option:selected').val();
        estado     = ($('#slcEstados').val() != null) ? $('#slcEstados').val() : "";
        proyecto   = $('#slcProyecto option:selected').val();
        txtFechaIni = $("#txtFechaIni").val();
        txtFechaFin = $("#txtFechaFin").val();
        if (txtFechaIni != "" && txtFechaFin != "") {
            if (!validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val())) {
            crear_alerta('error', 'Reporte de activos por área', 'Verifique el período de las fechas.');
            return false;
            }
        }
        wait.start();
        $("#contenedor").hide("slide", {
            direction: 'right'
        }, 400, function () { //despues de ocultar div enviar el ajax
            $.ajax({
                type: 'post',
                url: urlj + 'activo/reportes/reporte_general_activo',
                dataType:'json',
                data:{prov :prov,tipoActivo :tipoActivo,sucursal:sucursal,tipo_adq,depto:depto,cec:cec,estado:estado,proyecto:proyecto,fechai:txtFechaIni,fechaf:txtFechaFin},
                success: function (data) {
                    wait.close();
                    $('#hx').show('slow');
                    $("#contenedor").html(data.html);
                    $("#contenedor").removeAttr('style');
                    $("#contenedor").css("overflow", "auto");
                    aplicarDataTable('datagried');
                    $("#exportar").val(1);
                    $('#datagried').css('width', '100%');
                    $("#datagried_length").css('width', '25%');
                    $("select[name='datagried_length']").css('width', '25%');
                    $("select[name='datagried_length']").select2();
                    $('#prov').val(prov);
                    $('#tipoActivo').val(tipoActivo);
                    $('#sucursal').val(sucursal);
                    $('#tipo_adq').val(tipo_adq);                    
                    $('#depto').val(depto);
                    $('#cec').val(cec);
                    $('#estado').val(estado.toString());
                    $('#proyecto').val(proyecto);
                    $('#fechai').val(txtFechaIni);                    
                    $('#fechaf').val(txtFechaFin);
                }
            });
        });
    });

    $("#reporte").validate({
        rules: {
            exportar: {required: true},
        },
        errorPlacement: function (error, element) {
            crear_alerta('error', 'Error', 'Debe filtrar la información a exportar');
        },
        submitHandler: function (form) {
            exp = $("#exportar").val();
            if (exp > 0) {
                form.submit();
            }
        }
    });

}); //End jQuery
