 $(document).ready(function(){
    window.gSateliteWhite.jsSelect();
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $("select option[value=0]").val('');

    $("#dtg_producto").select2('destroy');
    $("#dtg_producto").hide();

    $("#con_filtro").hide();

    $(".select2-search-choice-close, #grupo").click(function(event) {
        $("#sin_filtro").show();
        $("#con_filtro").hide();
    });

    aplidarDataTable("#table");

    $("#codigo_s").select2({        
        placeholder: "Buscar Activos",
        minimumInputLength: 3,
        ajax: {
            url: urlj + 'activo/reportes/get_activo_like',
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (producto) {
                return {
                    producto: producto
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.act_id,
                        'text': item.act_codigo + " " + item.act_nombre
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
            var valor = $("#" + idElemento).val();
            if (valor !== "") {
                var texto = $("#" + idElemento).data('nombre');
                callback({id: valor, text: texto});
            }
        }
    });

    $('#datagried').dataTable({"sPaginationType": "full_numbers"});


    $("#tipo_activo").change(function(event) {
    	var tipo=$(this).val();
    	if($(this).val()>0){
            $.ajax({
                type: 'POST',
                dataType: 'json',
                url: urlj + 'activo/nuevo/get_grupos',
                data: {id_tipo: tipo},
                beforeSend: function(){
                    $("#grupo").attr("placeholder","Cargando..."); 
                    $("#grupo").select2();
                },
                success: function(data){
                    $("#grupo").attr("placeholder","Seleccione");
                    $("#grupo option[value=0]").val('');
                    $("#grupo").html(data.opciones);
                    $("#grupo").select2();
                }
            });
        }else{
            $("#grupo option:first").attr('selected','selected');
            $("#grupo").html('<option value=""></option>');
            $("#codigo option:first").attr('selected','selected');
            $("#codigo").html('<option value=""></option>');
            $("#grupo, #codigo").select2();
        }
    });

    $("#grupo").change(function(event) {
    	var grupo=$(this).val();
    	if($(this).val()>0){
            $.ajax({
                type: 'POST',
                url: urlj + 'activo/nuevo/get_codigoxactivo',
                data: {grupo: grupo},
                beforeSend: function(){
                    $("#codigo").attr("placeholder","Cargando..."); 
                    $("#codigo").select2();
                },
                success: function(data){
                    $("#sin_filtro").hide();
                    $("#con_filtro").show();
                    $("#codigo").attr("placeholder","Seleccione");
                    $("#codigo option[value=0]").val('');
                    $("#codigo").html(data);
                    $("#codigo").select2();
                }
            });
        }else{
            $("#codigo option:first").attr('selected','selected');
            $("#codigo").html('<option value=""></option>');
            $("#codigo").select2();
        }
    });

    $("#codigo_s").change(function(e) {
        $("#act_activo").val($(this).val());
    });

    $("#consultar").click(function(event) {
        event.preventDefault();
        wait.start();
        $("#contenedor").hide("slide", {
            direction: 'right'
        }, 400, function () {
            $.ajax({
                type: 'post',
                url: urlj+'activo/reportes/depreciacion_detalle',
                data: $("#frm_filtros").serialize(),
                success: function (data) {
                    wait.close();
                    var oTable = $('#datagried').dataTable();
                    oTable.fnDestroy();

                    $("#contenedor").html(data);
                    $("#contenedor").removeAttr('style');
                    $('#datagried').dataTable({
                        "iDisplayLength":10,
                        "bAutoWidth": false,
                        "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
                        'oLanguage':{
                            'sLengthMenu': 'Mostrando _MENU_ entradas'
                        }
                    });
                    $('#datagried').css('width', '100%');
                    $("#datagried_length").css('width','25%');
                    $("select[name='datagried_length']").css('width','25%');
                    $("select[name='datagried_length']").select2();
                }
            });
        });
    });

    $('#btn_consultar').click(function(e){
        e.preventDefault();
        var txtFechaIni = $('#txtFechaIni').val();
        var txtFechaFin = $('#txtFechaFin').val();
        var slcTipoActi = $('#tipo_activo').val();
        var slcGrupoAct = $('#grupo').val();
        var slcAreas = $('#slc_area').val();
        if(txtFechaIni != '' && txtFechaFin != ''){
            if (!validarPeriodo(txtFechaIni, txtFechaFin)) {
                crear_alerta('error', 'Depreciación', 'Verifique el período de fechas.');
                return false;
            }
        }
        $.ajax({
            url: urlj + 'activo/nuevo/depreciacion_detalle_filter',
            type: 'post',
            cache: false,
            dataType: 'json',
            data: {
                tipo_activo: slcTipoActi,
                grupo_activo: slcGrupoAct,
                unidad: slcAreas,
                txtFechaIni: txtFechaIni,
                txtFechaFin: txtFechaFin
            },
            beforeSend:function(){
                wait.start();
            },
            success: function (data) {
                $('#filter_date').val(1);
                $('#generar_pdf').show();
                wait.close();
                var oTabla = $("#table").dataTable();
                oTabla.fnDestroy();
                $('#listado').html(data);
                $('#table').dataTable({"sPaginationType": "full_numbers"});
                $('#fechaini').val(txtFechaIni);
                $('#fechafin').val(txtFechaFin);
                $('#tacActiv').val(slcTipoActi);
                $('#grpActiv').val(slcGrupoAct);
                $('#areActiv').val(slcAreas);
            }
        });
    });

    $('#generar_pdf').click(function(e){
        e.preventDefault();
        var filter_date = $('#filter_date').val();
        if(filter_date > 0){
            e.preventDefault();
            $('#tipoReport').val(1);
            $('#frm_hidden').submit();
        }else{
            //e.preventDefault();
            crear_alerta('error', 'Depreciación', 'Seleccione un periodo de fechas.');
            //$('#frm_hidden').submit();
        }
    });

}); //End jQuery


function aplidarDataTable(idTabla) {
    $(idTabla).dataTable({
        // "bFilter": true,
        "sPaginationType": "full_numbers",
        // "bPaginate": false,
        "bJQueryUI": false,
        "bAutoWidth": false,
        // "aoColumnDefs": [],
        // "aaSorting": [],
        "bLengthChange": false,
        "iDisplayLength": 25,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}

