$(document).ready(function () {
    window.gSateliteWhite.jsSelect();
    $("select option[value=0]").val('');
    
    $("input[name^='fecha']").mask("99-99-9999");
    $("input[name^='fecha']").attr('placeholder', "dd-mm-yyyy");
    $("input[name^='fecha']").removeClass('hasDatepicker').datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
        //minDate: 0
    });
    
    $('#datagried').dataTable();
    $("#consultar").click(function(event) {
        event.preventDefault();

        fecha_ini=$("#fecha_ini").val();
        fecha_fin=$("#fecha_fin").val();

        if(fecha_ini!='' || fecha_fin!=''){
            if(!verifica_fecha(fecha_ini,fecha_fin)){
             crear_alerta('error', 'Error', 'Verifique las fechas del período'); 
            return false;
            }
        }
        if (fecha_ini == '') {
            crear_alerta('error', 'Error', 'Campo de fecha es obligatorio'); 
            $("#fecha_ini").focus();
            return false;
        }

        if (fecha_fin == '') {
            crear_alerta('error', 'Error', 'Campo de fecha es obligatorio'); 
            $("#fecha_fin").focus();
            return false;
        }

        wait.start();
        $("#contenedor").hide("slide", {
            direction: 'right'
        }, 400, function () { //despues de ocultar div enviar el ajax
            $.ajax({
                type: 'post',
                url: urlj+'activo/nuevo/index_activos',
                data: $("#frm_filtros").serialize(),
                success: function (data) {
                     wait.close();
                    var oTable = $('#datagried').dataTable();
                    oTable.fnDestroy();
                   
                    $("#contenedor").html(data);
                     $("#contenedor").removeAttr('style');
                     $('#datagried').dataTable({
                        "iDisplayLength":10,
                        "bAutoWidth": false,
                        "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
                        'oLanguage':{
                            'sLengthMenu': 'Mostrando _MENU_ entradas'
                        }
                    });
                    
                    $('#datagried').css('width', '100%');
                    //$("#datagried_length").css('width','25%');
                    //$("select[name='datagried_length']").css('width','25%');
                    //$("select[name='datagried_length']").select2();
                }
            });
        });
    });

    //=========================================================
    // SELECT AJAX PARA SELECT DE ACTIVO FIJO
    //========================================================


    $("#codigo").select2({
        placeholder: "Buscar Activo Fijo",
        //multiple: true,
        minimumInputLength: 3,
        ajax: {
            url: window.gSateliteWhite.baseUrl('activo/reportes/get_activo_like'),
            dataType: 'json',
            type: 'POST',
            delay: 250,
            data: function (activo) {
                return {
                    producto: activo
                };
            },
            results: function (data) {
                var myResults = [];
                $.each(data, function (index, item) {
                    myResults.push({
                        'id': item.act_id,
                        'text': (item.act_codigo + " " + item.act_nombre)
                    });
                });
                return {
                    results: myResults
                };
            }
        },
        initSelection: function (element, callback) {
            var idElemento = element[0].id;
                    var valor = $("#" + idElemento).val();
                    if (valor !== "") {
                        var texto = $("#" + idElemento).data('nombre');
                        callback({id: valor, text: texto});
                    }
        }
    });

}); // End jQuery

function verifica_fecha(fecha_ini, fecha_fin){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
        
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
           // $("#fecha_fin_error").text('Verifique las fechas del periodo');
            //$("#fecha_fin").removeClass('valid');
            //$("#fecha_fin").addClass('error');
          return false;
      }

      if(Date.parse(fecha_i) < Date.parse(fecha_f)){
        //$("#fecha_fin").removeClass('error');
       // $("#fecha_fin").addClass('valid');
        //$("#fecha_fin_error").text('');
        return true;
      }
  }