var depreciarActivo = {
	fn: {
		getSimulacion: function(event){
			event.preventDefault();
			var value  = $('form').serialize();

			depreciarActivo.ajax.getDatos(value);
		},
		setGrafica: function(values){
			console.dir(values);
			var data = depreciarActivo.fn.getCoordenadas(values);
			
			console.dir(data);
			
		},
		getCoordenadas: function(values){
			//Inicializando variables a usar para el calculo de la depreciacion Lineal
			var costo = parseFloat(values.costo).toFixed();
			var depreciacion = parseFloat(values.depreciacion).toFixed();
			var vidaUtil = parseFloat(values.vida).toFixed();
			var xaxis = 0;
			var yaxis = 0;
			var data = [];

			for (var i = 0; i <= vidaUtil; i++) {

				if ( i === 0 ) { 
					//Multiplicar por 1 para convertir a tipo numerico
					yaxis = costo * 1; 
					xaxis = vidaUtil * 1; 
					
				} else {
					costo = costo - depreciacion;
					yaxis = costo;
					xaxis = vidaUtil - i;
				}

				data.push([yaxis, xaxis]);
			};

			//array multimencional con las coordenadas para el grafico
			return data;
		}
	},
	ajax: {
		getDatos: function(value){
			var url = window.gSateliteBlue.baseUrl("activo/simulacion/generar_simulacion");
			
			$.ajax({
				url: url,
				dataType: 'json',
				data: value,
				type: 'GET',
				success: function(data){
					if(data.response === true){
						depreciarActivo.fn.setGrafica(data.message);
					}
				}
			});
		}
	},
	onReady: function(){
		$("button[type='submit']").on('click', depreciarActivo.fn.getSimulacion);
	},
	init: function(){
		depreciarActivo.onReady();
	}
};

jQuery(document).ready(function($) {
	depreciarActivo.init();	
	window.gSateliteBlue.jsSelect();
});