$(document).ready(function(){
    gSateliteWhite.jsSelect();
    window.gSateliteWhite.jsSelect();
    $('#botones_exportar').hide();
        
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $('#datagried').dataTable({"sPaginationType": "full_numbers"});

    $("#consultar").click(function(event) {
        event.preventDefault(); 
        $('#botones_exportar').hide();
        area=$("#area").val();
        txtFechaIni=$("#txtFechaIni").val();
        txtFechaFin=$("#txtFechaFin").val();
        depreciacion=$("#depreciacion").val();
        if (txtFechaIni != "" && txtFechaFin != "") {
            if (!validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val())) {
            crear_alerta('error', 'Reporte de activos', 'Verifique el período de las fechas.');
            return false;
            }
        }
        if(depreciacion ==""){
            crear_alerta('error','Reporte de activos','Debe seleccionar depreciación a filtrar');
            $("#depreciacion").focus();
            return false;
        }
        if(depreciacion < 0){
            crear_alerta('error','Reporte de activos','Debe seleccionar depreciación a filtrar');
            $("#depreciacion").focus();
            return false;
        }
        wait.start();
        $("#contenedor").hide("slide", {
            direction: 'right'
        }, 400, function () { //despues de ocultar div enviar el ajax
            $.ajax({
                type: 'POST',
                url: urlj+'activo/reportes/cuentas_mayor_menor',
                data: $("#frm_filtros").serialize(),
                success: function (data) {
                    wait.close();
                    $('button[name="tipo_reporte"]').removeAttr('disabled');
                    var oTable = $('#datagried').dataTable();
                    oTable.fnDestroy();
                    
                    $("#contenedor").html(data);
                    $("#contenedor").removeAttr('style');
                    $('#datagried').dataTable({
                        "iDisplayLength":10,
                        "bAutoWidth": false,
                        "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
                        'oLanguage':{
                            'sLengthMenu': 'Mostrando _MENU_ entradas'
                        }
                    });
                    $("#exportar").val(1);
                    $('#datagried').css('width', '100%');
                    $("#datagried_length").css('width','25%');
                    $("select[name='datagried_length']").css('width','25%');
                    $("select[name='datagried_length']").select2();
                    $('#botones_exportar').show();                    
                }
            });
        });
    });

    $("#reporte").validate({
        rules: {
            exportar: {required: true},
        },
        errorPlacement: function (error, element) {
            crear_alerta('error', 'Error', 'Debe filtrar la información a exportar');
        },
        submitHandler: function (form){
            exp=$("#exportar").val();
            if(exp>0){
                 form.submit();
            }         
               
        }
    });

}); //End jQuery