$(document).ready(function(){
    var pathArray = window.location.pathname.split( '/' );
    var urlj = url_base_proyecto;
    
    //formato
    gSateliteWhite.jsSelect();
    gSateliteWhite.jsDatePicker();
    
    $("#activos").hide();

    /** @autor Alexis Beltran Validador de dos fechas */
    jQuery.validator.addMethod("fecha_ini_fin", function(value, element, params) {
        ini = Date.parseExact($(params[0]).val(),'yyyy-M-d');
        fin = Date.parseExact($(params[1]).val(),'yyyy-M-d');
        return this.optional(element) || ( ini < fin );
    }, jQuery.validator.format("Verifique las Fechas del Periodo."));
    
    //formulario
    $("select[name='ubi_id']").change(function(){
        $.ajax({
            type: "POST", url: gSateliteWhite.baseUrl("activo/buscar/get_ubf/" + $(this).val())
        }).done(function(html) {
            $("select[name='ubf_id']").empty().html(html);  
        });
    });
    
    $("form[name='frm_solicitud']").validate({        
    });

    valor = $("#depto option:first").val();
         
    if (valor == '' || valor == 0) {  
        $("#depto").prepend('<option value="todos">Todos los departamentos</option>'); 
        $("#depto option[value='0']").remove();
        $("#depto").prepend('<option value="0">Seleccione un departamento</option>');
        $("#depto option[value='0']").attr("selected", "selected");
        $("#depto").select2();
    }

    $("#prs_ver").click(function(event){
       event.preventDefault();
       var depto     = $("#depto").val();
       var tipo      = $('#tipo').val();
       var grupo     = $('#grupo').val();
       var emp_id    = $('#emp_id').val();
       var slcEstado = $("#slcEstado").val();
       var slcCenCosto = $("#slcCenCosto").val();
       var inputbusqueda = $('#inputbusqueda').val();
       var input_nombres = $('#input_nombres').val();

        if(depto != 0){
            $.ajax({
                type: "POST",
                dataType: 'json',
                url: gSateliteWhite.baseUrl("activo/nuevo/get_activos"),
                data: {
                    depto: depto,
                    tipo: tipo, 
                    grupo: grupo, 
                    emp_id: emp_id, 
                    slcEstado: slcEstado,
                    slcCenCosto: slcCenCosto,
                    inputbusqueda: inputbusqueda, 
                    input_nombres: input_nombres
                },
                beforeSend:function(){
                       wait.start();
                },
                success: function(data){
                    $("#docs").empty();
                    $('#docs').append(data.datos);
                    if(data.datos.length >0){
                        $("#activos").show('slide');
                    }else{
                         $("#activos").show('slide');
                    }
                    $('#data').dataTable();
                    wait.close();
                }
        	});
       } else {
            crear_alerta('error','Atención','Debe seleccionar un área o departamento');
       }
        
    });

    $("select[name='tipo']").change(function(){
       
        $("select[name='tipo'] option:selected").each(function() {
                id_tipo2 = $("select[name='tipo']").val();

                $.ajax({
                    dataType: 'json',
                    type: 'POST',
                    url: urlj+'activo/nuevo/get_grupos',
                    data: {id_tipo:id_tipo2},
                     success: function(data){
                  
                        $("select[name='grupo']").empty();
                        $("select[name='grupo']").append(data.grupo);
                        $("select[name='emp_id']").empty();
                        $("select[name='emp_id']").append(data.empleado);
                        window.gSateliteWhite.jsSelect();
                    
                },
                error: function(data){
                    
                }
                });
            });

    });
    
    
    $("textarea[name='justificacion']").keyup(function(){
        console.log( $(this).val() );
        $("input[name='desc']").val( $(this).val() ); 
    });
    
    $("select[name='tipo']").change(function(){
       $("#carac_select").empty();
            
        var url = window.gSateliteWhite.baseUrl('activo/nuevo/caracteristicas');
        var value = {
            id_tipo: $(this).val()
        };

        $.ajax({
            url: url,
            dataType: 'json',
            data: value,
            type: 'POST',
            success: function(data){
                if(data.response === true){
                    $("#carac_select").html(data.html);
                    window.gSateliteWhite.jsSelect();
                    $("#carac_select").fadeIn("slow");
                }
            },
            error: function(data){
                
            }
        });
        
        $("#carac_select").show(500); 
    });

    $(".ver-accion-modal").live('click', function (event) {
        event.preventDefault();
        var url = $(this).attr('href');
        $.fancybox({
            'href': url,
            type:  'iframe',
            width: '100%',
            closeBtn: true,
            height: '100%'
        });
    });
    
});