/**
 * Descripcion: Interaccion con el usuario en àsignacion de activo fijo
 * @author:     Alan Alvarenga.
 * @version:    0.2 2013-07-30
 * @since:      2013-07-26
 * @package:    CONAMYPE
 * @type {Object}
 * =================================================================================================
 * Nomenclatura:
 * + AGREGADO
 * - ELIMINADO
 * * ACTUALIZADO
 * -------------------------------------------------------------------------------------------------
 * Bitacora:
 * 2013-07-30 v0.2
 * + asignarActivo.ajax.getUbicacionesArea  -   Obtiene la ubicacion del area seleccionada
 * + asignarActivo.fn.getEmpleadosArea  -   Refactorizacion de codigo para modularidad
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 * 2013-07-26 v0.1
 * + asignarActivo.alerts.checkAssing 	- 	Verifica resultado de la asignacion de activo fijo
 * + asignarActivo.onReady 	- 	Agrega EventListeners a los elementos del DOM
 * + asignarActivo.init 	-  	Inicializar objecto
 * por Alan Alvarenga.
 * -------------------------------------------------------------------------------------------------
 */
var asignarActivo = {
    fn: {
        getEmpleadosArea: function(){
            //Adquirir empleados por area 
            //Donde se insertaran las opciones?
            var insert = 'asi_empleado';
            //Parametros para el query 
            var where = { "emp_id_are": $(this).val() }; 
            //Enviar por get
            var options = {
                    tabla: 'emp_empleado',
                    where: where,
                    insert: insert,
                    display: 'emp_nombres'
                };
            //Generar filtro para empleados por area
            window.gSateliteBlue.jsSelectFilter(options);

            //Adquirir ubicaciones por Area
            
            //inicializando variables
            var value = {
                id_area: $(this).val()
            };
            //Obtener ubicacion del area
            asignarActivo.ajax.getUbicacionesArea(value);
        }   
    },
    ajax: {
        /*
        Obtiene la ubicacion del area seleccionada
         */
        getUbicacionesArea: function(value){
            //Ubicacion de la funcion
            var url = window.gSateliteBlue.baseUrl("activo/asignar/get_ubicaciones");
            $.ajax({
                url: url,
                dataType: 'json',
                data: value,
                type: 'GET',
                success: function(data){
                    var $selectUbicacion = $("select[name='asi_ubicacion']");
                        $selectUbicacion.empty();
                    if(data.response === true){
                        var ubicacion = data.message.ubicacion;
                        var id = ( typeof data.message.id === 'undefined' ) ? 0 : data.message.id;
                        $selectUbicacion.append("<option value='" + id + "'>" + ubicacion + "</option>");
                    } 
                }
            });
        },
        
        getDatos: function(){
            var valor = $("select[name='sucursal']").val();
            $.ajax({
                async: true,
                url: gSateliteBlue.baseUrl('activo/asignar/buscar_datos'),
                type: "POST",
                dataType: "json",
                data: {id: valor},
                success: function(data) {
                    if (data.response === true) {
                        $("select[name='are_id']").empty().append(data.areas).select2();
                        $("select[name='ubi_id']").empty().append(data.oficinas).select2();
                        $("select[name='emp_id']").empty().append(data.empleados).select2();
                    }
                },
                error: function(data) {
                    alert("No se pudo cargar las areas! Porfavor vuelva a regargar la pagina");
                }
            });
        }
    },
	/**
     * Agrega EventListeners a los elementos del DOM
     */
	onReady: function(){
		//Convertir todos los select a select2
		window.gSateliteBlue.jsSelect();
		//Filtro de empleados por area
		//$('select[name="asi_area"]').on('change', asignarActivo.fn.getEmpleadosArea);
        //
        //$('select[name="sucursal"]').on('change', asignarActivo.ajax.getDatos());
	},
	alerts: {
        //Verifica resultado de la asignacion de activo fijo
        checkAssign: function(){
            //Obtener el resultado de la operacion
            var result_assign = window.location.search;
            //Verificar si el resultado ha sido enviado desde el servidor
            if( typeof result_assign !== 'undefined' && result_assign !== "" ){
                //Evaluar resultado
                result_assign = parseInt( result_assign.substr(result_assign.length -1));
                if(result_assign === 1){
                    //Registro de activo exitoso
                    create("note_success", {
                        title: 'Operaci&oacute;n Completada',
                        text: 'Activo Fijo Asignado Correctamente'
                    }, {
                        expires: false
                    });
                } else {
                    //Registro de activo fallo
                    create("note_error", {
                        title: 'Operaci&oacute;n Fallo',
                        text: 'El Activo no pudo ser asignado, por favor intentalo de nuevo'
                    }, {
                        expires: false
                    });
                }

            }  
        }//fin checkAssign
    },
	/*
		Inicializar objecto
	 */
	init: function(){
		asignarActivo.onReady();
		asignarActivo.alerts.checkAssign();
	}
	
}

jQuery(document).ready(function($) {
	asignarActivo.init();
    
    $("select[name='sucursal']").change(asignarActivo.ajax.getDatos());
});