 $(document).ready(function(){
    window.gSateliteWhite.jsSelect();
    $("select option[value=0]").val('');

    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });

    $('#datagried').dataTable({"sPaginationType": "full_numbers"});

    $("#consultar").click(function(event) {
        event.preventDefault();       

        $("#exportar").val(0);
        var fecha_ini = $("#fecha_ini").val();
        var fecha_fin = $("#fecha_fin").val();
        var cuenta    = $("#cuenta").val();

        

        if (fecha_ini != "" && fecha_fin != "") {
            if (!validarPeriodo($("#fecha_ini").val(), $("#fecha_fin").val())) {
            crear_alerta('error', 'Reporte de activos por área', 'Verifique el período de las fechas.');
            return false;
            }
        }

        if(cuenta!='' ){
            wait.start();
            $("#contenedor").hide("slide", {
                direction: 'right'
            }, 400, function () { //despues de ocultar div enviar el ajax
                $.ajax({
                    type: 'post',
                    url: urlj+'activo/reportes/rpt_activo_cuenta',
                    data: $("#frm_filtros").serialize(),
                    success: function (data) {
                         wait.close();
                        var oTable = $('#datagried').dataTable();
                        oTable.fnDestroy();
                       
                        $("#contenedor").html(data);
                         $("#contenedor").removeAttr('style');
                         $('#datagried').dataTable({
                            "iDisplayLength":10,
                            "bAutoWidth": false,
                            "aLengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Todos"]],
                            'oLanguage':{
                                'sLengthMenu': 'Mostrando _MENU_ entradas'
                            }
                        });

                          $("#exportar").val(1);
                        $("#filtro_inicio").val(fecha_ini);
                        $("#filtro_fin").val(fecha_fin);  
                        if(cuenta>0){
                            $("#filtro_cuenta").val(cuenta);
                        }                       
                        
                        $('#datagried').css('width', '100%');
                        $("#datagried_length").css('width','25%');
                        $("select[name='datagried_length']").css('width','25%');
                        $("select[name='datagried_length']").select2();
                    }
                });
            });
        }else{
            crear_alerta('error', 'Error', 'Verifique los campos requeridos.')
        }
    });

     $(".print").click(function(event) {
       event.preventDefault();

       if($("#exportar").val()!=1){
        crear_alerta('error', 'Error', 'Debe filtrar los registros a buscar.');
       }else{
         $("#frm_filtros").submit();
       }

    });

   }); //End jQuery


  function verifica_fecha(fecha_ini, fecha_fin){
        //Convierto la fecha a Y-m-d
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");

        if(Date.parse(fecha_i) == Date.parse(fecha_f)){ $("#fecha_fin_error").text(''); return true;}
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
            $("#fecha_fin_error").text('Verifique las fechas del periodo');
            $("#fecha_fin").removeClass('valid');
            $("#fecha_fin").addClass('error');
          return false;
      }

      if(Date.parse(fecha_i) < Date.parse(fecha_f)){
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin").addClass('valid');
        $("#fecha_fin_error").text('');
        return true;
      }
  }
