var pathArray = window.location.pathname.split( '/' );
var urlj      = url_base_proyecto;

$(document).ready(function(){
    $('#slcCosto').select2();
    $('#datagried1').dataTable({"sPaginationType": "full_numbers", "aaSorting": []});
    $('select option[value=0]').val('');
    $(".datePicker").datepicker({
        showButtonPanel: true,
        changeMonth: true,
        changeYear: true,
        dateFormat: 'dd-mm-yy',
        monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
        dayNamesMin: ["Do", "Lu", "Ma", "Mi", "Ju", "Vi", "Sa"],
        nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy'
    });
    $(".datePicker").mask('99-99-9999');

    $("#frm_traslado").validate({
        ignore:"", 
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            var nombre=$(element).attr("id");
            $('#'+nombre+'_error').text('Campo requerido');
        },
        submitHandler: function(form) {
            form.submit();
        }
    });

    $(".seleccion").select2();
    $("#area").select2();

    $("#buscar").click(function(event){
        event.preventDefault();
        fecha_ini   = $("#txtFechaIni").val();
        fecha_fin   = $("#txtFechaFin").val();
        activo      = $("#activo").val();
        responsable = $("#responsable").val();
        sucursal    = $("#sucursal").val();
        area        = $("#area").val();
        tipo_activo = $("#slcTipoActivo").val();
        slcCosto    = $("#slcCosto").val();

        if(!$("#frm_traslado").valid()){
            crear_alerta('error','Alerta','Campos con * son requeridos.');
            //$("#txtFechaIni_error").text('Campo requerido');
            //$("#txtFechaFin_error").text('Campo requerido');
            return false;
        }

        if (fecha_ini != "" && fecha_fin != "") {
            if (!validarPeriodo($("#txtFechaIni").val(), $("#txtFechaFin").val())) {
            crear_alerta('error', 'Reporte de activos por área', 'Verifique el período de las fechas.');
            return false;
            }
        }

        

        $.ajax({
            dataType:'json',
            type:'post',
            data:{fecha_ini:fecha_ini,
                fecha_fin:fecha_fin,
                activo:activo,
                responsable:responsable,
                sucursal:sucursal,
                area:area,
                tipo_activo:tipo_activo,
                slcCosto:slcCosto
            },
            url:urlj+'activo/reportes/traslado_activos/1',
            beforeSend: function() {
                wait.start();
            },
            success:function(data){
                wait.close();
                var oTable = $('#datagried1').dataTable();
                oTable.fnDestroy(); 

                $('#tbContenedor').html(data);

                aplicarDataTable('datagried1');

                if(data.lista.length<=0){
                    $("#listado").append("<tr><td colspan='7' style='text-align:center;'><b>No se encontraron resultados</b></td></tr>")
                }
                wait.close();
            }, error: function (xhr, ajaxOptions, thrownError) {
                //console.log(xhr.status);
                //console.log(thrownError);
            }
        });

    });     

    $("#direccion").mouseover(function(){
        $("#tipo").val(1);
    });

    $("#dir_excel").mouseover(function(){
        $("#tipo").val(2);
    });

    $(document).on('change', '#txtFechaIni', function() {
        if ($(this).val() != "") {
            validar_fecha_inicio_fin("txtFechaIni", "txtFechaFin");
            $("#filtro_txtFechaIni").val($(this).val());
        } else {
            $("#filtro_txtFechaIni").val('');
        }
    });

    $(document).on('change', '#txtFechaFin', function() {
        if ($(this).val() != "") {
            validar_fecha_inicio_fin("txtFechaIni", "txtFechaFin");
            $("#filtro_txtFechaFin").val($(this).val());
        } else {
            $("#filtro_txtFechaFin").val('');
        }
    });

    $(document).on('change', '#activo', function() {
        if ($(this).val() != "") {
            $("#filtro_activo").val($(this).val());
        } else {
            $("#filtro_activo").val(0);
        }
    });

    $(document).on('change', '#responsable', function() {
        if ($(this).val() != "") {
            $("#filtro_responsable").val($(this).val());
        } else {
            $("#filtro_responsable").val(0);
        }
    });

    $(document).on('change', '#sucursal', function() {
        if ($(this).val() != "") {
            $("#filtro_sucursal").val($(this).val());
        } else {
            $("#filtro_sucursal").val(0);
        }
    });

    $(document).on('change', '#slcCosto', function() {
        if ($(this).val() != "") {
            $("#slcCosto2").val($(this).val());
        } else {
            $("#slcCosto2").val('');
        }
    });


    $(document).on('change', '#area', function() {
        if ($(this).val() != "") {
            $("#filtro_area").val($(this).val());
        } else {
            $("#filtro_area").val(0);
        }
    });

});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}