jQuery(document).ready(function ($) {
    $('select').select2();

    $("#frmConsultaform").validate({
        ignore: "",
        rules: {
            //slcTipoActivo: {required: true}
        },
        messages: {
            //slcTipoActivo: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }
        },
        submitHandler: function (form) {
            $("#contenedorTabla").hide("slide", { 
                direction: 'right'
                }, 400, function() { //despues de ocultar div enviar el ajax
                    url_ajax = window.satelite.base_url('activo/reportes/filtrar_total_activos');
                    $.ajax({
                        url: url_ajax,
                        type: 'POST',
                        dataType: 'json',
                        data: {
                            slcTipoActivo: $("#slcTipoActivo").val(),
                            slcGrupo: $("#slcGrupo").val(),
                            slcAdq: $("#slcAdq").val(),
                            slcArea: $("#slcArea").val(),
                            slcDepreciable: $("#slcDepreciable").val(),
                            slcCosto: $("#slcCosto").val(),
                            slcState: $("#slcEstado").val(),
                            slcSuc: $("#slcSuc").val(),
                            limit_monto: $("#limit_monto").val()
                        },
                        beforeSend: function () {
                            wait.start();
                        },
                        error: function (xhr, status, error){
                            exportarError(xhr.responseText);
                            wait.close();
                        },
                        success: function (json) {
                            $("#contenedorTabla").html(json.html);
                            $("#contenedorTabla").show("slide", {
                                direction: 'left'
                            }, 500);
                            wait.close();
                        }
                    });
                });
        }
    });

    $("#slcTipoActivo").change(function(event) {
        cargar_grupos();
    });

});

function  cargar_grupos() {

    url_ajax = window.satelite.base_url('activo/reportes/filtrar_grupos_option');
     $.ajax({
         url: url_ajax,
         type: 'POST',
         dataType: 'json',
         data: {
             slcTipoActivo: $("#slcTipoActivo").val()
         },
         beforeSend: function () {
             wait.start('Cargando grupos...');
         },
         error: function (xhr, status, error){
          exportarError(xhr.responseText);
          wait.close();
      },
      success: function (json) {
          $("#slcGrupo").html(json.options);
          $("#slcGrupo").select2();
          wait.close();

      }
  });
}