jQuery(document).ready(function ($) {
    $('#frmConsultaform select').select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({
        dateFormat: 'mm-yy', 
        changeMonth: true, 
        changeYear: true,
        showButtonPanel: true,
        onClose: function(dateText, inst) { 
            $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
            validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta');
        }
    });

    $("#txtFecha_desde,#txtFecha_hasta").change(function(event) { 
        validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta');
    });

    $("#frmConsultaform").validate({
        ignore: "",
        messages: {
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select')){
                $(element).next().append(error);
            } else {
                error.insertAfter(element);
            }
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");
        },
        submitHandler: function (form) {
            $("#contenedorTabla").hide("slide", { 
                direction: 'right'
            }, 400, function() { //despues de ocultar div enviar el ajax
                url_ajax = window.satelite.base_url('activo/reportes/filtrar_depreciacion_consolidada');
                txtFecha_hasta = $("#txtFecha_hasta").val();
                a_detalle = ($("#a_detalle").attr('checked'))? 1:0;
                departamento = $("#slcDepartamento").val();
                tipo_activo = $("#slcTipoActivo").val();
                agrupacion = $("#agrupacion").val();
                ctas_contn = $("#cta_contable").val();
                estado = ($("#slcEstados").val() == null || $("#slcEstados").val() == "") ? '' : $("#slcEstados").val();
                slcCosto = $('#slcCosto').val();
                $.ajax({
                    url: url_ajax,
                    type: 'POST',
                    dataType: 'json',
                    data: {
                        txtFecha_hasta: txtFecha_hasta, 
                        a_detalle:a_detalle,
                        departamento:departamento,
                        tipo_activo:tipo_activo,
                        agrupacion:agrupacion,
                        cta_ctble:ctas_contn,
                        estado:estado,
                        slcCosto:slcCosto
                    },
                    beforeSend: function () {
                        wait.start();
                    },
                    error: function (xhr, status, error){
                        exportarError(xhr.responseText);
                        wait.close();
                    },
                    success: function (json) {
                        $("#contenedorTabla").html(json.html);
                        if (a_detalle > 0) {
                            $('#imprimir_pdf').hide();
                        } else {
                            $('#imprimir_pdf').show();
                        }
                        $("#contenedorTabla").show("slide", {
                            direction: 'left'
                        }, 500);
                        wait.close();
                    }
                });
            });
        }
    });

    $("#a_detalle").iButton({
        'labelOn':  "&nbsp;&nbsp; A detalle &nbsp;&nbsp;",
        'labelOff': " Sin detalles "
    });

});
