jQuery(document).ready(function ($) {
    setTimeout(function() {
        $("#chk_estado").iButton({
            'labelOn': ' Activo ',
            'labelOff': ' Inactivo ',
            change: function (element) {
                if (element.is(':checked')) {                    
                    $("#txt_estado").val(1);
                } else {                    
                    $("#txt_estado").val(0);
                }
            }
        });
        $("#chk_estado").closest('.ibutton-container').css('margin-top', '0%');
    }, 300);

    $('select').select2();
    $("input[name^='fecha'], input[name^='txtFecha']").mask('99-9999');
    $("input[name^='fecha'], input[name^='txtFecha']").datepicker({
      dateFormat: 'mm-yy', 
      changeMonth: true, 
      changeYear: true,
      showButtonPanel: true,
      monthNamesShort: ["Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"],
      nextText: "Siguiente",
        prevText: "Anterior",
        closeText: 'Cerrar',
        currentText: 'Hoy',
      onClose: function(dateText, inst) { 
          $(this).datepicker('setDate', new Date(inst.selectedYear, inst.selectedMonth, 1));
          validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta');
      }
    });

    $("#txtFecha_desde,#txtFecha_hasta").change(function(event) { 
      validar_fecha_inicio_fin('txtFecha_desde','txtFecha_hasta','La fecha de desde debe ser menor a la fecha hasta');
       });

    $("#frmConsultaform").submit(function(e) {
            e.preventDefault();
        }).validate({
        ignore: "",
        messages: {
            txtFecha_desde: "Campo requerido",
            txtFecha_hasta: "Campo requerido"
        },
        ignore: ".select2-container",
        errorPlacement: function (error, element) {
            if (element.is('select'))
            {
                $(element).next().append(error);
            }
            else
            {
                error.insertAfter(element);
            }
            $("[for=txtFecha_desde]").css("margin-left", "17%");
            $("[for=txtFecha_hasta]").css("margin-left", "17%");

        },
        submitHandler: function (form) {
          txtFecha_desde = $("#txtFecha_desde").val();
          txtFecha_hasta = $("#txtFecha_hasta").val();


          if (txtFecha_desde != "" && txtFecha_hasta != "") {
                if (!validarPeriodo($("#txtFecha_desde").val(), $("#txtFecha_hasta").val())) {
                crear_alerta('error', 'Reporte de activos por área', 'Verifique el período de las fechas.');
                return false;
                }
            }
           $("#contenedorTabla").hide("slide", { 
            direction: 'right'
          }, 400, function() { //despues de ocultar div enviar el ajax
              url_ajax = window.satelite.base_url('activo/reportes/filtrar_depreciacion_activo');
              

               $.ajax({
                   url: url_ajax,
                   type: 'POST',
                   dataType: 'json',
                   data: {
                       slcTipoActivo: $("#slcTipoActivo").val(),
                       slcArea: $("#slcArea").val(),
                       txtFecha_desde: txtFecha_desde,
                       txtFecha_hasta: txtFecha_hasta,
                       txt_estado: $("#txt_estado").val(),
                       slcCosto: $('#slcCosto').val()
                   },
                   beforeSend: function () {
                       wait.start();
                   },
                   error: function (xhr, status, error){
                    exportarError(xhr.responseText);
                    wait.close();
                },
                success: function (json) {
                    $("#contenedorTabla").html(json.html);
                    $("#contenedorTabla").show("slide", {
                      direction: 'left'
                    }, 500);
                    wait.close();

                }
            });
        });
       }
   });



});
