$(document).ready(function(){

    $('select').select2();

    $("#btnConsultar").click(function(event){
        event.preventDefault();
        var tipo   = $("#slc_tipo").val();
        var slcCosto = $('#slcCosto').val();

        if (tipo == "") {
            crear_alerta('error', 'Reporte de características por activo', 'Favor seleccione un tipo.');
            return false;
        }

        $("#dv_contenedor").hide('slide', {
            direction: 'right'
        },
            400, function () {
                $.ajax({
                    type: 'post',
                    url: window.gSateliteWhite.baseUrl('activo/reportes/imprimir_caracteristicas/1'),
                    data: {tipo_activo: tipo,slcCosto:slcCosto},
                    dataType: 'json',
                    beforeSend: function () {
                        wait.start();
                    },
                    success: function (result) {
                        wait.close();
                     
                        var oTable = $('#tabla').dataTable();
                        oTable.fnDestroy(); 

                        $("#tbContenedor").html(result.html);
                        $("#costos").val(slcCosto);

                        aplicarDataTable('tabla');

                        $("#dv_contenedor").show("slide", {
                            direction: 'left'
                        }, 500);

                    }
                });
            }
        );
    
    });

    $("#imprimir").mouseover(function(event){
        $("#tipo").val(1);
    });

    $(document).on('click', '#imprimir', function(event) {
        if($("#slc_tipo").val()>0) {
            $("#frm_contenedor").submit();
        } else {
            crear_alerta('error', 'Reporte de características por activo', 'Favor seleccione un tipo.');
            return false;
        }
    });


    $("#imp_excel").mouseover(function(event){
        $("#tipo").val(2);
    });

    $(document).on('click', '#imp_excel', function(event) {
        if($("#slc_tipo").val()>0) {
            $("#frm_contenedor").submit();
        } else {
            crear_alerta('error', 'Reporte de características por activo', 'Favor seleccione un tipo.');
            return false;
        }
    });

    $(document).on('change', '#slc_tipo', function(){
        if($(this).val()>0) {
            $("#filtro_tipo").val($(this).val());

        }
    });

    $('#tabla').dataTable({"sPaginationType": "full_numbers"});
});

function aplicarDataTable(idTabla) {
    $('#' + idTabla).dataTable({
        "sPaginationType": "full_numbers",
        "bJQueryUI": false,
        "bAutoWidth": false,
        "iDisplayLength": 10,
        "bLengthChange": false,
        "bDestroy": true,
        "fnInitComplete": function (oSettings, json) {
            $('.dataTables_filter>label>input').attr('id', 'search');
        }
    });
}