var pathArray = window.location.pathname.split( '/' );
var urlj=url_base_proyecto;
var autogestion = ($("#es_autogestion").length > 0) ? true : false;
$(document).ready(function(){
    console.log('autogestion: '+autogestion);

    $("select").select2();
    $("#n_horas").numeric();
    $(".contenedor_input").attr('style', 'width:50% !important;');
    $(".fechas_dia").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $(".fechas_dia").mask('99-99-9999');
    if ($("#mostrar_tab_desc").val() == 1) {
        $("#tab_des").show();
    } else {
        $("#tab_des").hide();
    }
    
    $('.relojito').timeEntry({
        show24Hours: true,
        showSeconds: false,
        beforeShow: hora_limite,
        spinnerIncDecOnly: true,
        spinnerImage: ''
    });

    $("#chk_hora3").iButton({
        'labelOn': ' Sí ',
        'labelOff': ' No ',
        'resizeHandle': false,
        'resizeContainer': false,
        change : function(element)
        {
            if((element.is(':checked')))
            {
                $(".relojito").timeEntry('disable');
                let h1 = "08:00";//POSIBLE MEJORA, VER SI EPMLEADO TIENE HORARIO DE ENTRADA
                let h2 = ("00:00");
                let hora1 = h1.split(":");
                let hora2 = h2.split(":");
                let d_1 = new Date(2000, 1, 1, hora1[0], hora1[1]);
                let d_2 = new Date(2000, 1, 1, hora2[0], hora2[1]);
                let dif = d_1.getTime() - d_2.getTime();
                let horas =  Math.floor(dif / 3600000);
                let n_hora = (horas + horas_trabajadas_dia);
                $("#hora_1").val(h1);
                $("#hora_2").val(n_hora + ':' + '00');
                $(".relojito").trigger("blur");
            }
            else
            {
                $("#hora_1, #hora_2").val("");
                $("#horitas").val('');
                $("#minutitos").val('');
                $("#n_horas").val('');
                $(".relojito").trigger("blur");
                $(".relojito").timeEntry('enable');
            }
        }
    });

    $('.relojito').blur(function(event) {
        event.preventDefault();
        var h1 = $("#hora_1").val();
        var h2 = $("#hora_2").val();
        if (h1 != "" && h2 != "") {
            var hora1 = h1.split(":");
            var hora2 = h2.split(":");
            var d_1 = new Date(2000, 1, 1, hora1[0], hora1[1]);
            var d_2 = new Date(2000, 1, 1, hora2[0], hora2[1]);
            var dif = d_2.getTime() - d_1.getTime();
            var horas =  Math.floor(dif / 3600000);
            var minut =  Math.floor((dif % 3600000) / 60000);
            $("#horitas").val(horas);
            $("#minutitos").val(minut);
        }else{
            $("#horitas").val("");
            $("#minutitos").val("");
        }
        $(".tiempo").trigger("blur");
    });


    $("#boton_siguiente").live('click', function(event){
        event.preventDefault();
        if ($("#mostrar_tab_desc").val() > 0) {
            saltar_tab('tab_descuento', 100);
        } else {
            saltar_tab('tab_anexo', 100);
        }
    });

    $("#boton_anterior").live('click', function(event){
        event.preventDefault();
        if ($("#mostrar_tab_desc").val() > 0) {
            saltar_tab('tab_descuento', 100);
        } else {
            saltar_tab('tab_permiso', 100);
        }
    }); 

    $(".goback").click(function(event) {
        //BOTON REGRESAR A MENU CAMBIA SI ES AUTOGESTION
        id_emp = $("#emp_id").val(); 
        if (autogestion) {
            direccion = ($("#autoservicio").val() > 0) ? "auto_gestion/acciones/lista_permiso_colaborador/" : "auto_gestion/acciones/lista_permisos_empleado/";
        } else {
            direccion = "acciones_personal/principal/gestion_horas_notrabajadas/";
        }
        location.href = window.gSateliteWhite.baseUrl(direccion + id_emp);
    });

    $("#tipo_hora_faltante").change(function(event) {
        if($(this).val() > 0){
            $.ajax({
                url: urlj + 'acciones_personal/principal/get_tipo_permisos',
                type: 'POST',
                dataType: 'json',
                data: {
                    id_tipo: $(this).val(),
                },
                beforeSend:function(){
                },
                success: function(data) {
                    $("#motivo").html(data.dropdown);
                    $("#motivo").select2();
                }
            });
            $.ajax({
                url: urlj + 'acciones_personal/principal/buscar_horas_consumidas',
                type: 'POST',
                async: false,
                dataType: 'json',
                data: {
                    id_tipo: $(this).val(),
                    id_empl: $("#emp_id").val()
                },
                beforeSend:function(){
                    $("#div-cant-horas").css("display","none");
                },
                success: function(data) {

                    if (data.tipo === 'V2_COM' && Array.isArray(data.horas) && data.horas.length > 0) {
                        let horas = 0;
                        $.each(data.horas, function(index, value){
                            horas += parseFloat(value.tce_disponible);
                        });
                        $("#count-horas").text(`${horas} Horas disponibles`);
                        $("#input-count-horas").val(horas);
                        $("#div-cant-horas").fadeIn();
                    }
                    if (data.restringir){
                        crear_alerta('warning', '', 'Este tipo de permiso no posee disponibilidad');
                        setTimeout(function() {
                            $("#tipo_hora_faltante").val('').trigger('change');
                        }, 100);
                        return false
                    }
                    if (data.stopXdisca){
                        crear_alerta('error', '', 'No puede aplicar a este tipo de permiso');
                        setTimeout(function() {
                            $("#tipo_hora_faltante").val('').trigger('change');
                        }, 100);
                        return false
                    }
                }
            });
            if (!autogestion) {
                var rpt = $("#tipo_hora_faltante option:selected").data('repite');
                if (rpt > 0) {
                    $("#divrptr").show();
                } else {
                    $('#chk_repetir').iButton('toggle', false);
                    $("#divrptr").hide();
                }
            }            
            $.ajax({
                url: urlj + 'acciones_personal/principal/registro_tipo_hora_faltante',
                type: 'post',
                dataType: 'json',
                data: {
                    id_tipo: $(this).val()
                },
                success: function(data) {
                    if (data.descuento != null){
                        $("#factor_multiplica").val(data.factor_multiplica);
                        $("#n_horas").trigger('keyup');
                        if (autogestion) {
                            //si es autogestion no mostrar tab de descuento
                            $("#mostrar_tab_desc").val(0);
                            $("#descuento_planilla, #tab_des").hide();
                        } else {
                            $("#mostrar_tab_desc").val(1);
                            $("#descuento_planilla, #tab_des").show();
                        }
                    } else {
                        $("#mostrar_tab_desc").val(0);
                        $("#descuento_planilla, #tab_des").hide();
                    }
                }
            });
        } else {
            $("#descuento_planilla, #tab_des").hide();
            $("#factor_multiplica").val('');
            $("#n_horas").trigger('keyup');
            $("#mostrar_tab_desc").val(0);
        }
    });

    $("#chk_repetir").iButton({
        'labelOn': ' Sí ',
        'labelOff': ' No ',
        'resizeHandle': false,
        'resizeContainer': false,
        change : function(element){
            if((element.is(':checked'))){
                $("#thf_recurrentes").val(1);
                $("#permisos_repetir").show();
            }else{
                $('#ctd_fin_rpt').val('');
                $("#thf_recurrentes").val(0);
                $('#txt_fin_repite').html('');
                $('#txt_tipo_fin_rpt').hide();
                $('#txt_tipo_repite').text('');
                $('#ctdad_tipo_repite').val('');
                $('#fecha_tipo_fin_rpt').val('');
                $('#tipo_fin_repite').val('').trigger('change');
                $('#tipo_recurrencia').val('').trigger('change');
                $("#permisos_repetir").hide();
            }
        }
    });

    $("#tipo_fin_repite").change(function(event) {
        if ($(this).val() != "") {
            if ($(this).val() > 1) {
                $('#por_fech').hide();
                $('#por_even').show();
                $('#txt_tipo_fin_rpt').show();
                $("#fecha_tipo_fin_rpt").val("");
                $("#txt_fin_repite").html("Después de: <b style='color:red'>*</b>");
            } else {
                $('#por_even').hide();
                $('#por_fech').show();
                $("#ctd_fin_rpt").val("");
                $('#txt_tipo_fin_rpt').show();
                $("#txt_fin_repite").html("En la Fecha: <b style='color:red'>*</b>");
            }
        } else {
            $('#por_even').hide();
            $('#por_fech').hide();
            $("#ctd_fin_rpt").val("");
            $("#txt_fin_repite").html("");
            $("#txt_tipo_fin_rpt").hide();
            $("#fecha_tipo_fin_rpt").val("");
        }
    });

    $("#tipo_recurrencia").change(function(event) {
        if ($(this).val() != "") {
            switch(parseInt($(this).val())) {
                case 1:
                    $('#bkTipoFrec').val('d');
                    $('#ctdad_tipo_repite').val('');
                    $('#txt_tipo_repite').text('Día(s)');
                    break;
                case 2:
                //execute SEMANAL
                    break;
                case 3:
                //execute MENSUAL
                    break;
                case 4:
                //execute ANUAL
                    break;
                default:
                    setTimeout(function() {$('#tipo_recurrencia').val('').trigger('change');}, 50);                
            }               
        } else {
            $('#bkTipoFrec').val('');
            $('#txt_tipo_repite').text('');
            $('#ctdad_tipo_repite').val('');
            $('#tipo_fin_repite').val('').trigger('change');
        }
    });

    $("#tipo_planilla").change(function(event) {
        cargarPeriodos($(this).val());
    });

    $("#n_horas").keyup(function(event) {
        factor  = $("#factor_multiplica").val();
        nhoras  = $(this).val();
        salario = $("#salario_empleado").val();
        calcula = ((salario / (dias_trabajados_mes*horas_trabajadas_dia)) * nhoras); 
        n_calculo = (calcula * factor);
        $("#calculo_monto").val(n_calculo.toFixed(2));
    });

    $(".tiempo").blur(function(event) {
        event.preventDefault();
        var tiempo_total = 0
        var horas = ($("#horitas").val() != '') ? parseFloat($("#horitas").val()) : 0;
        var minutos = ($("#minutitos").val() != '') ? parseFloat($("#minutitos").val()) : 0;
        var fecha_inicio = $("#txtFechaDesde").val();
        var fecha_fin = $("#txtFechaHasta").val();
        var horas_dias = calculo_horasxdias(fecha_inicio, fecha_fin);
        tiempo_total = (horas * 60) + minutos;
        horas_dias = (horas_dias * 60);
        if (tiempo_total > horas_dias) {
            crear_alerta('error', 'Información', 'La cantidad de horas excede las horas laborales.');
            $("#horitas").val('');
            $("#minutitos").val('');
            $("#n_horas").val('');
            return false;
        }
        var time = number_format((tiempo_total / 60), 2,".","");
        if (parseFloat(time) > 0) {
            $.ajax({
                url: urlj + 'acciones_personal/principal/buscar_horas_consumidas',
                type: 'POST',
                async: false,
                dataType: 'json',
                data: {
                    id_empl: $("#emp_id").val(),
                    id_tipo: $("#tipo_hora_faltante").val()
                },
                success: function(data) {
                    if (data.restringir){
                        crear_alerta('warning', '', 'Este tipo de permiso no posee disponibilidad');
                        setTimeout(function() {
                            $("#tipo_hora_faltante").val('').trigger('change');
                        }, 100);
                        return false
                    } else {
                        if (parseFloat(data.asignadas) > 0 && parseFloat(time) > parseFloat(data.disponible)) {
                            crear_alerta('warning', '', 'Datos ingresados sobrepasan la disponibilidad <br>(Disponible: '+data.disponible+' h)');
                            setTimeout(function() {
                                $(".fechas_dia, .mismo_dia, .tiempo").val('');
                            }, 100);
                            $("#n_horas").val("");
                        } else {
                            $("#n_horas").val(time);
                            let disponibles =  $("#input-count-horas").val();
                            if (parseFloat(time) > disponibles && data.compensatorio > 0) {
                                crear_alerta('warning', '', 'La solicitud de horas supera las disponibles');
                                 $("#hora_1, #hora_2, #n_horas, #horitas, #minutitos").val('');

                            }
                        }
                    }
                }
            });
        } else {
            $("#n_horas").val("");
        }
        $("#n_horas").trigger('keyup');
    });

    //validar de requerido el rango de fechas.
    $("#txtFechaDesde, #txtFechaHasta").change(function(event) {
        var fecha1 = $("#txtFechaDesde").val();
        var fecha2 = $("#txtFechaHasta").val();
        if (fecha1 != "") {
            $.ajax({
                url: urlj + 'acciones_personal/principal/validar_fecha_limite',
                type: 'POST',
                data: { fecha: fecha1 },
                success: function(limitado) {
                    if (limitado > 0) {
                        crear_alerta('error', '', 'Se ha sobrepasado el espacio para procesar permisos de periodos anteriores');
                        $("#txtFechaDesde").val("");
                        if ( $("#fecha_ini_orig").length > 0 ) {
                            $("#txtFechaDesde").val($("#fecha_ini_orig").val());
                        }
                        return false;
                    }
                }
            });
        }
        if (fecha1 != "" && fecha2 != "") {
            if (verifica_fecha(fecha1, fecha2)) {
                if (fecha1 == fecha2) {
                    $(".tiempo").trigger("blur");
                    $(".normal").attr('readonly',true);
                    $(".relojito").timeEntry('enable');
                    $(".mismo_dia").removeAttr('readonly');
                    $("#chk_hora3").iButton("disable", false);
                } else {
                    $("#hora_1, #hora_2").val("");
                    $(".relojito").timeEntry('disable');
                    $(".mismo_dia").attr('readonly',true);
                    $("#chk_hora3").iButton("disable", true);
                    $(".normal").removeAttr('readonly');
                    var dias = dias_entre_fechas(fecha1, fecha2);
                    var horas = (horas_trabajadas_dia * (dias + 1));
                    $("#horitas").val(number_format(horas,0,'.',''));
                    $("#minutitos").val(0);
                    $(".tiempo").trigger("blur");
                }
            }
        }
        // validar_fecha_inicio_fin('txtFechaDesde','txtFechaHasta','La fecha de desde debe ser menor a la fecha hasta'); 
    });

    
    //VALIDACION VALIDATE
    $('#gestion_horas_form').validate({
        ignore: null, 
        ignore: 'input[type="hidden"]',
        rules: {  } ,
        errorPlacement: function (error, element) {
            if($(element).is("select")){
                $(element).next().append(error); 
            } else { 
                error.insertAfter(element);
            }
        },
        submitHandler: function(form) {
            var anxCount = $('#previews tr').length;
            if ($("#thf_recurrentes").val() > 0 && $("#permisos_repetir").is(":visible")) {
                var ev = $("#por_even").is(":visible");
                var fc = $("#por_fech").is(":visible");
                if (ev) {
                    var finaliza = ($("#ctd_fin_rpt").val() != "") ? true : false;
                } else {
                    if (fc) {
                        if ($("#fecha_tipo_fin_rpt").val() != "") {
                            fper = $("#txtFechaHasta").val().split("-").reverse().join("-");
                            ffin = $("#fecha_tipo_fin_rpt").val().split("-").reverse().join("-");
                            if (Date.parse(ffin) > Date.parse(fper)){
                                var finaliza = true;
                            } else {
                                crear_alerta("error","","La fecha final de recurrencia debe ser mayor a la del permiso en si");
                                return false;
                            }
                        } else {
                            var finaliza = false;
                        }
                    } else {
                        var finaliza = false;
                    }
                }
                if ($("#tipo_recurrencia").val()!="" && $("#ctdad_tipo_repite").val()!="" && $("#bkTipoFrec").val()!="" && $("#tipo_fin_repite").val()!="" && finaliza) {
                    if (solicitar_anexos_prm > 0 && anxCount == 0) {
                        alerta_confirm_ajax(enviaForm, 1, 'Alerta de Confirmación', 'No ha agregado ningún anexo.<br /> ¿Éstas seguro que desea continuar?');
                    } else {
                        form.submit();
                    }
                } else {
                    crear_alerta("error", "", "Verifique los datos ingresados para la recurrencia del permiso");
                    return false;
                }
            } else {
                if (solicitar_anexos_prm > 0 && anxCount == 0) {
                    alerta_confirm_ajax(enviaForm, 1, 'Alerta de Confirmación', 'No ha agregado ningún anexo.<br /> ¿Éstas seguro que desea continuar?');
                } else {
                    form.submit();
                }
            }
        } 
    }); 

    function enviaForm(envia) {
        if (envia > 0) {
            wait.start();
            $('#gestion_horas_form')[0].submit();
        }
    }

    //SECCION DE ANEXOS
    var anx = 0;
    var ruta_anx = urlj+'inicio/guardar_gral/anexos_permisos'; 

    new FUload('btnAnexo', ruta_anx, {
        start: function (file) {
            wait.start();
        },
        sucess: function (data) {
            wait.close();
            if ($.trim(data) !== "") {
                var a_exten = $.trim(data).split('.');
                var tipo    = a_exten[(a_exten.length - 1)];
                var exten   = "." + tipo;
                
                var preview = "<tr id='preview" + anx + "' style='display:none;' class='preview_documento'>";
                if (tipo == 'png' || tipo == 'jpg' || tipo == 'jpeg' || tipo == 'pdf') {
                    preview += '<td><a  title="Ver Anexo" class="ver_en_modal fancybox-buttons" data-fancybox-group="button" href="' + urlj 
                    + 'public/temp/anexos_permisos/' + $.trim(data) + '">';
                } else {
                    preview += '<td><a target="_blank" title="Ver Anexo" class="" data-fancybox-group="button" href="' + urlj 
                    + 'public/temp/anexos_permisos/' + $.trim(data) + '">';
                }
                preview += '<img id="pre' + anx + '" src="" width="88" height="88" class="imagen_documento"></a></td>';
                preview += '<td><input maxlength="75" style="width:50%;" class="titulo_documento" type="text" name="titulo_doc[]" value="' + $.trim(data).replace(exten, '') + '">';
                preview += '<span style="display:none;font-size:11px;color:red;margin-top:-10%" class="texto" id="titulo_doc'+ anx + '"></span><br>';
                preview += '<small style="text-align:left;">Nombre del documento</small></td><td style="vertical-align:middle !important; width:30px !important;">';
                preview += '<img style="display:none;" src="' + urlj + 'media/editar_documento.png" title="Editar" value="titulo_doc' + anx + '" class="editar_documento"/></td>';
                preview += '<td style="background:#E1E7F0!important;"><a href="javascript: void(0);" title="Eliminar Anexo" class="eliminar_imagen" id="delete' + anx + '" custom="" custom_id="">';
                preview += '<img class="quitar_documento" src="' + urlj + 'media/eliminar_documento.png" title="Eliminar documento"></a>';
                preview += '<input type="hidden" name="ruta[]" id="ruta' + anx + '"  value="' + $.trim(data) + '" readonly></td></tr>';
                $("#previews").append(preview).show(500);
                $("#awesome_form").append("<input type='hidden' name='ruta[]' id='ruta" + anx + "'  value='" + $.trim(data) + "' readonly></div>");
                $("#preview" + anx).fadeIn(500);
                document.getElementById('pre' + anx).src = urlj + "media/imagenes/sistema/" + tipo + ".png";
                document.getElementById('ruta' + anx).value = $.trim(data);
                document.getElementById('delete' + anx).custom = $.trim(data);
                document.getElementById('delete' + anx).custom_id = i;
                valor = document.getElementById('pre' + anx).src;
                anx++;
                $(".eliminar_imagen, .verAnexo").tooltip();
            } else {
                //el formato es incorrecto
                crear_alerta('error', 'Formato Incorrecto', 'El archivo es inválido');
            }
        }
    });

    $(".eliminar_imagen").live("click", function (event) {
        event.preventDefault();
        url = this.custom;
        id_key = this.custom_id;
        id = this.id;
        $.ajax({
            type: 'POST',
            url: urlj + 'inicio/eliminar_imagen_gral/anx_temporales',
            data: {url: url},
            success: function (data) {
                $("#ruta" + id_key).val("");
                $("#" + id).parent().parent().remove().delay(300);
            }
        });
    });
    
    $(".delete_anexo").live('click', function(event){
        event.preventDefault();        
        var anexo = $(this).data('anexo');
        $("#anexo_"+anexo).remove().delay(500);
    });

    $(".verAnexo").fancybox({
        openEffect  : 'elastic',
        closeEffect : 'elastic',
        href: $(this).attr('href'),
        type: 'iframe',
        helpers : {
            title : {
                type : 'inside'
            }
        }
    });

}); // End Doc.ready

function dias_fecha(fecha_inicio, fecha_fin) {
    dias = 0;
    if (fecha_inicio !='' && fecha_fin !='') {
        fecha1 = fecha_inicio.replace("/", "-").split("-").reverse().join("-") + " 00:00:00";
        fecha2 = fecha_fin.replace("/", "-").split("-").reverse().join("-") + " 23:59:00";
        fechaInicio = new Date(fecha1).getTime();
        fechaFin    = new Date(fecha2).getTime();
        dias = (fechaFin - fechaInicio)/(1000*60*60*24);
    }
    return Math.round(dias);
}

function calculo_horasxdias(fecha_inicio, fecha_fin) {
    horas = 0;
    if (fecha_inicio !='' && fecha_fin !='') {
        $('#txtValidaFecha').val('1');
        nd = dias_fecha($('#txtFechaDesde').val(), $('#txtFechaHasta').val()); //numero de dias
        nd = (nd > 0)? nd:0;
        total_h = nd * horas_trabajadas_dia;
        horas = total_h;
    }
    return horas;
}

function cargarPeriodos(id_pla) {
    if(id_pla > 0){
        $.ajax({
            url: window.gSateliteWhite.baseUrl('acciones_personal/principal/periodos_planilla'),
            type: 'post',
            dataType: 'json',
            data: {
                'idpla': id_pla
            },
            beforeSend: function () {
                $("#contenedor_select_periodo_planilla").html('<select name="periodo_planilla" required id="sinR" style="width:300px;" placeholder="Cargando..."><option value=""></option></select>'); 
                $("#sinR").select2();
            },
            success: function(data) {
                if (data.posee == true) {
                    $("#contenedor_select_periodo_planilla").html(data.select);
                    $("select[name='periodo_planilla']").attr('id', 'periodo_planilla');
                    $("select[name='periodo_planilla']").attr('placeholder', 'Seleccione');
                    $("select[name='periodo_planilla']").attr('class', 'nostyle');
                    $("#periodo_planilla").select2();
                } else {
                    $("#sinR").attr('placeholder', 'Sin Registros');
                    $("#sinR").select2('destroy').select2();
                } 
            }
        });
    } else {
        $("#contenedor_select_periodo_planilla").html('<select name="periodo_planilla" disabled id="periodo_planilla" class="nostyle" placeholder="Seleccione"><option value=""></option></select>');
        $("#periodo_planilla").select2();
    }
}

function hora_limite(input) {
    return {
        minTime: (input.id === 'hora_2' ? $('#hora_1').timeEntry('getTime') : null),  
        maxTime: (input.id === 'hora_1' ? $('#hora_2').timeEntry('getTime') : null)
    }; 
}

function dias_entre_fechas(fecha_ini, fecha_fin){
    var aFecha1 = fecha_ini.split('-'); 
    var aFecha2 = fecha_fin.split('-'); 
    var fFecha1 = Date.UTC(aFecha1[2],aFecha1[1]-1,aFecha1[0]); 
    var fFecha2 = Date.UTC(aFecha2[2],aFecha2[1]-1,aFecha2[0]);
    var dif = fFecha2 - fFecha1;
    var dias = Math.floor(dif / (1000 * 60 * 60 * 24)); 
    return dias;
}

function verifica_fecha(fecha_ini, fecha_fin){
    var fecha_i = fecha_ini.split("-").reverse().join("-");
    var fecha_f = fecha_fin.split("-").reverse().join("-");
    if(Date.parse(fecha_i) > Date.parse(fecha_f)){
        crear_alerta('error', 'Error en Fechas', 'La "Fecha Desde" debe ser menor a la "Fecha Hasta"');
        $("#hora_1, #hora_2, #horitas, #minutitos, #n_horas").val("");
        $(".mismo_dia ,.normal").attr('readonly',true);
        $("#chk_hora3").iButton("toggle", false);
        $("#chk_hora3").iButton("disable", true);
        return false;
    } else {
        return true;
    }
}