$(document).ready(function($){
    $("select").select2({placeholder: 'Seleccione'});
    $(".dias_fecha").datepicker({dateFormat: 'dd-mm-yy',changeMonth: true, changeYear: true});
    $(".dias_fecha").mask("99-99-9999");
    $("#checkAll").hide('slide');
    $("#acciones").hide();

    $("#buscar").click(function(event){
        $("#acciones").hide();
        var fecha_ini = $("#fecha_ini").val();
        var fecha_fin = $("#fecha_fin").val();
        var empleado = $("#empleado").val();
        if (fecha_ini == "" || fecha_fin == "") {
            crear_alerta('warning', 'Período de Fechas', 'Ambas fechas son requeridas.');
            return false;
        }
        verifica_fecha(fecha_ini,fecha_fin);
        if($("#fecha_fin_error").text() == ''){
            $.ajax({
                dataType: 'json',
                type: 'POST',
                url: urlj+'acciones_personal/consultas/rpte_horas_xtras/1',
                data: {
                    fecha_inicio: fecha_ini,
                    fecha_final: fecha_fin,
                    slcempleado: empleado,
                    reporte: ""
                },
                beforeSend: function(){
                    wait.start();
                },
                success: function(data){
                    $("#contenido").html(data.tabla);
                    if(data.filas > 0){
                        $("#fecha_inicio").val(fecha_ini);
                        $("#fecha_final").val(fecha_fin);
                        $("#slcempleado").val(empleado);
                        $("#acciones").show('slow');
                    }
                    setTimeout(function() {$('#checkAll').dataTable();}, 100);
                    $("#contenido").show();
                    wait.close();
                }
            });
        }
    });

    $("#empleado").change(function(event){
        $("#empleado").removeClass('error');
        $("#empleado_error").text('');
    });

    $("#fecha_ini").focus(function(event){
        $("#fecha_ini").removeClass('error');
        $("#fecha_ini_error").text('');
    });

    $("#fecha_fin").focus(function(event){
        $("#fecha_fin").removeClass('error');
        $("#fecha_fin_error").text('');
    });

    function verifica_fecha(fecha_ini, fecha_fin){
        var fecha_i = fecha_ini.split("-").reverse().join("-");
        var fecha_f = fecha_fin.split("-").reverse().join("-");
        if(Date.parse(fecha_i) > Date.parse(fecha_f)){
            $("#fecha_fin").addClass('error');
            $("#fecha_fin_error").text("Verifique las fechas.");
            return false;
        } else {
            $("#fecha_fin").removeClass('error');
            $("#fecha_fin_error").text('');
            return true;
        }        
    }


});